/*
 * dd_error_msg.c : 
 * Upon error there are several possibilities. The user 
 * selects the possibilities by defining environment
 * variables:
 * 
 * 1. DD_ERROR_GARBAGE_D is NOT NULL:
 *          : only the garbage demon reacts upon 
 *            error.
 * 2. DD_ERROR_MSG: is not NULL:
 *            points to the script that is 
 *            executed if error is detected.
 * 3. DD_ERROR_SD: is not NULL:
 *            shuts the system down automatically
 *            (if garbage_d calling dds_close(1), if
 *            not garbage_d sending him DD_SHUTDOWN_SIGNAL
 *
 *
 * Author   :  C.Witzig
 * Date     :  May 29, 1992
 *             first clumsy try
 *          : April 10, 1995:
 *            add environment variables that allow 
 *            user flavor !
 */


#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <dd_sys.h>
#include <dd_user.h>
#include <dd_signal_def.h>
#include <dd_log.h>

void dd_error_inv()
{
  int pid;
  char pname[100], *p2c;
	
  dd_dcom->dd_status  = DD_STATUS_FKDUP;
  dd_dcom->dd_error_proc = getpid();
  sprintf(dd_log_msg, "dd_error_inv: pid %d reports error\n",getpid());
  dd_log(DD_ERROR, dd_log_msg);

/*
 * do we only want the garbage_d to do something??
 */
  if ( (p2c = getenv("DD_ERROR_GARBAGE_D")) != NULL ) {
    if ( dd_dcom->dd_garbage_d_pid != getpid() )
      return;
  }

/*
 * do we want to fork off a program ??
 */
  if ( (p2c = getenv("DD_ERROR_MSG")) != NULL ) {
    if ( (pid = fork() ) == 0 ){
      execlp(p2c,p2c,(char*)NULL);
      exit(0);
    }
    dds_close(1);
  }

/*
 * do we want to close the system down??
 */
  if ( (p2c = getenv("DD_ERROR_SD")) != NULL ) {
    if ( dd_dcom->dd_garbage_d_pid != getpid() ) {
      sprintf(dd_log_msg, "dd_error_inv: proc %d sending DD_SHUTDOWN_SIGNAL to garbage_d\n",getpid());
      dd_log(DD_ERROR, dd_log_msg);
      kill(DD_SHUTDOWN_SIGNAL, dd_dcom->dd_garbage_d_pid);
    }
    else
      printf("dd_error_inv: garbage_d closes DD system\n");
      dds_close(1);
  }
  exit(1);
}


