#ifndef DD_USER_H
#define DD_USER_H

/*
 * dd_user.h : Header file for the general dd_user calls. Has to be present
 *           : in each program that wants to get/put events into the dd
 *           : system.
 * Author    :  C.Witzig
 * Date      :  Apr 3, 1992 
 * Mods      :
 */


#include <fifo.h>
#include <db.h>
#include <dbfi.h>
#include <dd_network.h>
#include <dd_dcom.h>
#include <dd_log.h>

#include <dd_user_entries.h>

extern int dd_attached();
extern int ddu_attached();
extern int ddu_exists();
extern int ddu_attach();
extern int ddu_init(char *fname, struct fifo_mode fmode);
extern int ddu_close();
extern int ddu_start();
extern int ddu_stop();
extern int ddu_set_brc(int brc_flag);
extern int ddu_set_protection(int protection);
extern int ddu_get_free_buffers();
extern int ddu_set_readmode(int readmode);
extern int ddu_fifo_exist(char *fifoname);
extern int ddu_fifo_active(char *fifoname);

extern int ddu_req_fev(int size, struct fifo_entry *fev);
extern int ddu_creq_fev(int size, struct fifo_entry *fev, int cnt);
extern int ddu_put_fev(struct fifo_entry fev);
extern int ddu_ins_fev(struct fifo_entry fev);
extern int ddu_brc_fev(struct fifo_entry fev, int wait_flag);
extern int ddu_rel_fev(struct fifo_entry fev);
extern int ddu_get_fev(struct fifo_entry *fev);
extern int ddu_set_brccmd(int cmd, DD_BRCCMD_FCN brc_cmd_fnc);

extern void dd_cleanup();
extern void dd_error_inv();


#endif
