#ifndef DBFI_H
#define DBFI_H

/*
 * fifo.h   :  Header file for the dbfi calls.
 * Author   :  C.Witzig
 * Date     :  Apr 2, 1992
 * Mods     :
 */

#define BROADCAST_MARKER 0x0f000000
#define DD_BRCCMD_MARKER 0x0abc0000
#define DD_BRCCMD_FIELD  0xffff0000

extern int dbfi_make_fev(int size, struct fifo_entry *fev);
extern int dbfi_free_fev(struct fifo_entry fev);

extern int dbfi_req_fev(int size, struct fifo_entry *fev);
extern int dbfi_get_fev(struct fifo_entry *fev);
extern int dbfi_put_fev(struct fifo_entry fev);
extern int dbfi_ins_fev(struct fifo_entry fev);
extern int dbfi_rel_fev(struct fifo_entry fev);

extern int dbfi_fill_input_fifo();
extern int dbfi_connect();
extern int dbfi_reset();
extern int dbfi_empty_fifo(int which_fifo);
extern int dbfi_link_signal();
extern int dbfi_get_free_buffers();
extern int dbfi_fifo_exist(char *fifoname);
extern int dbfi_fifo_active(char *fifoname);
extern int dbfi_flush(int brc_flush);

extern int fifos_attach(char *filename);
extern int fifos_init();
extern int fifos_unblock();
extern int dbfi_fork_garbage_d();

#endif


