#!/bin/sh
#\
exec $CODA_BIN/dpwish -f "$0" ${1+"$@"}
#

proc draw_menu {} {
    global env argv

    set images_library $env(CODA)/common/images

    set coda_logo [image create photo -file $images_library/gif/RCLogo.gif]

    set w [frame .f1 -bd 2 -relief raised]
   
    label $w.logo -bg grey -padx 0 -pady 0 -image $coda_logo 
    label $w.title -bg grey -padx 0 -pady 0 -text "Display of buffer statistics for [lindex $argv 0]"
    menubutton $w.file -menu $w.file.m -text File -underline 0 \
	-takefocus 0

    menu $w.file.m
    $w.file.m add command -label "Exit     " -command exit -underline 1 \
	-accelerator "Alt+Q"
	
    # Accelerator bindings

    bind all <Alt-q> "exit"
    pack $w.file -in $w -side left
    pack $w.logo -side left  -padx 6 -expand no
    pack $w.title -side left  -padx 6 -expand no
    pack $w -side top -fill x -expand yes
    return $w
}

proc draw_title {} {
    frame .title -relief raised -borderwidth 2
    label .title.a -width 10 -relief ridge -borderwidth 2 \
	-text "Address"
    label .title.t -width 10 -relief ridge -borderwidth 2 \
	-text "total"
    label .title.f -width 10 -relief ridge -borderwidth 2 \
	-text "free"
    label .title.b -width 10 -relief ridge -borderwidth 2 \
	-text "busy"
    label .title.s -width 10 -relief ridge -borderwidth 2 \
	-text "size"
    label .title.i -width 10 -relief ridge -borderwidth 2 \
	-text "incr"
    label .title.k -width 10 -relief ridge -borderwidth 2 \
	-text "KBytes"
    label .title.n -width 20 -relief ridge -borderwidth 2 \
	-text "Name"
    pack .title.a .title.t .title.f .title.b .title.s \
	.title.i .title.k .title.n -in .title -side left
    pack .title -side top
}

proc draw_row {tw row_number} {
  set w [frame $tw.f$row_number]
    label $w.a -width 10 -relief ridge -borderwidth 2
    label $w.t -width 10 -relief ridge -borderwidth 2
    label $w.f -width 10 -relief ridge -borderwidth 2
    label $w.b -width 10 -relief ridge -borderwidth 2
    label $w.s -width 10 -relief ridge -borderwidth 2
    label $w.i -width 10 -relief ridge -borderwidth 2
    label $w.k -width 10 -relief ridge -borderwidth 2
    label $w.n -width 20 -relief ridge -borderwidth 2 

    pack $w.a $w.t $w.f $w.b $w.s \
	$w.i $w.k $w.n -side left
    pack $w -side top
}

proc draw_rows {nrows} {
  set wl ""
  frame $wl.text -bg grey  -height 20 -width 80

  tixScrolledWindow $wl.text.text -scrollbar y -height 400
  
  pack $wl.text.text      -pady 5 -padx 2 -side left -fill both -expand 1
 
  pack .text -side top -expand no
  set w [ $wl.text.text subwidget window]
  for {set i 0} {$i < $nrows} {incr i} {
    draw_row $w $i
  }
  return $w
}

proc update_row {tw row_number values } {
    set w $tw.f$row_number
    
    $w.a config -text "[lindex $values 0]"
    $w.t config -text "[lindex $values 1]"
    $w.f config -text "[lindex $values 2]"
    $w.b config -text "[lindex $values 3]"
    $w.s config -text "[lindex $values 4]"
    $w.i config -text "[lindex $values 5]"
    $w.k config -text "[lindex $values 6]"
    $w.n config -text "[lindex $values 7]"
}    

set tablesize 0
set rowswidget ""

proc update_rows {name} {
  global tablesize rowswidget
  
  if { [catch "DP_ask $name part_stats_all 1" table] == 0 } {
    
    set len [llength $table]
    
    if { $tablesize == 0 } {
      set tablesize $len
      set rowswidget [draw_rows $len]
    }
    
    if { $len > $tablesize } {
      for {set ix $tablesize} {$ix < $len} {incr ix} {
	draw_row $rowswidget $ix
      }
      set tablesize $len
    }
    
    set row 0
    foreach item $table {
      update_row $rowswidget $row $item
      incr row
    }
  }
  dp_after 1000 update_rows $name
}

if {$argc > 0} {
  draw_menu
  draw_title
  update_rows [lindex $argv 0]
} else {
  puts "usage : $argv0 ?component_name?"
  exit
}
