/*----------------------------------------------------------------------------*
 *  copyright (c) 1991, 1992  southeastern universities research association, *
 *                            continuous electron beam accelerator facility   *
 *                                                                            *
 *    this software was developed under a united states government license    *
 *    described in the notice file included as part of this distribution.     *
 *                                                                            *
 * cebaf data acquisition group, 12000 jefferson ave., newport news, va 23606 *
 *      heyes@cebaf.gov   tel: (804) 249-7030    fax: (804) 249-7363          *
 *----------------------------------------------------------------------------*
 * discription: follows this header.
 *
 * author:
 *	graham heyes
 *	cebaf data acquisition group
 *
 * discription : generic readout controller code for vxworks/unix
 * revision history:
 *      $Log: roc_component.c,v $
 *      Revision 2.111  2003/12/24 14:54:51  abbottd
 *         max event size now 40K
 *
 *      Revision 2.110  2002/10/22 13:50:37  abbottd
 *      Update to support output to ET system.
 *
 *      Revision 2.109  1999/12/09 14:09:45  abbottd
 *      Make sure informEB will always send an end event
 *
 *      Revision 2.108  1999/11/22 16:42:12  timmer
 *      new ET api changes
 *
 *      Revision 2.107  1999/08/27 14:22:18  timmer
 *      upgrade to new api for et_open
 *
 *      Revision 2.106  1999/07/19 19:10:33  timmer
 *      use latest ET with remote stuff
 *
 *      Revision 2.105  1999/04/16 19:02:56  timmer
 *      new ET api/capabilities
 *
 *      Revision 2.104  1999/03/19 16:29:48  rwm
 *      trivial reformatting of text.
 *
 *      Revision 2.103  1999/02/01 20:25:28  timmer
 *      changed user interface to hide structs
 *
 *      Revision 2.102  1999/01/08 20:09:45  timmer
 *      upgrade to ET version 3.0
 *
 *      Revision 2.101  1998/11/20 15:50:51  rwm
 *      This one compiles.
 *
 *      Revision 2.100  1998/11/20 15:48:27  rwm
 *      Make the default buffer size larger for Unix roc to get good performance.
 *
 *      Revision 2.99  1998/11/17 19:22:21  abbottd
 *      Added code for byte swapping based on variable bigendian_out
 *
 *      Revision 2.98  1998/11/13 20:10:11  timmer
 *      endian awareness program
 *
 *      Revision 2.97  1998/11/13 18:53:30  abbottd
 *      Modified write_thread to support all other output options (file,debug,none,coda)
 *
 *      Revision 2.96  1998/11/09 15:13:55  timmer
 *      Linux port
 *
 *      Revision 2.95  1998/10/28 19:24:21  abbottd
 *      Fixed bug in printf statement
 *
 *      Revision 2.94  1998/09/18 13:35:19  rwm
 *      Removed periodic print of # ev/buffer.
 *
 *      Revision 2.93  1998/09/11 18:24:18  timmer
 *      migrated to ET2.0
 *
 *      Revision 2.92  1998/09/09 17:59:12  abbottd
 *      changed SEND_BUF_FACTOR to 8 and min buffer size 128KBytes to accomodate 4Meg 68K boards
 *
 *      Revision 2.91  1998/09/02 19:24:33  abbottd
 *      Fix bug with User Events and Ending the ROC properly
 *
 *      Revision 2.90  1998/08/25 20:10:12  rwm
 *      rename bigBuffer to g_bigBuffer. put init of g_bb in function.
 *
 *      Revision 2.89  1998/08/17 20:07:26  timmer
 *      change NEWDD to WITH_ET
 *
 *      Revision 2.88  1998/08/06 20:23:34  timmer
 *      few more NEWDD changes
 *
 *      Revision 2.87  1998/08/06 17:08:50  rwm
 *      Set send buffer sizes for Hall B.
 *
 *      Revision 2.86  1998/08/05 18:43:49  timmer
 *      add NEWDD or ET system mods
 *
 *      Revision 2.85  1998/07/31 17:31:30  abbottd
 *      Fixed out of order End event sending, events/buff calc on 68K ROCs
 *
 *      Revision 2.84  1998/07/31 15:46:41  rwm
 *      Tune buffer size for 68K, ppc ROCs.
 *
 *      Revision 2.83  1998/07/31 12:44:34  heyes
 *      fix control events bug
 *
 *      Revision 2.82  1998/07/30 13:19:56  heyes
 *      change ROC buffer size
 *
 *      Revision 2.81  1998/07/30 13:06:36  heyes
 *      add more stuff to roc_dump and more tests in output_proc
 *
 *      Revision 2.80  1998/07/30 13:01:38  rwm
 *      Fixed test_link.
 *
 *      Revision 2.79  1998/07/27 19:17:55  heyes
 *      added support for xfrag.tcl, turned off evsize debugging in ROC
 *
 *      Revision 2.78  1998/07/27 16:11:26  rwm
 *      *** empty log message ***
 *
 *      Revision 2.77  1998/07/24 19:20:44  heyes
 *      adaptive buffer sizes
 *
 *      Revision 2.76  1998/07/24 15:14:37  heyes
 *      redo the polling loop
 *
 *      Revision 2.75  1998/07/24 15:06:38  rwm
 *      Fixes for test_link.
 *
 *      Revision 2.74  1998/07/24 13:29:16  abbottd
 *      For VxWorks, put in check for memory availability during send buffer Allocation
 *
 *      Revision 2.73  1998/07/21 14:44:20  heyes
 *      auto exit shell
 *
 *      Revision 2.72  1998/07/16 18:48:49  rwm
 *      Removed typo.
 *
 *      Revision 2.71  1998/07/15 19:13:49  heyes
 *      better thread handling at exit of EB or ROC
 *
 *      Revision 2.70  1998/07/13 15:35:52  heyes
 *      fix problem with Reset on unix ROC
 *
 *      Revision 2.69  1998/06/18 12:24:58  heyes
 *      change fifo depth in ROC
 *
 *      Revision 2.68  1998/06/17 13:17:54  rwm
 *      Parameterized send buffer sizes, fixed routines to check for memory corruption.
 *
 *      Revision 2.67  1998/06/05 04:34:39  rwm
 *      Added debuggin malloc for output buffers, tried to fix event_count.
 *
 *      Revision 2.66  1998/06/04 14:50:11  heyes
 *      send events in buffer to EB
 *
 *      Revision 2.65  1998/06/04 14:12:09  rwm
 *      Various msgQ fixes...
 *
 *      Revision 2.64  1998/06/03 19:35:20  rwm
 *      Fixed typo
 *
 *      Revision 2.63  1998/06/03 19:32:56  heyes
 *      debug for randy
 *
 *      Revision 2.62  1998/06/03 18:35:57  heyes
 *      Will this never be fixed?
 *
 *      Revision 2.59  1998/06/03 17:15:24  rwm
 *      Tuning for faster rate. Only 2 send buffers.  Fix LINK_sized_read.
 *
 *      Revision 2.58  1998/05/29 17:37:59  rwm
 *      Fixes for message Queue controlled write thread. Mostly works now. Now use SEND_BUF_MARGIN as the data output buffer threshold. Some indentation changes also.
 *
 *      Revision 2.57  1998/05/27 13:45:09  heyes
 *      add message Q to ROC, improve EB stability on EBD transition
 *
 *      Revision 2.54  1998/05/04 17:26:04  heyes
 *      new ROC
 *
 *      Revision 2.53  1998/03/09 18:56:22  heyes
 *      the fastest EB in the galaxy
 *
 *      Revision 2.52  1998/03/06 15:05:18  heyes
 *      new faster multi-thread EB
 *
 *      Revision 2.50  1998/02/23 20:32:31  heyes
 *      add multi_mode to EB
 *
 *      Revision 2.49  1998/02/23 20:30:47  heyes
 *      add multi_mode to EB
 *
 *      Revision 2.48  1998/01/29 19:23:50  abbottd
 *      Fixed bug in token_handler for multiple ROCs/Tokens
 *
 *      Revision 2.47  1998/01/28 14:44:06  abbottd
 *      Removed MultiThread changes for now - fixed bug in token_handler for non-broadcast tokens.
 *
 *      Revision 2.46  1998/01/28 13:45:45  heyes
 *      Multi thread, well almost, the writes
 *
 *      Revision 2.45  1998/01/27 17:09:48  heyes
 *      fix crash when ROC object deleted
 *
 *      Revision 2.44  1998/01/27 13:07:01  heyes
 *      add delay factor to ROC
 *
 *      Revision 2.43  1998/01/15 20:35:01  heyes
 *      fix cvs problem
 *
 *      Revision 2.41  1997/12/03 14:04:29  heyes
 *      idle_method
 *
 *      Revision 2.40  1997/11/17 13:53:01  abbottd
 *      Changed token_handler to ignore tokens it already has
 *
 *      Revision 2.39  1997/11/13 21:10:44  abbottd
 *      Support for Local envionment Variables in Readout list name
 *
 *      Revision 2.38  1997/11/13 19:22:49  heyes
 *      add broadcast mode
 *
 *      Revision 2.37  1997/11/13 18:28:17  heyes
 *      add broadcast mode
 *
 *      Revision 2.36  1997/10/21 15:01:39  heyes
 *      look in *_class for unknown procs
 *
 *      Revision 2.35  1997/10/02 18:04:30  abbottd
 *          Some changes for for coda and binary file handling
 *
 *      Revision 2.34  1997/09/19 14:26:17  heyes
 *      final commit before France!
 *
 *      Revision 2.30  1997/09/18 19:16:14  heyes
 *      final commit before France!
 *
 *      Revision 2.29  1997/09/12 18:26:32  heyes
 *      changed a lot of stuff
 *
 *      Revision 2.28  1997/09/05 12:06:57  heyes
 *      almost final
 *
 *      Revision 2.27  1997/08/28 19:18:40  heyes
 *      add nodelay
 *
 *      Revision 2.26  1997/07/23 14:25:01  heyes
 *      add @ trick to filename parsing
 *
 *      Revision 2.25  1997/06/20 16:58:25  heyes
 *      *** empty log message ***
 *
 *      Revision 2.24  1997/06/20 15:29:55  abbottd
 *      Added support for User events/added dalogmsg and suppressed printfs
 *
 *      Revision 2.23  1997/06/17 19:52:17  abbottd
 *      Added support for passing user events (type>31) to output
 *
 *      Revision 2.22  1997/06/17 13:27:44  heyes
 *      fix rolP->inited
 *
 *      Revision 2.20  1997/06/11 00:02:52  heyes
 *      add dd to ROC
 *
 *      Revision 2.19  1997/06/10 18:58:08  heyes
 *      add DD to ROC
 *
 *      Revision 2.18  1997/06/07 19:32:16  heyes
 *      fix for linux
 *
 *      Revision 2.17  1997/06/06 14:59:36  heyes
 *      fooling with linux
 *
 *      Revision 2.16  1997/05/19 19:39:50  heyes
 *      fixed ER multi restart problem
 *
 *      Revision 2.15  1997/04/25 18:58:00  abbottd
 *      added some daLogMsg calls
 *
 *      Revision 2.14  1997/03/06 13:40:00  abbottd
 *      fixes for writing to a file and updating token_interval at Prestart
 *
 *      Revision 2.13  1997/02/25 18:49:18  heyes
 *      add error recovery to ROC and EB ./coda_roc -s ghtest -t ROC -n ROC2 -i -r
 *
 *      Revision 2.12  1997/02/13 20:33:42  heyes
 *      help text
 *
 *      Revision 2.11  1997/02/12 15:32:10  heyes
 *      add version method
 *
 *      Revision 2.10  1997/02/12 14:31:30  heyes
 *      tcl_modules variable
 *
 *      Revision 2.9  1997/02/11 20:14:40  heyes
 *      error in coda_component.c
 *
 *      Revision 2.8  1997/02/11 20:02:07  heyes
 *      tedious isn't it...
 *
 *      Revision 2.6  1997/01/16 15:30:41  heyes
 *      Increase speed of EB, inc. changes after Dec run.
 *
 *      Revision 2.5  1996/10/31 15:54:25  abbottd
 *      Changed rocp->active levels for polling, output options
 *
 *      Revision 2.4  1996/10/31 13:49:08  heyes
 *      active==1 in none
 *
 *      Revision 2.3  1996/10/29 19:13:46  abbottd
 *      VxWorks support modifications
 *
 *      Revision 2.2  1996/10/17 14:30:07  heyes
 *      fix EB end problem
 *
 *      Revision 2.1  1996/09/19 12:32:08  heyes
 *      Fix extra tokens when ending bug...
 *
 *      Revision 2.0  1996/09/06 17:20:25  heyes
 *      changed booted to configured
 *
 *      Revision 1.11  1996/09/05 12:52:36  heyes
 *      check cvs symlink
 *
 *
 *      Revision 1.9  1996/08/30 13:29:26  heyes
 *      final version of rclite
 *
 *----------------------------------------------------------------------------*/

#include "da.h"

#ifdef VXWORKS

 #include "errno.h"
 #include "errnoLib.h"
 extern long     vxTicks;
 char           *sysmodel ();
 static int      dalf;
 #define ulong  unsigned long

#else

 /* vxworks isn't quite unix yet */
 #include <stdlib.h>
 #include <sys/types.h>
 #include <stdio.h>
 #include <sys/time.h>
 #include <errno.h>
 #include <string.h>
 #include <pthread.h>
 #include <dlfcn.h>
 #include <sys/mman.h>

 #ifdef __sun
  #include <sys/processor.h>
  #include <sys/procset.h>
  #include <sys/lwp.h>
  #include <sys/priocntl.h>
  #include <sys/rtpriocntl.h>
  #include <sys/tspriocntl.h>
  static int     go_rt(int pri, int tp, int id);
 #endif

 #define error -1
 #define ld_no_address 0
 typedef int     (*funcptr) ();

#endif

/* Non Standard Tcl disribution headers */
#include <tclStruct.h>

#include "rc.h"
#include "rolInt.h"

extern long     rcdebug_level__;				     /* global debug flag */

extern Tcl_Interp *Main_Interp;

typedef struct roc_private_store *rocParam;

typedef struct roc_private_store {
  ROLPARAMS      *rolPs[3];				     /* pointers to readout lists */
  int             meanBufSz;				     /* mean size of buffer to allocate */
  int             async_roc_flag;			     /* if ne 0 then roc communication with eb inhibited */
  int             recNb;				     /* number of records sent by this ROC */
  int             test_mode;				     /* if there is no rol then set test_mode */
  int             active;				     /* set to 1 if we are supposed to take data */
  long            end_range;				     /* set to last event number in group of events to go to a
							      * particular target */
  long            no_token;				     /* we need a new token */
  ROLPARAMS      *primaryRol;				     /* first rol in chain */
  int             state;				     /* current state as a numeric value */
  int             last_event;				     /* number of last event sent on network */
  int             primefd;
  char           *prime;
  char *output_type;
  char *filename;
  char *current_file;
  int output_switch;
  int buffer_method;
  int randy_factor;                                          /* Delay sending "super event" for this 
								number of events*/
  char *first;
}               roc_priv;

#define USE_BIG_BUFFERS  0
#define USE_SMALL_BUFFERS 1

int rocMask = 0;

#ifdef VXWORKS
SEM_ID write_mutex;
#else
pthread_mutex_t write_mutex;
#endif

#ifdef VXWORKS
static int doing_zbuf = FALSE;
#endif

static long     clear_to_send = 0;
static long     rol1_events = 0;
static long     rol2_events = 0;

static int      tokenfd[256];
static int      tokenid[256];
static int      tokenrg[256];

char            next_roc_token[256][256];
char           *next_roc;
int             got_next_roc;

static unsigned char tokenhead = 0;
static unsigned char tokentail = 0;

static int      tokens = 0;
static Tk_TimerToken polling_token;
static Tk_TimerToken network_token;

/* Global Symbols */
int             token_interval;
unsigned long   last_token;
void           *output_proc;
extern int     bigendian;
int            bigendian_out = 1;

#define MAX_IOVEC_BUFS 2000

static struct iovec iov[MAX_IOVEC_BUFS];	/* structure holding pointers to events and lengths */
static struct iovec iov2[3];
static DANODE  *NodeList[MAX_IOVEC_BUFS + 1];
static int      bufcnt = 2;
static int      bytes = 0;
void           *output_proc;

typedef struct thread_args {
  int fd;
  unsigned long *buf;
  unsigned long nbytes;
  int dofree;
  int output_switch;
} TRARGS;

typedef struct thread_args *trArg;

#ifdef VXWORKSPPC
/* for PPC */
# define SEND_BUF_FACTOR              8
# define MAX_EV_FACTOR                1
#else
/* for Unix */
# ifndef VXWORKS68K51
#  define SEND_BUF_FACTOR              16
#  define MAX_EV_FACTOR                2
# else
/* for 68K */
#  define SEND_BUF_FACTOR              1
#  define MAX_EV_FACTOR                2
# endif
#endif

#define BASE_SEND_BUF_SIZE          ( 128 * 1024)

#ifndef VXWORKS68K51
/* The default is: */
#define SEND_BUF_SIZE             ( SEND_BUF_FACTOR * BASE_SEND_BUF_SIZE )
#define SEND_BUF_MARGIN             buffer_margin
#define SEND_BUF_MIN_MARGIN         49152
#define SEND_MALLOC_EXTRA           1024
#else
/* For 68k boards. */
#define SEND_BUF_SIZE             ( SEND_BUF_FACTOR * BASE_SEND_BUF_SIZE )
#define SEND_BUF_MARGIN             buffer_margin
#define SEND_BUF_MIN_MARGIN         20480
#define SEND_MALLOC_EXTRA           1024
#endif

#define INITIAL_DELTA (SEND_BUF_SIZE - 2 * SEND_BUF_MIN_MARGIN)/2

static int buffer_delta  = INITIAL_DELTA;
static int buffer_margin = SEND_BUF_MIN_MARGIN;

#define TOTAL_SEND_BUF_SIZE       ( SEND_MALLOC_EXTRA + SEND_BUF_SIZE + SEND_MALLOC_EXTRA )
#define NUM_SEND_BUFS               4  /* must be a power of two. */
#define SEND_BUF_INIT_VALUE       ( (unsigned long) 0xF0F0F0F0 )

typedef struct g_big_buf {
  unsigned long *first;
  unsigned long *buf_first;
  unsigned long *buf_off_end;
  unsigned long *off_end;
  int           sendBufSize;
} bbuf_t;

bbuf_t g_bbuf[NUM_SEND_BUFS];

static output_buffers_initialized = FALSE;
static unsigned long *g_bigBuffer[NUM_SEND_BUFS] = { (unsigned long *) NULL,
						   (unsigned long *) NULL,
						   (unsigned long *) NULL,
						   (unsigned long *) NULL };

unsigned long full_send_buf = 0;

static int g_max_ev_in_buf = 32;
static unsigned long g_events_in_buffer = 0;

static int whichBuf = 0;
static unsigned long *dabufp;
static unsigned long *dabufps;
static unsigned long dataInBuf = 12;

static int sending = 0;
static int write_failure = 0;
static int doclose = 0;

#ifndef VXWORKS

#ifdef BUGBUG
#include <msq_util.h>
#endif

#include "fifo_lock.c" 

mq_t outputQueue;
#else
#    include  <msgQLib.h>		/* Message queue definitions. */
#    ifdef VxMP
#        include  <msgQSmLib.h>		/* Shared message queue definitions. */
#    endif

static MSG_Q_ID  outputQueue;		/* System ID for the message queue. */
void *MQEND = (void *) 0xffffffff;

#endif

/* #define IDLE_METHOD */


extern void     output_proc_network (struct alist * output, void *junk);

/*********** ET Stuff ************/
#include <time.h>
#include <et_private.h>
#define ET_EVENT_ARRAY_SIZE_MAX  NUM_SEND_BUFS*4
static et_event		*etevents[ET_EVENT_ARRAY_SIZE_MAX];
extern char		et_name[ET_FILENAME_LENGTH];
static et_sys_id	et_sys;
static et_att_id	et_attach;
static int		et_eventsize;
static int		event2put = 0, neventsnew = 0;
static int		et_init = 0, et_reinit = 0;


/*********** ET Initialization ************/
static int et_initialize(void) {
  et_openconfig   openconfig;
  struct timespec timeout;
  int status=0;
  int sendbufsize = TOTAL_SEND_BUF_SIZE;

  timeout.tv_sec  = 5;
  timeout.tv_nsec = 0;

  /* Normally, initialization is done only once. However, if the ET
   * system dies and is restarted, and we're running remotely or on
   * a Linux operating system, then we need to re-initalize in
   * order to reestablish the tcp connection for communication etc.
   */
  if (et_init > 0) {
    /* unmap shared mem, detach attachment, close socket, free et_sys */
    et_forcedclose(et_sys);
  }

  if (et_open_config_init(&openconfig) != ET_OK) {
    printf("roc ET init: cannot allocate mem to open ET system\n");
    daLogMsg ("ERROR", "roc ET init: cannot allocate mem to open ET system");
    return TCL_ERROR;
  }
  et_open_config_setwait(openconfig, ET_OPEN_WAIT);
  et_open_config_settimeout(openconfig, timeout);
#ifdef VXWORKS
  et_open_config_sethost(openconfig,ET_HOST_REMOTE);
  et_open_config_setcast(openconfig,ET_BROADCAST);
#endif
  if (et_open(&et_sys, et_name, openconfig) != ET_OK) {
    daLogMsg ("ERROR", "roc ET init: cannot open ET system");
    return TCL_ERROR;
  }

  /* Dump the config structure - We do not need it anymore */
  et_open_config_destroy(openconfig);

  /* Set level of debug output */
  et_system_setdebug(et_sys, ET_DEBUG_ERROR);

  if ((status=et_station_attach(et_sys, ET_GRANDCENTRAL, &et_attach)) < 0) {
    et_close(et_sys);
    daLogMsg ("ERROR", "roc ET init: cannot attach to ET station status=%d",status);
    return TCL_ERROR;
  }

  /* Find out event size in this ET system */
  if (et_system_geteventsize(et_sys, &et_eventsize) != ET_OK) {
    et_close(et_sys);
    daLogMsg ("ERROR", "roc ET init: cannot find event size in ET system");
    return TCL_ERROR;
  }
  /* Check if et_system is setup for large buffers */
  if(et_eventsize < sendbufsize) {
    et_close(et_sys);
    daLogMsg ("ERROR", "roc ET init: ET system event size (%d bytes) is smaller than ROC output buffers (%d bytes)",
	      et_eventsize, sendbufsize);
    return TCL_ERROR;
  }

  et_init++;
  et_reinit = 0;
  daLogMsg("INFO", "roc ET init: ET fully initialized");
  return TCL_OK;
}

/*******************************************************/

#ifdef __sun
static int
go_rt(int pri, int tp, int id)
{
  pcinfo_t            pcinfo;
  pcparms_t           pcparms;
  
  int stat;
  printf("attempt to lock process in core\n");
  stat = mlockall(MCL_CURRENT|MCL_FUTURE);
  if (stat) {
    perror("ERROR: mlockall :");
  } else {
    printf("   Process locked in memory\n");
  }
  strcpy(pcinfo.pc_clname, "RT");
  if (priocntl(0, 0, PC_GETCID, (caddr_t)&pcinfo) == -1) {
    perror("ERROR: get RT class ID");
    return(-2);
  }
  pcparms.pc_cid = pcinfo.pc_cid;
  ((rtparms_t *)pcparms.pc_clparms)->rt_pri = pri;
  ((rtparms_t *)pcparms.pc_clparms)->rt_tqsecs = 0;
  ((rtparms_t *)pcparms.pc_clparms)->rt_tqnsecs = RT_TQINF;
  printf("Thread id %d going REAL TIME!!\n",id);
  if (priocntl(tp,id,PC_SETPARMS,(caddr_t)&pcparms) == -1) {
    perror("ERROR: Set RT Parms");
    return(-1);
  }
  return(0);
}
#endif

TCL_PROC (check_bb)
{
  int i;
#define STMP_LEN 1024
  char stmp[STMP_LEN];
  unsigned long * pB_F0;
  unsigned long * pB_end;

  if (output_buffers_initialized == TRUE) { 

    Tcl_AppendResult (interp, 
		      "* # * first      * g_bigBuffer[i] * buf_first  * buf_off_end * off_end *\n",
		      (char *) NULL);

    for (i=0; i < NUM_SEND_BUFS; i++) {
      memset(stmp, 0, STMP_LEN);
      sprintf(stmp, "* %d * 0x%8X *  0x%8X  * 0x%8X * 0x%8X  * 0x%8X    *\n",
			i, g_bbuf[i].first, g_bigBuffer[i], g_bbuf[i].buf_first, 
			g_bbuf[i].buf_off_end, g_bbuf[i].off_end);

      Tcl_AppendResult (interp, stmp, (char *) NULL);

      Tcl_AppendResult (interp, "* Checking before real buffer.\n", (char *) NULL);

      pB_F0 = g_bbuf[i].first;
      pB_end = g_bbuf[i].buf_first;
      while( pB_F0 < pB_end) {
	if ( *pB_F0 != SEND_BUF_INIT_VALUE) {
	      Tcl_AppendResult (interp, "Error: address = %8X, value = %8X.\n", 
				pB_F0, *pB_F0, (char *) NULL);
	}
	pB_F0++;
      }

      Tcl_AppendResult (interp, "* Checking after real buffer.\n", (char *) NULL);
      pB_F0 = g_bbuf[i].buf_off_end;
      pB_end = g_bbuf[i].off_end;
      while( pB_F0 < pB_end) {
	if ( (*pB_F0) != SEND_BUF_INIT_VALUE) {
	  Tcl_AppendResult (interp, "ERROR: address = %8X, value = %8X.\n", pB_F0, *pB_F0,
			    (char *) NULL);
	}
	pB_F0++;
      }
    }
  } else {
    Tcl_AppendResult (interp, "global output buffers not yet allocated.\n", (char *) NULL);
    return TCL_ERROR;
  }
  return TCL_OK;
}


TCL_PROC (roc_dump)
{
  int             flag;
  char            temp[1000];

  rocParam        rocp = (rocParam) object->private;

  flag = 0;
  if (argc != 1) {
    Tcl_AppendResult (interp, "wrong # args: should be \"", argv[0], "\"", (char *) NULL);
    return TCL_ERROR;
  }
  sprintf (temp, "Component: '%s' Object: '%s'\n", object->name, object->className);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "Readout list names: '%s'\n\n", Tcl_GetVar (interp, "rols", 0));
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "ROC state         : %8d, Active Level       : %8d\n", rocp->state, rocp->active);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "End Range         : %8d, Last Event Sent    : %8d\n", rocp->end_range, rocp->last_event);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "Run type          : %8d, run number         : %8d\n", object->runType, object->runNumber);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "Event Number      : %8d\n", object->nevents);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "rol1 events       : %8d, rol2 events        : %8d\n", rol1_events,rol2_events);
  Tcl_AppendResult (interp, temp, (char *) NULL);

  sprintf (temp, "clear to send     : %8d, dataInBuf          : %8d\n", clear_to_send,dataInBuf);
  Tcl_AppendResult (interp, temp, (char *) NULL);

  sprintf (temp, "g_events_in_buffer: %8d, g_max_ev_in_buf    : %8d\n", g_events_in_buffer,g_max_ev_in_buf);
  Tcl_AppendResult (interp, temp, (char *) NULL);

#ifdef VXWORKS
  sprintf (temp, "message queue     : %8d, outputQueue        : %8x\n", msgQNumMsgs (outputQueue),outputQueue);
  Tcl_AppendResult (interp, temp, (char *) NULL);
#endif

  return TCL_OK;
}

TCL_PROC (roc_rol_dump)
{
  char            temp[1000];

  ROLPARAMS      *rolP = (ROLPARAMS *) object;

  sprintf (temp, "Readout list name : '%s'\n", rolP->listName);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "User string       : '%s'\n", rolP->usrString);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "ROC ID            : %8d\n", rolP->pid);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "ROL module id     : %08x\n", rolP->id);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "Last daproc exec  : %d\n", rolP->daproc);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "Run type          : %8d, run number         : %8d\n", rolP->runType, rolP->runNumber);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "rolP     pointer  : %08x, __init__  pointer  : %08x\n", rolP, rolP->rol_code);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "Output   pointer  : %08x, Input  pointer     : %08x\n", rolP->dabufp, rolP->dabufpi);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "Pool     part     : %08x\n", rolP->pool);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "Input    part     : %08x, Output  part       : %08x\n", rolP->input, rolP->output);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "Dispatch part     : %08x, DispQ   part       : %08x\n", rolP->dispatch, rolP->dispQ);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "Event    number   : %8d\n", *rolP->nevents);
  Tcl_AppendResult (interp, temp, (char *) NULL);
  sprintf (temp, "rolP->doDone      : %8d\n", rolP->doDone);
  Tcl_AppendResult (interp, temp, (char *) NULL);

  return TCL_OK;
}

TCL_PROC (token_debug)
{
  char            temp[100];

  rocParam        rocp = (rocParam) object->private;

  int             ix;

  sprintf (temp, "tokenhead %d, tokentail %d (token interval %d)\n",
	   tokenhead,
	   tokentail,
	   token_interval
	   );
  Tcl_AppendResult (interp, temp, (char *) NULL);

  for (ix = 0; ix < 32; ix++) {

    if (ix == tokenhead) {
      sprintf (temp, "%3d:H:", ix);
    } else if (ix == tokentail) {
      sprintf (temp, "%3d:T:", ix);
    } else {
      sprintf (temp, "%3d: :", ix);
    }
    sprintf (&temp[6], "%3d %3d %10d %s\n", tokenfd[ix], tokenid[ix], tokenrg[ix], next_roc_token[ix]);
    Tcl_AppendResult (interp, temp, (char *) NULL);
  }
  sprintf (temp, "no_token %d, end_range %d, last %d\n",
	   rocp->no_token,
	   rocp->end_range,
	   object->nevents);

  Tcl_AppendResult (interp, temp, (char *) NULL);

  /*
   * if (listCount(&object->output->list)) { sprintf(temp,"count %d,
   * number %d\n", listCount(&object->output->list),
   * listFirst(&object->output->list)->nevent); } else {
   * sprintf(temp,"Output is empty\n"); }    Tcl_AppendResult(interp,
   * temp, (char *) NULL);
   */
  return TCL_OK;
}

int LINK_support_Init(Tcl_Interp *interp)
{
  char tmp[400];
  sprintf(tmp,"%s {%s} %s {%s}",
	  __FILE__,
	  DAYTIME,
	  CODA_USER,
	  "NO LINK_support.c in coda_roc any more !!");
  Tcl_SetVar (interp, "tcl_modules",tmp,TCL_LIST_ELEMENT|TCL_APPEND_VALUE|TCL_GLOBAL_ONLY);
  
}

TCL_PROC(LINK_constructor_C)
{
  return TCL_OK;
}

TCL_PROC(LINK_destructor_C)
{
  return TCL_OK;
}

TCL_PROC(LINK_process_data)
{
  return TCL_OK;
}

TCL_PROC(LINK_thread_init)
{
  return TCL_OK;
}

TCL_PROC(LINK_queue_name)
{
  return TCL_OK;
}

TCL_PROC(LINK_get_outputH)
{
  return TCL_OK;
}

TCL_PROC(LINK_fifo_status)
{
  return TCL_OK;
}

void 
write_thread(void *dummy)
{
  static int length, status, cnt = 0;
  static int buf[128];
  int res, nev, err;
  trArg args;
  /* ET stuff */
  et_event *bigevent;
  
  bzero(buf,sizeof(buf));

  do {
#ifdef VXWORKS
    length = msgQReceive (outputQueue, (char *) &args, sizeof(args), WAIT_FOREVER) ;
    if ((length == ERROR) ||  (args == (void *) MQEND)) {
      break;
    }
#else
    if ((args = mq_get(outputQueue)) == (void *) MQEND) {
      printf("end of file on queue\n");
      break;
    }
#endif

#ifdef DEBUG_MSGQ
    printf("RCV args=%X: fd %d buf %08x bytes %d\n",args, args->fd, args->buf, args->nbytes);
#endif

    /* Switch on Output option chosen */
    switch(args->output_switch) {
    case 1:  /* Output to binary file (file) */
      if (args->nbytes) {
	int len = args->nbytes - 12; /* event Length is minus Record header */
	if(!bigendian_out)
	  CODA_bswap(&(args->buf[3]),(len>>2));
	res = write(args->fd, (char *) &(args->buf[3]),len);
	if (res < len) {
	  printf("ERROR: write_thread failed in write: res = %d, write(%d,0x%x,%d)\n",
		 res,args->fd,&args-buf[3],len);
	  write_failure = 1;
	  free(args);
	}
      }
      break;
    case 2:  /* Output to standard output (debug) */
      {
	int ix, iz, tlen, len;
	int indx;

	
	tlen = (args->nbytes)>>2;
	nev = args->buf[2];
	indx = 3;

	printf("ROC Debug Output: rocID = %d, Record = %d, Events in Record = %d\n",
	       args->buf[1],args->buf[0],args->buf[2]);

	for(iz=0;iz<nev;iz++) {
	  if(indx > tlen) {
	    printf("ERROR: Record is corrupted: indx = %d, tlen = %d\n",indx,tlen);
	    break;
	  }
	  len = (args->buf[indx])+1;  /* Note CODA bank length is non-inclusive */
	  
	  if (len > 64) len = 64;
	
	  for (ix=0;ix<len;ix++) {
	    if ((ix % 8) == 0 ) printf("\n%3d : ",ix);
	    printf("%08x ",args->buf[indx+ix]);
	  }
	  indx += len;
	}
      }
      printf("\n\n");
      break;
    case 3:  /* Output to NULL (none) */
      /* printf("Output to NULL: dumping %d bytes\n",args->nbytes); */
      break;
    case 4:  /* Ouptut to CODA file (coda) */
      {
	int ix, iz, tlen, len;
	int indx;

	tlen = (args->nbytes)>>2;
	nev = args->buf[2];
	indx = 3;

	for(iz=0; iz<nev; iz++) {
	  if (indx > tlen) {
	    printf("ERROR: Record is corrupted: indx = %d, tlen = %d\n",indx,tlen);
	    break;
	  }
	  len = (args->buf[indx])+1;  /* Note CODA bank length is non-inclusive */

	  res = evWrite(args->fd,&(args->buf[indx]));
	  if (res < 0) {
	    printf("ERROR: write_thread failed in evWrite: res = %d, evErite(%d,0x%x)\n",
		   res,args->fd,&args-buf[3]);
	    write_failure = 1;
	    free(args);
	  }
	  indx += len;
	}
      }
      break;
    case 5:  /* Output to ET System (dd) */
      {
	write_failure = 0;

	/* if we've run out of available events, ask for more */
	if (event2put > neventsnew-1) {
	  neventsnew = 0;
	  event2put  = 0;
	  /* asking for a chunk of normal sized events but do not allocate space
             ROC data buffers are already allocated */
	  err = et_events_new(et_sys, et_attach, etevents,
                              ET_SLEEP|ET_NOALLOC, NULL, et_eventsize,
                              ET_EVENT_ARRAY_SIZE_MAX, &neventsnew);
	  if (err != ET_OK) {
	    printf("ERROR: write_thread failed in et_events_new\n");
	    et_reinit = 1;
	    write_failure = 1;
	    free(args);
	    return;
	  }
        }
	
	/* Check to see if this is an Extra Large event.
	   If so then get a temporary event to handle it */
	if (args->nbytes > et_eventsize) {
	  /* ask for a single temp/large event */
	  err = et_event_new(et_sys, et_attach, &bigevent,
                             ET_SLEEP|ET_NOALLOC, NULL, args->nbytes);
	  if (err != ET_OK) {
	    printf("ERROR: write_thread failed in et_events_new for big event\n");
	    neventsnew = 0;
	    event2put = 0;
	    et_reinit = 1;
	    write_failure = 1;
	    free(args);
	    return;
	  }
	  
	  /*memcpy(bigevent->pdata, (const void *) args->buf, args->nbytes);*/
	  et_event_setdatabuffer(et_sys, bigevent, &(args->buf[3]));
	  et_event_setcontrol(bigevent,&(args->buf[0]),3);
	  et_event_setlength(bigevent,(args->nbytes - 12));
	  err = et_event_put(et_sys, et_attach, bigevent);

	} else {  /* Use a standard event */

	  /*memcpy(etevents[event2put]->pdata, (const void *) args->buf, args->nbytes);*/
	  et_event_setdatabuffer(et_sys, etevents[event2put],&(args->buf[3]));
	  et_event_setcontrol(etevents[event2put],&(args->buf[0]),3);  /* Put Record Header in Control words */
	  et_event_setlength(etevents[event2put],(args->nbytes - 12));
	  err = et_event_put(et_sys, et_attach, etevents[event2put]);
	  event2put++;
        }
	
	if (err != ET_OK) {
	  printf("ERROR: write_thread failed in et_events_put\n");
	  neventsnew = 0;
	  event2put = 0;
	  et_reinit = 1;
	  write_failure = 1;
	  free(args);
	  return;
	}
      }
      break;

    default: /* Output to Network (EB)  */
      write_failure = 0;

      /* printf("write_thread: args = %08X, fd = %d, buf[0] = %d,  buf[1] = %d\n",
	 args,args->fd, args->buf[0],args->buf[1]); */

      /* setsockopt (args->fd, SOL_SOCKET, SO_SNDBUF, 
       * (const char *) &args->nbytes, sizeof (args->nbytes)); 
       */

      /* printf("--> buffer is (%08x %08x %08x %08x %08x %08x %08x %08x)\n", */
      /*       args->buf[0],args->buf[1],args->buf[2],args->buf[3], */
      /*       args->buf[4],args->buf[5],args->buf[6],args->buf[7]); */

      if (recv(args->fd, (void *)buf, 128, 0) <= 0 ) {
	write_failure = 1;
	printf("ERROR; write_thread failed (in recv).\n");
	free(args);
	return;
      }
      if(!bigendian_out) {    /* Swap the data received from the EB */
	int lwd, i;
	for(i=0;i<32;i++) {
	  lwd = LSWAP(buf[i]);
	  buf[i] = lwd;
	}
      }
#ifdef NEVER_DEFINED
      if ((cnt%50) == 0) {
	{
	  int i;
	  printf("Start---------------------\n  ");
	  for (i=0;i<32;i++) {
	    if (i & 7 == 0) printf("\n  ");
	    printf ("r%02d=%5d ",i,buf[i]);
	  }
	  printf("\n");
	}
      }
#endif
      {
    	int i,evsz;
    	evsz = 0;
    	for (i=0;i<32;i++) {
	  if (buf[i] > 0 && buf[i] > evsz) evsz = buf[i];
    	}
    	
    	if (evsz > 0) {
	  /* bugbug : Dave doesn't like this but we need to run. */
	  g_max_ev_in_buf = ( MAX_EV_FACTOR*SEND_BUF_SIZE - SEND_BUF_MARGIN ) / ( 4 * evsz);
	  
	  /* 	  if ((cnt%50) == 0) { */
	  /* 	    printf("max is %d words = %d ev/buf\nDone ------------------------\n",evsz */
	  /* 		   ,g_max_ev_in_buf); */
	  /* 	  } */
	  
    	} else {
	  g_max_ev_in_buf = 64;
    	}
      }
      if(!bigendian_out) {
	unsigned long lwd, jj;
	int llen = (args->nbytes - 12)>>2;
	for (jj=0;jj<3;jj++) {                   /* Swap the record header */
	  lwd = LSWAP(args->buf[jj]);
	  args->buf[jj] = lwd;
	}
	CODA_bswap(&(args->buf[3]),llen);    /* Swap the CODA data */
      }
      if (sized_write(args->fd, args->buf, args->nbytes) < 0) {
	write_failure = 1;
	printf("ERROR: write_thread failed (in sized_write).\n");
	free(args);
	return;
      }
      
    }  /* end of switch(args->output_switch) */

    if (args->dofree) {
      free(args->buf);
    }
    free(args);
    sending = 0;
    cnt++;


  } while (1);
  
  printf("WRITE THREAD EXIT\n");
  doclose = 1;
}


TCL_PROC (roc_constructor)
{
  int             ix,res;
  rocParam        rocp;

  if (argc < 1) {
    Tcl_AppendResult (interp, "wrong # args: should be \"", argv[0], "\"", (char *) NULL);
    return TCL_ERROR;
  }
  
#ifdef VXWORKS
/*   write_mutex = semMCreate(SEM_Q_FIFO | SEM_INVERSION_SAFE); */
  write_mutex = semBCreate(SEM_Q_FIFO, SEM_FULL);
  if (write_mutex == NULL) {
    printf("roc_constructor could not allocate a semaphore. EXITING.\n");
    exit(-1);
  }


#else
  pthread_mutex_init (&write_mutex,NULL);
  #ifdef __sun
    thr_setconcurrency(20);
  #endif
#endif

  /* tell anyone watching */
  {
    char tmp[400];
    
    sprintf(tmp,"%s {%s} %s {%s}",
	    __FILE__,
	    DAYTIME,
	    CODA_USER,
	    "$Id: roc_component.c,v 2.111 2003/12/24 14:54:51 abbottd Exp $");
    Tcl_SetVar (interp, "tcl_modules",tmp,TCL_LIST_ELEMENT|TCL_APPEND_VALUE|TCL_GLOBAL_ONLY);
  }

  rocp = object->private = (void *) ckalloc (sizeof (roc_priv));

  bzero ((char *) object->private, sizeof (roc_priv));

  libPartInit ();

  {
    char            tmp[40];

    sprintf (tmp, "%s:pool", object->name);
    object->pool = (ROL_MEM_PART *) partCreate (tmp, 32, 4, 0);

#ifdef TEST
    sprintf (tmp, "%s:test", object->name);
    object->test = (ROL_MEM_PART *) partCreate (tmp, 100000, 128, 0);
#endif

    sprintf (tmp, "%s:output", object->name);
    object->output = (ROL_MEM_PART *) partCreate (tmp, 0, 0, 0);

#if defined(VxMP)
        outputQueue = msgQSmCreate (4, 4, MSG_Q_FIFO) ;
        if (outputQueue == NULL) { 
            printf("can't open message queue\n");
            return (TCL_ERROR) ;
        }
#elif defined(VXWORKS)
	/* bugbug: the depth of the queue could be NUM_SEND_BUFS - 2. but playing it safe...*/
        outputQueue = msgQCreate (4, 4, MSG_Q_FIFO) ;
        if (outputQueue == NULL) {
           
            printf("can't open message queue\n");
            return (TCL_ERROR) ;
        }
#else
    outputQueue = mq_new();
#endif
  }
  memset ((char *) tokenfd, -1, sizeof (tokenfd));
  memset ((char *) tokenrg, 0, sizeof (tokenrg));

  rocp->no_token = 1; 

  {
    extern int roc_token_handler ();
    Tcl_CreateCommand(interp,"token_handler",roc_token_handler,object,NULL);
  }

  Tcl_LinkVar (interp, "TS::rocMask",
	       (char *) &rocMask,
	       TCL_LINK_INT);

  Tcl_LinkVar (interp, "ROC::bigendian_out",
	       (char *) &bigendian_out,
	       TCL_LINK_INT);

  Tcl_LinkVar (interp, "ROC::randy_factor",
	       (char *) &rocp->randy_factor,
	       TCL_LINK_INT);

  Tcl_LinkVar (interp, "ROC::async_roc",
	       (char *) &rocp->async_roc_flag,
	       TCL_LINK_INT);

  Tcl_LinkVar (interp, "ROC::got_next_roc",
	       (char *) &got_next_roc,
	       TCL_LINK_INT);

  Tcl_LinkVar (interp, "ROC::first",
	       (char *) &rocp->first,
	       TCL_LINK_STRING);

  Tcl_LinkVar (interp, "ROC::next",
	       (char *) &next_roc,
	       TCL_LINK_STRING);

  Tcl_LinkVar (interp, "ROC::prime",
	       (char *) &rocp->prime,
	       TCL_LINK_STRING);

  Tcl_LinkVar (interp, "ROC::output_type",
	       (char *) &rocp->output_type,
	       TCL_LINK_STRING);

  Tcl_LinkVar (interp, "ROC::output_file",
	       (char *) &rocp->filename,
	       TCL_LINK_STRING);

  Tcl_LinkVar (interp, "ROC::current_file",
	       (char *) &rocp->current_file,
	       TCL_LINK_STRING);

  if (Tcl_Eval (interp, "set output_type network; set output_file none; status booted") != TCL_OK)
    return TCL_ERROR;

#ifdef ALOG_DEBUG
  ALOG_SETUP (object->codaid, ALOG_TRUNCATE);
#endif

  return TCL_OK;
}

TCL_PROC (roc_destructor)
{
  ROLPARAMS      *rolP;

  int             ix;

  rocParam        rocp;

  if (object == NULL)
    return TCL_OK;

  rocp = (rocParam) object->private;

  Tcl_UnlinkVar (interp, "TS::rocMask");
  Tcl_UnlinkVar (interp, "ROC::bigendian_out");
  Tcl_UnlinkVar (interp, "ROC::randy_factor");
  Tcl_UnlinkVar (interp, "ROC::async_roc");
  Tcl_UnlinkVar (interp, "ROC::got_next_roc");
  Tcl_UnlinkVar (interp, "ROC::first");
  Tcl_UnlinkVar (interp, "ROC::next");
  Tcl_UnlinkVar (interp, "ROC::prime");
  Tcl_UnlinkVar (interp, "ROC::output_type");
  Tcl_UnlinkVar (interp, "ROC::output_file");
  Tcl_UnlinkVar (interp, "ROC::current_file");

  if (rocp) {
    /* delete old lists, free up memory etc... */

    if (rocp->rolPs[0] != NULL) {
      /* Must have called download once before */
      for (ix = 0; (rolP = rocp->rolPs[ix]) != NULL; ix++) {
	/* Delete buffer pools */
	if (rolP->inited) {
	  rolP->daproc = DA_FREE_PROC;
	  (*(rolP->rol_code)) (rolP);
	}
	/* unload module if possible */

	if ((rolP->id != 0) && (rolP->nounload == 0)) {
	  daLogMsg ("INFO", "Unloading old ROL object module %x ", rolP->id);

#if defined(VXWORKS)
	  if (unldByModuleId (rolP->id) == ERROR) {
	    close (dalf);
	    daLogMsg ("ERROR", "failed to unload old list %d ", rolP->id);
	    Tcl_AppendResult (interp, "failed to unload list ", rolP->tclName, (char *) NULL);
	    return TCL_ERROR;
	  }
#elif defined __sun || LINUX
	  if (dlclose ((void *) rolP->id) != 0) {
	    Tcl_AppendResult (interp, "failed to unload list ", rolP->tclName, (char *) NULL);
	    return TCL_ERROR;
	  }
#else
	  daLogMsg ("WARN", "dynamic loading not yet supported on this platform\n");
#endif
	}
	if (Tcl_VarEval (interp,
			 "set rols \"\" ", (char *) NULL) != TCL_OK)
	  return TCL_ERROR;
	ckfree (rolP->usrString);
	ckfree (rolP);
	rocp->rolPs[ix] = NULL;
      }
    }
    partFreeAll ();
    ckfree ((char *) rocp);
  }
  return TCL_OK;
}

void 
add_cmd ()
{
  printf ("hello\n");
}

int 
setup_output_buffers(void) 
{
  /* The roc will buffer events contiguously in these output buffers. */
  /* There are NUM_SEND_BUFS buffers. */

  /* For each buffer there is SEND_MALLOC_EXTRA bytes extra memory
   * allocated before and after the memory actually used to buffer data.
   * All the allocated memory is initialized to SEND_BUF_INIT_VALUE,
   * so that we can check for memory corruption using check_bb.
   */

  int i;
  unsigned long * pB_tmp;
  unsigned long * pB_end;
  int maxAvailBytes = 0;
  int sendBufSize = 0;
  int tsendBufSize = 0;

#ifdef VXWORKS
  /* Does VxWorks have enough memory for output buffers? */
  maxAvailBytes = memFindMax();
  if (maxAvailBytes > (TOTAL_SEND_BUF_SIZE * NUM_SEND_BUFS)) {
    tsendBufSize = TOTAL_SEND_BUF_SIZE;
  } else {
    tsendBufSize = maxAvailBytes/NUM_SEND_BUFS;
    daLogMsg("WARN","Reducing Standard Send Buffer Allocation, maxAvailBytes = %d",maxAvailBytes);
  }
  sendBufSize = (tsendBufSize/NUM_SEND_BUFS) - 2*SEND_MALLOC_EXTRA;
#else
  maxAvailBytes = TOTAL_SEND_BUF_SIZE * NUM_SEND_BUFS;
  tsendBufSize = TOTAL_SEND_BUF_SIZE;
  sendBufSize = SEND_BUF_SIZE;
#endif 

  for (i=0; i < NUM_SEND_BUFS; i++) {
    /* bugbug: malloc extra memory for debugging. */

    g_bigBuffer[i] = (unsigned long *) malloc(tsendBufSize);

    if (g_bigBuffer[i] == NULL) {
      daLogMsg("ERROR","Buffer allocation FAILED");
      return -1;
    }

    /* Initialize g_bigBuffer. */
    pB_tmp = g_bigBuffer[i];
    printf("Buffer pointer at 0x%x\n", pB_tmp);
    pB_end = pB_tmp + (tsendBufSize/ sizeof(unsigned long));
    while (pB_tmp < pB_end) {
      *pB_tmp = SEND_BUF_INIT_VALUE;
      pB_tmp++;
    }
  }

  /* make the g_bigBuffer pointer to the middle of the buffer.... */
  for (i=0; i < NUM_SEND_BUFS; i++) {
    g_bbuf[i].first = g_bigBuffer[i];
    g_bigBuffer[i] += (SEND_MALLOC_EXTRA/sizeof(unsigned long));
    g_bbuf[i].buf_first = g_bigBuffer[i];
    g_bbuf[i].buf_off_end = 
      g_bigBuffer[i] + (sendBufSize/sizeof(unsigned long));
    g_bbuf[i].off_end = 
      g_bbuf[i].first + ((tsendBufSize)/sizeof(unsigned long));
    g_bbuf[i].sendBufSize = sendBufSize;
  }
  return 0;
}

/*
 * This routine is called by the RC system to handle DOWNLOAD.
 * 
 * Put here the code to handle downloading the readout list and calling the user
 * download list.
 */

TCL_PROC (roc_download)
{
  char            tmp[1000];

  rocParam        rocp;

  ROLPARAMS      *rolP;

  char           *Merged_rols;

#ifdef VXWORKS
  SYM_TYPE        sType;

#endif

  int             res,
    ix;

  if (argc != 2) {
    Tcl_AppendResult (interp,
		      "wrong # args: should be \"",
		      argv[0],
		      " ?config? \"",
		      (char *) NULL);
    return TCL_ERROR;
  }
  rocp = (rocParam) object->private;

  daLogMsg ("INFO", "Downloading configuration \"%s\"", argv[1]);

  if (Tcl_VarEval (interp, "set config ", argv[1], (char *) NULL) != TCL_OK)
    return TCL_ERROR;

  /* delete old lists, free up memory etc... */

  if (rocp->rolPs[0] != NULL) {
    /* Must have called download once before */

    /* First Cancel all DoWhenIdle calls made since last download */

#ifdef IDLE_METHOD
    Tk_CancelIdleCall ((Tk_IdleProc *) output_proc, (void *) &object->output->list);
#else
    Tk_DeleteTimerHandler (network_token);
#endif

    /*
     * Now loop through all existing readout lists and delete/free
     * them
     */
    for (ix = 0; (rolP = rocp->rolPs[ix]) != NULL; ix++) {
      /* Delete buffer pools */
      if (rolP->inited) {
	rolP->daproc = DA_FREE_PROC;
	(*(rolP->rol_code)) (rolP);
      }
      partFree (rolP->dispatch);
      partFree (rolP->dispQ);
      partFree (rolP->pool);
      /* Free Input partions only for Secondary readout lists */
      if (ix > 0)
	partFree (rolP->input);

      /* unload module if possible */

      if ((rolP->id != 0) && (rolP->nounload == 0)) {
	daLogMsg ("INFO", "Unloading old ROL object module %x ", rolP->id);

#if defined(VXWORKS)
	if (unldByModuleId (rolP->id) == ERROR) {
	  close (dalf);
	  daLogMsg ("ERROR", "failed to unload old list %d ", rolP->id);
	  Tcl_AppendResult (interp, "failed to unload list ", rolP->tclName, (char *) NULL);
	  return TCL_ERROR;
	}
#elif defined __sun||LINUX
	if (dlclose ((void *) rolP->id) != 0) {
	  Tcl_AppendResult (interp, "failed to unload list ", rolP->tclName, (char *) NULL);
	  return TCL_ERROR;
	}
#else
	daLogMsg ("WARN", "dynamic loading not yet supported on this platform\n");
#endif
      }
      if (Tcl_VarEval (interp,
		       "set rols \"\" ", (char *) NULL) != TCL_OK)
	return TCL_ERROR;
      ckfree (rolP->usrString);
      ckfree (rolP);
      rocp->rolPs[ix] = NULL;
    }
  }

  /*
   * Get the run type number and save it somewhere safe.
   */

  sprintf (tmp,
	   "database query {select id from runTypes where name='%s'}",
	   argv[1]);

  if (Tcl_Eval (interp, tmp) != TCL_OK)
    return TCL_ERROR;

  if (Tcl_Eval (interp, "database get next") != TCL_OK)
    return TCL_ERROR;

  if (Tcl_GetInt (interp, interp->result, &object->runType) == TCL_ERROR) {
    sprintf(interp->result,"run type %s dos not exist\n",argv[1]);
    return TCL_ERROR;
  }

  /*
   * Get the token Interval (ROC record size) from the configuration
   * options table of the database
   */
  sprintf (tmp,
	   "database query {select value from %s_option where name='tokenInterval'}",
	   argv[1]);

  if (Tcl_Eval (interp, tmp) != TCL_OK)
    return TCL_ERROR;

  if (Tcl_Eval (interp, "database get next") != TCL_OK)
    return TCL_ERROR;

  if (Tcl_GetInt (interp, interp->result, &token_interval) == TCL_ERROR)
    token_interval = 64;

  if (token_interval <= 0)
    token_interval = 64;

  /*
   * Check that we should be in this configuration.
   */
  sprintf (tmp,
	   "database query {select name from %s where name='%s'}",
	   argv[1],
	   object->name);

  if (Tcl_Eval (interp, tmp) != TCL_OK)
    return TCL_ERROR;

  if (Tcl_Eval (interp, "database get next") != TCL_OK)
    return TCL_ERROR;

  strcpy (tmp, interp->result);
  if ((strcmp (tmp, "{}") == 0)||(strcmp (tmp, "") == 0)) {
    daLogMsg ("ERROR", "This component is not used in run type %s\n", argv[1]);
    return TCL_ERROR;
  }

  /*
   * Get the list of readout-lists from the database.
   */
  sprintf (tmp,
	   "database query {select code from %s where name='%s'}",
	   argv[1],
	   object->name);

  if (Tcl_Eval (interp, tmp) != TCL_OK)
    return TCL_ERROR;

  if (Tcl_Eval (interp, "database get next") != TCL_OK)
    return TCL_ERROR;

  strcpy (tmp, interp->result);

  /*
   * Decode configuration string...
   */
  if (!((strcmp (tmp, "{}") == 0)||(strcmp (tmp, "") == 0))) {
    char            tmp2[1000];

    int             listArgc, ix, jx, tmpArgc;

    char          **listArgv, listArgv2[40][100];

    char          **tmpArgv, *tmpArgv2[2];

    char            ObjInitName[100],
      name[20];

    Struct_Object   objbuf;

    ROL_MEM_PART  **last_output;

    TCL_PROC (roc_dodone);

    /* Get rid of leading and trailing Braces */
    strncpy ((char *) &tmp2[0], (char *) &tmp[1], (strlen (tmp) - 2));
    tmp2[(strlen (tmp) - 2)] = '\0';

    if (Tcl_SplitList (interp, tmp2, &listArgc, &listArgv) != TCL_OK) {
      Tcl_AppendResult (interp, "failed to split list ", tmp2, (char *) NULL);
      return TCL_ERROR;
    }
    last_output = (ROL_MEM_PART **) NULL;

    for (ix = 0, jx = 0; ix < listArgc; ix += 1, jx += 1) {

      /* storage for readout list parameters */

      rolP = (ROLPARAMS *) ckalloc (sizeof (ROLPARAMS));
      bzero ((char *) rolP, sizeof (ROLPARAMS));
      bzero ((char *) ObjInitName, 100);

      rocp->rolPs[jx] = rolP;			     /* null terminated list of readout lists */

      /* Split list into rol object file and user string */

      if (Tcl_SplitList (interp, listArgv[ix], &tmpArgc, &tmpArgv) != TCL_OK) {
	Tcl_AppendResult (interp, "failed to split list ", listArgv[ix], (char *) NULL);
	return TCL_ERROR;
      }

      /*
       * Decode any Local environment variables and Get object filename 
       * in order to find the ROLs __init routine
       */
      if (tmpArgc == 2) {
	char           *p1, *p2;
	int            nchar = 0;

	if ((p1 = strstr(tmpArgv[0], "$env")) != NULL) {
	  printf("ROL Object Name has local environment variables\n");
	  Tcl_VarEval(interp,"global env;","set aa ",tmpArgv[0],(char *) NULL);
	  tmpArgv2[0] = ckalloc(strlen(interp->result)+1);
	  strcpy(tmpArgv2[0],interp->result);
	} else {
	  tmpArgv2[0] = ckalloc(strlen(tmpArgv[0])+1);
	  strcpy(tmpArgv2[0],tmpArgv[0]);
	}
	daLogMsg("INFO"," Downloading readout list  %s ",tmpArgv2[0]);

	if ((p2 = strstr(tmpArgv[1], "$env")) != NULL) {
	  printf("ROL User string has local environment variables\n");
	  Tcl_VarEval(interp,"global env;","set bb ",tmpArgv[1],(char *) NULL);
	  tmpArgv2[1] = ckalloc(strlen(interp->result)+1);
	  strcpy(tmpArgv2[1],interp->result);
	} else {
	  tmpArgv2[1] = ckalloc(strlen(tmpArgv[1])+1);
	  strcpy(tmpArgv2[1],tmpArgv[1]);
	}
	/* printf("tmpArgv2[1] = %s \n",tmpArgv2[1]); */
    	
	if ((p1 = strrchr (tmpArgv2[0], '/')) == 0)
	  p1 = tmpArgv2[0];
	if ((p2 = strrchr (tmpArgv2[0], '.')) == 0)
	  p2 = tmpArgv2[0];
	nchar = (p2 - p1) - 1;
	if (nchar > 0) {
	  ObjInitName[0] = '_';
	  strncpy (&ObjInitName[1], (p1 + 1), nchar);
	  strcat (ObjInitName, "__init");
	}
      } else {
	daLogMsg ("ERROR", " Incorrect number of Arguments passed for ROL = %d\n", tmpArgc);
	return TCL_ERROR;
      }

      /* set up a Tcl command to point to our object */
      sprintf (name, "rol%d", jx);
      if (Tcl_VarEval (interp, "lappend rols ", name, NULL) != TCL_OK)
	return TCL_ERROR;

      Tcl_CreateCommand (interp,
			 name,
			 (Tcl_CmdProc *) roc_rol_dump,
			 (ClientData) rolP,
			 NULL);

      /* set parent component name in readout list */

      rolP->name = object->name;
      strcpy (rolP->tclName, name);

      /* Setup pointers to global ROC information */
      rolP->nevents = (ulong *) & object->nevents;
      rolP->async_roc = &(rocp->async_roc_flag);

      /*
       * Load the readout list
       */

#if defined(VXWORKS)
      dalf = open ((char *) tmpArgv2[0], 0, 0);

      if (dalf == ERROR) {
	daLogMsg ("ERROR", "open failed with status=%d for rol: %s ",dalf,tmpArgv2[0]);
	Tcl_AppendResult (interp, "unable to open readout list: ",
			  tmpArgv2[0], (char *) NULL);
	return TCL_ERROR;
      }
      /* load the readout list */
      rolP->id = (void *) loadModuleAt (dalf, GLOBAL_SYMBOLS, NULL, NULL, NULL);

      close (dalf);

#elif defined __sun||LINUX
      rolP->id = dlopen ((char *) tmpArgv2[0], RTLD_NOW | RTLD_GLOBAL);
      if (rolP->id == 0)
	daLogMsg ("ERROR", "dlopen failed on rol: %s \n", dlerror ());
#else
      daLogMsg ("WARN", "dynamic loading not supported\n");
      rocp->test_mode = 1;
      if (Tcl_VarEval (interp, "status downloaded",
		       (char *) NULL) != TCL_OK)
	return TCL_ERROR;
      return TCL_OK;
#endif

      if (rolP->id == NULL) {
	Tcl_ResetResult (interp);
	Tcl_AppendResult (interp, " unable to load readout list: ",
			  listArgv[ix], (char *) NULL);
	return TCL_ERROR;
      }
      rolP->nounload = 0;

#if defined(VXWORKS)

#if defined(VXWORKSPPC)
      res = (long) symFindByName (sysSymTbl, &ObjInitName[1], &rolP->rol_code, &sType);
#else
      res = (long) symFindByName (sysSymTbl, ObjInitName, &rolP->rol_code, &sType);
#endif

      if ((res != ERROR))
#else
	res = (long) dlsym (rolP->id, &ObjInitName[1]);
      rolP->rol_code = (VOIDFUNCPTR) res;
      if ((res != (-1)) && (res != 0))
#endif

	{
	  daLogMsg ("INFO", "%s() routine found", ObjInitName);
	} else {
	  daLogMsg ("ERROR", "%s() routine not found", ObjInitName);
	  Tcl_ResetResult (interp);
	  Tcl_AppendResult (interp, "<ObjName>__init() routine not found in: ",
			    tmpArgv2[0], (char *) NULL);
	  return TCL_ERROR;
	}
      daLogMsg ("INFO", "readout list loaded ");

      /*
       * call download routine from readout list..
       */
      {
	int res;
	recoverContext ("usrDownload",res);
	if (res) {
	  daLogMsg ("ERROR", "Fatal error detected.state BOOTED");
	  Tcl_ResetResult (interp);
	  Tcl_AppendResult (interp,
			    "ERROR", "Fatal error detected.state BOOTED\n",
			    (char *) NULL);
	  return TCL_ERROR;
	}
      }
      /*
       * Initialize rol parameters structure, memory
       * partitions
       */

      rolP->daproc = DA_INIT_PROC;
      rolP->pid = object->codaid;
      (*(rolP->rol_code)) (rolP);
      if (rolP->inited != 1) {
	rocp->state = DA_CONFIGURED;
	daLogMsg ("ERROR","ROL initialization failed");
	return TCL_ERROR;
      }

      /* Now Execute Users Download procedure */

      rolP->usrString = ckalloc (strlen (tmpArgv2[1]) + 2);
      strcpy (rolP->usrString, tmpArgv2[1]);
      rolP->daproc = DA_DOWNLOAD_PROC;
      (*(rolP->rol_code)) (rolP);
      lastContext ();

      /* link this readout list to previous one */

      if (last_output) {
	char            tmpname[40];

	sprintf (tmpname, "%s:input", rolP->listName);

	*last_output = rolP->input = (ROL_MEM_PART *) partCreate (tmpname, 0, 0, 0);

	partFree (rolP->output);	     /* free pre-allocated output */

	last_output = &rolP->output;	     /* next time round this is previous output */
      } else {

	/*
	 * we have no input therfore we are the primary
	 * readout list.
	 */
	rocp->primaryRol = rolP;

	last_output = &rolP->output;	     /* next time round this is previous output */
      }
      /* rolP->pool->free_cmd = (VOIDFUNCPTR) roc_dodone;
      rolP->pool->clientData = (void *) rolP; */
      ckfree ((char *) tmpArgv);		     /* Free up Split List pointer */
      ckfree (tmpArgv2[0]);	                     /* Free up decoded rol object name pointer */
      ckfree (tmpArgv2[1]);	                     /* Free up decoded userstring pointer */
    }

    *last_output = object->output;			     /* link last list to ROC */
    ckfree ((char *) listArgv);

    daLogMsg ("INFO", "downloaded");

  } else {
    daLogMsg ("WARN", "no readout lists in current configuration");
  }

  rocp->state = DA_DOWNLOADED;

  rocp->active = 0;

  partReInitAll();

  memset ((char *) tokenfd, -1, sizeof (tokenfd));
  memset ((char *) tokenrg, 0, sizeof (tokenrg));
  memset ((char *) next_roc_token, 0, sizeof (next_roc_token));
  rocp->no_token = 1;
  rocp->end_range = 0;
  rocp->last_event = 0;
  last_token = 0;
  tokentail = 0;
  tokenhead = 0;


  output_proc = (void *) output_proc_network;

  if (output_buffers_initialized == FALSE) { 
    if (setup_output_buffers() != 0) {
      return TCL_ERROR;
    }
    output_buffers_initialized = TRUE;

    dabufp = &g_bigBuffer[0][3];
    printf("dabufp set to 0x%x\n",dabufp);
  }

  rocp->active = 1;
  
  object->output->list.clientData = (void *) object;
  
#ifdef IDLE_METHOD
  Tk_DoWhenIdle ((Tk_IdleProc *) output_proc, (void *) &object->output->list);
#else
  network_token = Tk_CreateTimerHandler (2, (Tk_TimerProc *) output_proc, (ClientData) & object->output->list);
#endif
  
  if (Tcl_VarEval (interp, "status downloaded",
		   (char *) NULL) != TCL_OK) {
    return TCL_ERROR;
  }

  return TCL_OK;
}

TCL_PROC (roc_token_handler)
{
  FILE           *filePtr;

  rocParam        rocp;

  int             endrange,eblast, lockKey;

  rocp = (rocParam) object->private;

  if (rocp->active == 0)
    return TCL_OK;

  if (Tcl_VarEval (interp,
		   argv[1],
		   " cget -link",
		   (char *) NULL) != TCL_OK)
    return TCL_ERROR;

  if (Tcl_GetOpenFile (interp, interp->result, 1, 1, &filePtr) != TCL_OK) {
    return TCL_ERROR;
  }
  if (Tcl_GetInt (interp, argv[2], (int *) &endrange) == TCL_ERROR) {
    return TCL_ERROR;
  }
  
  if ((rocp->state == DA_DOWNLOADED) && (endrange > 1)) { /* We already ended so ignore tokens */
    printf("Ignoring Extra Token From EB : %s\n",argv[2]);
    return TCL_OK;
  }
  
  if (argv[4][0] == '2') {
    int tok,last_range = last_token/token_interval;
    
    /*if (rocp->end_range >= ((endrange + 4) * token_interval)) { 
      printf("Ignoring Duplicate Token : %s\n",argv[2]);
      return TCL_OK;      
      }*/

    for (tok = last_range+1;tok < endrange+4;tok++) {
      tokenhead = (tok - 1) & 31;
      tokenfd[tokenhead] = fileno (filePtr);
      tokenid[tokenhead] = atoi (argv[3]);
      last_token = token_interval*tok;
      tokenrg[tokenhead] = last_token;
      sprintf (next_roc_token[tokenhead], "token_handler %s %s %s %s", argv[1], argv[2], argv[3], argv[4]);
    }

  } else {
    if (rocp->end_range >= (endrange * token_interval)) {  /* We already got this token before */
      printf("Ignoring Duplicate Token : %s\n",argv[2]);
      return TCL_OK;      
    }
    
    tokenhead = (endrange - 1) & 31;
    tokenfd[tokenhead] = fileno (filePtr);
    tokenid[tokenhead] = atoi (argv[3]);
    last_token = token_interval*endrange;
    tokenrg[tokenhead] = last_token;
    sprintf (next_roc_token[tokenhead], "token_handler %s %s %s %s", argv[1], argv[2], argv[3], argv[4]);
  }
  
  if ((argv[4][0] == '0') && (got_next_roc)) {
    if (Tcl_VarEval (Main_Interp,
		     "DP_tell ",
		     next_roc,
		     " ",
		     next_roc_token[tokenhead],
		     (char *) NULL) != TCL_OK) {
      printf ("ERROR in DP_tell: %s\n", Main_Interp->result);
      return;
    }
  }
  
  return TCL_OK;
}

TCL_PROC (token_handler_udp)
{
  FILE           *filePtr;

  rocParam        rocp;

  int             endrange, lockKey;
  static int      sock = -1;

  if (sock == -1) {
    if (Tcl_GetOpenFile (interp, interp->result, 1, 1, &filePtr) != TCL_OK) {
      return TCL_ERROR;
    }
    sock = fileno (filePtr);
  }

  rocp = (rocParam) object->private;

  if (rocp->active == 0)
    return TCL_OK;
  
  /*
   * a state of ENDING means that we are flushing buffers after an end

  if (rocp->state == DA_ENDING)
    return TCL_OK;
   */

#ifdef ALOG_DEBUG
  ALOG_LOG (object->codaid, 2, tokens++, "str");
#endif
  if (Tcl_VarEval (interp,
		   argv[1],
		   " cget -link",
		   (char *) NULL) != TCL_OK)
    return TCL_ERROR;

  if (Tcl_GetOpenFile (interp, interp->result, 1, 1, &filePtr) != TCL_OK) {
    return TCL_ERROR;
  }
  if (Tcl_GetInt (interp, argv[2], (int *) &endrange) == TCL_ERROR) {
    return TCL_ERROR;
  }

#ifdef MULTIPLE_TOKENS
  /*printf("token %d\n", endrange); */
  if ((rocp->state == DA_DOWNLOADED) && (endrange > 5)) {
    return TCL_OK;
  }
  if (rocp->end_range >= (endrange * token_interval)) {  /* We already got this token before */
    printf("Got Second Token : %s\n",argv[2]);
    return TCL_OK;      
  }
  if (rocp->first && (rocp->first[0] == 'y')) { 
    int tok;
    for (tok = 0; tok <2; tok++ ) { 
      tokenhead = (endrange - 1 + tok) & 31;
      tokenfd[tokenhead] = fileno (filePtr);
      tokenid[tokenhead] = atoi (argv[3]);
      tokenrg[tokenhead] = (endrange + tok) * token_interval;
      sprintf (next_roc_token[tokenhead], "token_handler %s %d %s", argv[1], endrange + tok, argv[3]); 
      if (Tcl_VarEval (Main_Interp,
		       "DP_tell ",
		       next_roc,
		       " ",
		       next_roc_token[tokenhead],
		       (char *) NULL) != TCL_OK) {
	printf ("ERROR in DP_tell: %s\n", Main_Interp->result);
	return;
      }
    }
  } else {
    tokenhead = (endrange - 1) & 31;
    tokenfd[tokenhead] = fileno (filePtr);
    tokenid[tokenhead] = atoi (argv[3]);
    tokenrg[tokenhead] = endrange * token_interval;
    sprintf (next_roc_token[tokenhead], "token_handler %s %s %s", argv[1], argv[2], argv[3]);
  }
#else
  if ((rocp->state == DA_DOWNLOADED) && (endrange > 1)) { /* We already ended so ignore tokens */
    return TCL_OK;
  }
  if (rocp->end_range >= (endrange * token_interval)) {  /* We already got this token before */
    return TCL_OK;      
  }
  tokenhead = (endrange - 1) & 31;
  tokenfd[tokenhead] = fileno (filePtr);
  tokenid[tokenhead] = atoi (argv[3]);
  last_token = endrange * token_interval;
  tokenrg[tokenhead] = last_token;
  sprintf (next_roc_token[tokenhead], "token_handler %s %s %s %s", argv[1], argv[2], argv[3], argv[4]);

  if ((argv[4][0] == '0') && (got_next_roc)) {
    if (Tcl_VarEval (Main_Interp,
		     "DP_tell ",
		     next_roc,
		     " ",
		     next_roc_token[tokenhead],
		     (char *) NULL) != TCL_OK) {
      printf ("ERROR in DP_tell: %s\n", Main_Interp->result);
      return;
    }
  }
#endif
  /*printf ("token_handler %s %s %s %s\n", argv[1], argv[2], argv[3], argv[4]);*/
  
#ifdef ALOG_DEBUG
  {
    char            tmp[100];

    sprintf (tmp, "ert%d", endrange);
    ALOG_LOG (object->codaid, 42, endrange, "srt");
  }
#endif

  return TCL_OK;
}

/******************************************************************************
 *
 * This routine informs the EB of state changes in a particular ROC
 * the EB may change its own state to reflect fault conditions...
 */

void
informEB (object, mTy, mA, mB)
objClass        object;

unsigned long   mTy,
  mA,
  mB;
{
  unsigned long *data,len;
#ifdef VXWORKS
  int             old = intLock ();
#endif
  rocParam        rocp = (rocParam) object->private;
  int res;
  unsigned long id;
  trArg args = malloc(sizeof(struct thread_args)); 
  args->buf = malloc(32);

  args->dofree = 1;
  args->output_switch = rocp->output_switch;

  args->buf[0] = -1;
  args->buf[1] = object->codaid;
  args->buf[2] = 1; 
  args->buf[3] = 4;
  args->buf[4] = CTL_BANK_HDR (mTy);			     /* header */
  args->buf[5] = 1200;					     /* some junk */
  args->buf[6] = mA;					     /* parameter a */
  args->buf[7] = mB;					     /* parameter b */
    
  args->fd = rocp->primefd;
  args->nbytes = 32;
#ifdef DEBUG_MSGQ
  printf("SND args (informEB) = %X: fd %d buf %08x bytes %d\n",args, args->fd, args->buf, args->nbytes);
#endif
  
#ifdef VXWORKS 
 { 
   int status;
   if ((msgQNumMsgs (outputQueue) < 2)||(mTy == EV_END)) {
     status = msgQSend (outputQueue, (char *) &args, 4,
			WAIT_FOREVER, MSG_PRI_NORMAL) ;
     printf("informEB: msgQSend done...\n");
     
     if (status == ERROR) {
       printf("informEB: error from msgQSend.\n");
     }
   } else {
     printf("can't send control event, would block ROC\n");
   }
   
 }
#else
  mq_put(outputQueue,args);
#endif

#ifdef VXWORKS
  intUnlock (old);
#endif
}

#define MEGA_BYTE (1024 * 1024)

TCL_PROC (roc_test_link)
{
  unsigned long *data,len;
  rocParam        rocp = (rocParam) object->private;
  int res;
#ifdef MSG_WAITALL
  int recv_flags = MSG_WAITALL;
#else
  int recv_flags = 0;
#endif
  static int buf[128];
  int num_mb, num_buffers;
  unsigned long id, ix;
  trArg args = NULL;
  double start_time, end_time;

#ifdef VXWORKS
  int endT,startT = vxTicks;
#else

# if !defined(LINUX) && !defined(VXWORKS68K)
  struct timespec startT,endT;

  (void) clock_gettime(0, &startT);
# else
  struct timeval startT,endT;

  gettimeofday(&startT,NULL);
# endif
#endif

  /* We can only run after prestart. */
  if ( (rocp->state != DA_PAUSED)  && (rocp->state != DA_PRESTARTED)) {
    Tcl_AppendResult(interp, 
		     " Roc is in the wrong state.\n Please download and prestart before testing the link.",
		     (char *) NULL);
    return TCL_ERROR;
  }

  /* Usage is roc test_link MB_to_send. */
  if (argc != 2) {
    /* The default number of buffers is: */
    num_mb = 30;
  } else {
    if (Tcl_GetInt ( interp, argv[1], &num_mb) == TCL_ERROR) {
      Tcl_AppendResult(interp, 
		       "\n   Usage: roc test_list 30",
		       "\n   This will send 30 MB to the event builder and get discarded.", (char *) NULL);
      return TCL_ERROR;
    }
  }

  num_buffers = num_mb * MEGA_BYTE / SEND_BUF_SIZE ;

  args = malloc(sizeof(struct thread_args)); 
  if (args == NULL) {
      sprintf(interp->result,"malloc failed. \n");
      return TCL_ERROR;
  }

  for (ix=num_buffers; ix-- > 0; ) {
    
    /* First time after prestart, the write_thread will have eaten this buffer. Ignore error. */
    res = recv(args->fd, (void *)buf, 128, recv_flags);
    /* bugbug getting hungry... */
    if (res <= 0  && ix==num_buffers) {
/*       write_failure = 1; */
      printf("test link failed (in recv) res = %d.\n", res);
/*       free(args); */
/*       return TCL_ERROR; */
    }

    args->buf = g_bigBuffer[0];
    args->dofree = 0;
    
    args->buf[0] = -1;
    args->buf[1] = object->codaid;
    args->buf[2] = -1 * (ix + 1); /* A negative count down of the number of buffers. */
    args->buf[3] = 0xDEADD00D;
    args->buf[4] = 0xBAD1BAD1;
    args->buf[5] = 0xB0B0B0B0;
    args->buf[6] = 0xD0D0D0D0;
    
    args->fd = rocp->primefd;
    args->nbytes = SEND_BUF_SIZE;

    if (sized_write(args->fd, args->buf, args->nbytes) < 0) {
      sprintf(interp->result,"sized_write failed\n");
      free(args);
      return TCL_ERROR;
    }
  }
#ifdef VXWORKS
  sprintf(interp->result,"%6.2f MB/second.",
	  ((float) (SEND_BUF_SIZE * num_buffers)) /
	  ( ( (float) (vxTicks - startT) / 60.0) * (float)MEGA_BYTE)
	  );
#else
  {

# if !defined(LINUX) && !defined(VXWORKS68K)
    (void) clock_gettime(0, &endT);
    start_time = startT.tv_sec + startT.tv_nsec / 1000000000.0;
    end_time = endT.tv_sec + endT.tv_nsec/ 1000000000.0;
# else 
    gettimeofday(&endT,NULL);
    start_time = startT.tv_sec + startT.tv_usec/1000000.0;
    end_time = endT.tv_sec + endT.tv_usec/1000000.0;

# endif
 
    sprintf(interp->result,"%6.2f MB/second.",
	    SEND_BUF_SIZE * num_buffers / ((end_time - start_time) * MEGA_BYTE) );
  }
#endif
  return TCL_OK;
}

TCL_PROC (roc_test_event)
{
  DANODE         *buf;

  int             i;

#ifdef TEST
  for (i = 0; i < 64; i++) {
    listGet (&object->test->list, buf);
    if (buf == 0)
      return TCL_OK;

    buf->nevent = object->nevents;

    buf->length = 250;
    object->nlongs += buf->length;

    buf->data[0] = PHYS_BANK_HDR (15, (object->nevents++));
    /* Add to list of outgoing events... */
    listAdd (&object->output->list, buf);
  }
#endif
  
  return TCL_OK;
}

#if 0
    { 
      int status;

#ifdef VXWORKS 
      if ( msgQNumMsgs (outputQueue) < 2 ) {
	status = msgQSend (outputQueue, (char *) &args, 4,
			   WAIT_FOREVER, MSG_PRI_NORMAL);
	if (status == ERROR) {
	  printf("test_link: error from msgQSend.\n");
	  return TCL_ERROR;
	}
      } else {
	printf("can't send EOF would block ROC\n");
      }
#else
      mq_put(outputQueue, args);
#endif
    }
#endif

/******************************************************************************
 * This routine is called by RC as the prestart transition
 */

TCL_PROC (roc_cleanup)
{
  rocParam        rocp;
  
  rocp = (rocParam) object->private;
  
  doclose = 0;
  rocp->active = 1;
  
  rol1_events = rol2_events = 0;
  
#ifdef DEBUG_MSGQ
  printf("SND args=%X: fd  -- buf -- bytes --\n",MQEND);
#endif
  

#ifdef VXWORKS 
  { 
    int status;
    if ( msgQNumMsgs (outputQueue) < 2 ) {
      printf("roc_cleanup: try msgQSend args = %X.\n", &MQEND);
      status = msgQSend (outputQueue, (char *) &MQEND, 4,
			 WAIT_FOREVER, MSG_PRI_NORMAL) ;
      if (status == ERROR) {
	printf("roc_cleanup: error from msgQSend.\n");
	return TCL_ERROR;
      }
    } else {
      printf("can't send EOF would block ROC\n");
    }

 }
#else
  printf("SND END1\n",MQEND);
  mq_put(outputQueue, MQEND);
#endif

  partReInitAll();
#ifndef VXWORKS
  mq_flush(outputQueue);
#else
  {
    int ix;
    int  num_messages,length;
    void *args;
    
    do {
      num_messages = msgQNumMsgs (outputQueue) ;
      
      if (num_messages == ERROR) {
	return TCL_ERROR;
      }
      if ( num_messages == 0 ) {
	break;
      }
      
      length = msgQReceive (outputQueue, &args, sizeof(args), WAIT_FOREVER) ;
      
      if ((length == ERROR) ||  (args == (void *) MQEND)) {
	break;
      }	
      if (args) {
	free(args);
      }
      
    } while (1);
  }
#endif
  return TCL_OK;
}

TCL_PROC (roc_prestart)
{

  rocParam        rocp;

  ROLPARAMS      *rolP;

  int             ix;

  char            tmp[100];

  rocp = (rocParam) object->private;

  doclose = 0;
  
  buffer_margin = SEND_BUF_MIN_MARGIN;
  buffer_delta  = INITIAL_DELTA;

  partReInitAll();

  rocp->state = DA_PRESTARTING;
  if (Tcl_Eval(interp, "roc_cleanup") != TCL_OK)
    return TCL_ERROR;

  /*
   * Get the run number.
   */
  if (Tcl_Eval (interp, "database query \"select runNumber from sessions where name='$session'\"") != TCL_OK) {
    rocp->state = DA_DOWNLOADED;
    return TCL_ERROR;
  }

  if (Tcl_Eval (interp, "database get next") != TCL_OK) {
      rocp->state = DA_DOWNLOADED;
      return TCL_ERROR;
  }

  if (Tcl_GetInt (interp, interp->result, &object->runNumber) == TCL_ERROR) {
    rocp->state = DA_DOWNLOADED;
    return TCL_ERROR;
  }

  daLogMsg ("INFO", "prestarting,run %d, type %d", object->runNumber, object->runType);


  /*
   * Get the token Interval (ROC record size) from the configuration
   * options table of the database
   */
  if (Tcl_VarEval (interp, object->name, " cget -config", (char *)NULL) != TCL_OK) {
    rocp->state = DA_DOWNLOADED;
    return TCL_ERROR;
  }

  sprintf (tmp,
	   "database query {select value from %s_option where name='tokenInterval'}",
	   interp->result);

  if (Tcl_Eval (interp, tmp) != TCL_OK){
    rocp->state = DA_DOWNLOADED;
    return TCL_ERROR;
  }

  if (Tcl_Eval (interp, "database get next") != TCL_OK) {
    rocp->state = DA_DOWNLOADED;

    return TCL_ERROR;
  }
  if (Tcl_GetInt (interp, interp->result, &token_interval) == TCL_ERROR)
    token_interval = 64;

  if (token_interval <= 0)
    token_interval = 64;

  /*
   * Check if ROC already got a token from the EB (ie he is the Primary
   * ROC in the Chain. If so we must reset end_range to the new token interval
   */ 
  if (rocp->end_range > 0)  {
    tokenrg[0] = token_interval;
    rocp->end_range = token_interval;
    printf("token_interval set to %d\n",token_interval);
  }


  /* If using file I/O open a file for data recording */

  if (Tcl_VarEval (interp, "dp_after 100; close_links;open_links",
		   (char *) NULL) != TCL_OK) {
    printf("open_links returned : %s\n",interp->result);
    rocp->state = DA_DOWNLOADED;
    return TCL_ERROR;
  }
  
  rocp->output_switch = 0; /* Network */

  /* Make default (Null) output to none */
  if(rocp->output_type[0] == '\0') {
    rocp->output_switch = 3;
    printf("Output to default (none)\n");
  } else {
    printf("Output to \"%s\"\n",rocp->output_type);
  }

  if (strncmp(rocp->output_type,"file",4) == 0) {
    rocp->output_switch = 1; 
  }
  if (strncmp(rocp->output_type,"debug",5) == 0) {
    rocp->output_switch = 2; 
  }
  if (strncmp(rocp->output_type,"none",4) == 0) {
    rocp->output_switch = 3; 
  }
  if (strncmp(rocp->output_type,"coda",4) == 0) {
    rocp->output_switch = 4; 
  }
  if (strcmp(rocp->output_type,"dd") == 0) {
    rocp->output_switch = 5; 
    if ((et_init == 0) || (et_reinit == 1)) {
      if (et_initialize() != TCL_OK) {
	printf("roc_prestart: ET initialization failed\n");
	rocp->state = DA_DOWNLOADED;
	return TCL_ERROR;
      }
    }
    printf("roc_prestart: done ET prestart\n");    
  }
  
  if ( rocp->output_switch == 0) {
    rocp->buffer_method = USE_BIG_BUFFERS;
  } else {
    rocp->buffer_method = USE_SMALL_BUFFERS;
  }
  
  rocp->buffer_method = USE_BIG_BUFFERS;

  printf("output switch is %d\n",rocp->output_switch );

  if ((rocp->output_switch == 1)||(rocp->output_switch == 4)) {
    char tempfn[500];

    if (rocp->filename[0] == '@') {
      printf("Executing file : %s\n",rocp->filename);
      sprintf(tempfn,"%s %d %d $config 0",&rocp->filename[1],object->runNumber, object->runType);
      if (Tcl_VarEval(interp,tempfn,NULL) != TCL_OK) {
	daLogMsg ("ERROR", "Filename generation script %s failed",rocp->filename);
	rocp->state = DA_DOWNLOADED;
	return TCL_ERROR;
      }
      Tcl_SetVar(interp,"current_file",interp->result,0);
    } else {
      sprintf(tempfn,rocp->filename,object->runNumber);
      Tcl_SetVar(interp,"current_file",tempfn,0);
    }
    
    daLogMsg("INFO","Opening file : %s",rocp->current_file);

    if (rocp->output_switch == 1) {
      rocp->primefd = open(rocp->current_file, O_WRONLY | O_CREAT | O_TRUNC, 0666);
    } else if (rocp->output_switch == 4) {
      evOpen(rocp->current_file,"w",&rocp->primefd);
      printf("evOpen(\"%s\",\"w\",%d)\n",rocp->current_file,rocp->primefd);
    }
    
  }
  if (rocp->output_switch == 0) {
    FILE           *filePtr;
    
    if (Tcl_VarEval (interp,
		     "puts \"in C prime is $prime\";$prime cget -link",
		     (char *) NULL) != TCL_OK) {
      printf ("Error %s\n", interp->result);
      rocp->state = DA_DOWNLOADED;
      return TCL_ERROR;
    }
    if (Tcl_GetOpenFile (interp, interp->result, 1, 1, &filePtr) != TCL_OK) {
      printf ("Error %s\n", interp->result);
      rocp->state = DA_DOWNLOADED;
      return TCL_ERROR;
    }
    rocp->primefd = fileno (filePtr);

  }  
  /* Check if there is a valid output file descriptor */ 
  if( (rocp->output_switch != 3) &&
      (rocp->output_switch != 2) &&
      (rocp->output_switch != 5)) {
    if ((rocp->primefd <= 0)) {
      perror("error opening file");
      Tcl_AppendResult (interp,
			"ERROR: ", "Unable to open output file : ",
			rocp->current_file,"::",
			strerror(errno),
			(char *) NULL);
      rocp->state = DA_DOWNLOADED;
      return TCL_ERROR;
    }
  }else{
    rocp->primefd = 0;
  }


  /* Spawn the Write Thread */
#ifndef VXWORKS
  {
    pthread_t thread1;
    pthread_attr_t detached_attr;
    
    pthread_attr_init(&detached_attr);
    pthread_attr_setdetachstate(&detached_attr,PTHREAD_CREATE_DETACHED);
    pthread_attr_setscope(&detached_attr, PTHREAD_SCOPE_SYSTEM);
    
    pthread_create(&thread1, &detached_attr,
		   (void *(*)(void *)) write_thread, (void *) NULL);
  }
#else
  {
    int iTaskStat;
    
    iTaskStat = taskSpawn("coda_write", 110, 0, 100000, write_thread, 0, 
			  0,0,0,0,0,0,0,0,0);
  }
#endif

  object->nevents = 0;					     /* zero bookeeping counters */
  object->nlongs = 0;
  rocp->recNb = 0;
  rocp->last_event = 0;
  rol1_events = rol2_events = 0;

  if((rocp->randy_factor > 0) && (rocp->randy_factor<500)) {
    g_max_ev_in_buf = rocp->randy_factor;
  } else {
    g_max_ev_in_buf = 32;
  }


  /*
   * loop over all readout lists setting bookeeping parameters then call
   * prestart routines.
   */

  for (ix = 1; ix >= 0; ix--) {
    rolP = rocp->rolPs[ix];
    if (rolP != NULL) {
      rolP->runNumber = object->runNumber;
      rolP->runType = object->runType;

      rolP->recNb = 0;
      {
	int res;
	recoverContext ("usrPrestart",res);
	if (res) {
	  daLogMsg ("ERROR", "Fatal error detected.");
	  Tcl_ResetResult (interp);
	  Tcl_AppendResult (interp,
			    "ERROR", "Fatal error detected in rol \n",
			    rolP->tclName,
			    (char *) NULL);
	  rocp->state = DA_DOWNLOADED;  
	  return TCL_ERROR;
	}
      }
      rolP->daproc = DA_PRESTART_PROC;
      (*rolP->rol_code) (rolP);
      /* pop context off context stack */
      lastContext ();
    }
  }

  /*
   * If the async_roc flag is set we don't send control events.
   */

  rocp->state = DA_PRESTARTED;
  if (!rocp->async_roc_flag) {
    informEB (object, (ulong) EV_PRESTART, (ulong) object->runNumber, (ulong) object->runType);
  }
  daLogMsg ("INFO", "prestarted");

  if (Tcl_Eval (interp, "status paused") != TCL_OK)
    return TCL_ERROR;

  return TCL_OK;
  }

/******************************************************************************
 * This routine is called by RC
 * to implement end transition
 */

TCL_PROC (roc_end)
{
  rocParam        rocp;

  ROLPARAMS      *rolP;

  int             ix, err;

  rocp = (rocParam) object->private;

  /*
   * loop over all readout lists setting bookeeping parameters then call
   * end routines.
   */
  for (ix = 0; (rolP = rocp->rolPs[ix]) != NULL; ix++) {
    int res;
    if (rolP->inited) {
      recoverContext ("usrEnd",res);
      if (res) {
	daLogMsg ("ERROR", "Fatal error detected in rol %s", rolP->tclName);
	Tcl_ResetResult (interp);
	Tcl_AppendResult (interp,
			  "ERROR", "Fatal error detected in rol \n",
			  rolP->tclName,
			  (char *) NULL);
	
	return TCL_ERROR;
      }
      rolP->daproc = DA_END_PROC;
      (*rolP->rol_code) (rolP);
    }
    /* pop context off context stack */
    lastContext ();
  }
  rocp->active = 2;
  if ((rocp->async_roc_flag == 1)) {
    rocp->state = DA_DOWNLOADED;
    rocp->active = 1;
    if (Tcl_Eval (interp, "status downloaded") != TCL_OK)
      return TCL_ERROR;
  } else {
    rocp->state = DA_ENDING;
    if (Tcl_Eval (interp, "status ending") != TCL_OK)
      return TCL_ERROR;
  }
  
  /* Get rid of extra, unused ET events */
  /*
  if (strcmp(rocp->output_type,"dd") == 0) {
    if (event2put < neventsnew) {
      err = et_events_dump(et_sys, et_attach, &etevents[event2put], neventsnew - event2put);
      if (err == ET_OK) {
        neventsnew = 0;
	event2put  = 0;
      }
    }
    printf("roc_end: dump remaining ET buffers\n");    
  }
  */
  return TCL_OK;
}

/******************************************************************************
 * This routine is called by RC
 * to implement the pause transition
 */

TCL_PROC (roc_pause)
{
  rocParam        rocp;

  ROLPARAMS      *rolP;

  int             ix;

  rocp = (rocParam) object->private;

  /*
   * loop over all readout lists setting bookeeping parameters then call
   * pause routines.
   */
  for (ix = 0; (rolP = rocp->rolPs[ix]) != NULL; ix++) {
    int res;
    recoverContext ("usrPause",res);
    if (res) {
      daLogMsg ("ERROR", "Fatal error detected in rol %s", rolP->tclName);
      Tcl_ResetResult (interp);
      Tcl_AppendResult (interp,
			"ERROR", "Fatal error detected in rol \n",
			rolP->tclName,
			(char *) NULL);
      return TCL_ERROR;
    }
    rolP->daproc = DA_PAUSE_PROC;
    (*rolP->rol_code) (rolP);

    /* pop context off context stack */
    lastContext ();
  }
  rocp->active = 2;

  if ((rocp->async_roc_flag == 1)) {
    rocp->state = DA_PAUSED;
    if (Tcl_Eval (interp, "status paused") != TCL_OK)
      return TCL_ERROR;
  } else {
    rocp->state = DA_PAUSING;
    if (Tcl_Eval (interp, "status pausing") != TCL_OK)
      return TCL_ERROR;
  }

  return TCL_OK;
}

/******************************************************************************
 * This routine is called by RC
 * to implement the go transition
 */

TCL_PROC (roc_go)
{
  rocParam        rocp;

  ROLPARAMS      *rolP;

  int             ix,ticks;

  rocp = (rocParam) object->private;

  daLogMsg ("INFO", "activating");

#ifdef VXWORKS
  ticks = vxTicks;
#endif
  if (rocp->async_roc_flag == 0) {
    informEB (object, (ulong) EV_GO, (ulong) 0, (ulong) object->nevents);
  }

  g_events_in_buffer = 0;

  for (ix = 1; ix >= 0; ix--) {
    rolP = rocp->rolPs[ix];
    if (rolP != NULL) {
      int res;
      recoverContext ("usrGo",res);
      if (res) {
	daLogMsg ("ERROR", "Fatal error detected in rol %s", rolP->tclName);
	Tcl_ResetResult (interp);
	Tcl_AppendResult (interp,
			  "ERROR", "Fatal error detected in rol \n",
			  rolP->tclName,
			  (char *) NULL);
	return TCL_ERROR;
      }
      rolP->daproc = DA_GO_PROC;
      (*rolP->rol_code) (rolP);
      /* pop context off context stack */
      lastContext ();
    }
  }
  rocp->active = 2;
  if (rocp->async_roc_flag == 1) {
    rocp->state = DA_ACTIVE;
    if (Tcl_Eval (interp, "status active") != TCL_OK)
      return TCL_ERROR;
  } else {
    rocp->state = DA_ACTIVE;
    if (Tcl_Eval (interp, "status active") != TCL_OK)
      return TCL_ERROR;
  }

  daLogMsg ("INFO", "active, events so far %d token %d",
	    object->nevents,
	    rocp->end_range);

  return TCL_OK;
}


#if 0
/* THIS IS NOT COMPILED IN! BUGBUG, NO ZBUF ON HALL B KERNEL, NOW. RWM */


#ifdef VXWORKS
VOIDFUNCPTR free_szw(caddr_t buf, int freeArg) {
    
  doing_zbuf = FALSE;
/*   printf("Freed doing_zbuf.\n"); */

}


int	/* returns number of data bytes written or -1 if error */
sized_zbuf_write (fd,buffer,nbytes)
     int fd;
     char *buffer;
     unsigned long nbytes;
{
  int i;
  int cc;
  int rembytes;
  unsigned long *buffer2 = (unsigned long *) buffer;
  u_long netlong;	/* network byte ordered length */
  int compress = 0;
  int chunk_size = 30000; /* See LINK_class.tcl for sendBuffer. */
  int n_chunks, final_chunk_size;
  int this_chunk_size;
    
/*   printf("Call sized_zbuf_write.\n"); */
  /* Protect from becalled 2nd time while still in the routine. */
  if (doing_zbuf) {
      printf ("sized_zbuf_write not reentrant, yet - error.\n");
      return(-1);
  } else {
      doing_zbuf = TRUE;
  }

  if (nbytes & 0x80000000) {
  	compress = 1;
    nbytes &= ~0x80000000;
  }
  /* write header */
#if 0
  if (compress) {
  	int r;
	lzo_uint out_len;
	buffer2 = malloc(nbytes+4+nbytes/64+ + 16 + 3);

	buffer2[0] = htonl(nbytes);

	out_len = 0;
	
    r = lzo1x_1_compress(buffer,nbytes,buffer2 + 1,&out_len,wrkmem);
    
	if (r != LZO_E_OK) {
		/* this should NEVER happen */
		printf("internal error - decompression failed: %d\n", r);
		return 1;
	}
    netlong = htonl((out_len+4) | 0x80000000);
    rembytes = out_len+4;

  } else {
#endif

    netlong = htonl(nbytes);
    rembytes = nbytes;

#if 0
  }
#endif
 retry2:
  if (sizeof(nbytes) != (cc = write(fd,(char *)&netlong,sizeof(netlong)))) {
    if (errno == EWOULDBLOCK) {
	goto retry2;
    }
    return(-1);
  }

  /* write data */
  if (nbytes == 0) {
      return(0);
  }

  n_chunks = rembytes/chunk_size;
  final_chunk_size = rembytes % chunk_size;
  if (final_chunk_size != 0) {
      n_chunks++;
  }
	  
  for (i = 1; i <= n_chunks; i++) {
      if ( i == n_chunks) {
	  this_chunk_size = final_chunk_size;
      } else {
	  this_chunk_size = chunk_size;
      }

/*       while (rembytes) { */
      while (this_chunk_size) {

      retry3:
/* 	  printf("zbuf Sending %d. \n", this_chunk_size); */
	  if (-1 == (cc = zbufSockBufSend(fd, buffer, this_chunk_size, free_szw, i, 0))) {
	      printf("Error maybe would block...\n");
	      if (errno == EWOULDBLOCK) goto retry3;
	      printf("Error - returning!.\n");
	      return(-1);
	  }
/* 	  printf("zbuf Sent %d. \n", cc); */
	  buffer += cc;
	  this_chunk_size -= cc;
      }
/*       printf("zbuf done sending chunk.\n"); */
  }
/*   printf("zbuf done sending.\n"); */
#if 0
  if (compress) free(buffer2);
#endif 
/*   printf("Done sized_zbuf_write.\n"); */
  return(nbytes);
}
/* VXWORKS */
#endif

#endif

void 
output_proc_network (struct alist * output, void *junk)
{
  int             i, lockKey, iTaskStat;

  register DANODE *theNode;

  objClass        object = (objClass) output->clientData;

  register rocParam rocp;

  ROLPARAMS      *rolP;

  int             ix, iy, res;

  static          last_send_time = 0;

  static int      timeout,timedout;

  static long     ready_to_send = 0;
  long pollPrimary,pollSecondary;
  long loopCount = token_interval;

  timeout = 0;
  /* Restore pointer to roc private storage */

  rocp = (rocParam) object->private;

  if (write_failure) {
    rocp->active = 0;
    write_failure = 0;
    Tcl_ResetResult (Main_Interp);
    Tcl_AppendResult (Main_Interp, "write of events to target failed.", (char *) NULL);
    rocp->async_roc_flag = 1;
    
    bufcnt = 2;
    roc_end(object,Main_Interp,(int) NULL,NULL);
    
    return;
  }

  /*
   * Check if we have any events on output queue.
   */

  if (rocp->active > 1) {

    if (object->nevents < 10) {
#ifdef VXWORKS
      timeout = vxTicks + sysClkRateGet()/6;
#else
      timeout = time(0) + 1/6;
#endif
    } else {
#ifdef VXWORKS
      timeout = vxTicks + token_interval;
#else
      timeout = time(0) + token_interval/60;
#endif
    }

#ifdef NEVER_DEFINED  
    if (timedout) {
      printf("timedout last time so decrease margin to");
      if (SEND_BUF_SIZE - SEND_BUF_MARGIN > SEND_BUF_MIN_MARGIN) {
	SEND_BUF_MARGIN += buffer_delta;
	if (buffer_delta > 2048)
	  buffer_delta = buffer_delta/2;
	
	printf(" %d\n",SEND_BUF_MARGIN);
      } else {
	printf ("not adjusted, hit minimum\n");
      }
    } else {
      if (SEND_BUF_MARGIN - buffer_delta > SEND_BUF_MIN_MARGIN) {
	SEND_BUF_MARGIN -= buffer_delta;
	if (buffer_delta < SEND_BUF_MIN_MARGIN/2)
	  buffer_delta = buffer_delta*2;
	printf("margin increased to %d\n",SEND_BUF_MARGIN);
      }
    }
#endif

    timedout = 0;
    
    if (dataInBuf > (SEND_BUF_SIZE - SEND_BUF_MARGIN) ||
	( g_events_in_buffer >= g_max_ev_in_buf)) {
      clear_to_send = 1;
    }

    /* Readout list Polling Loop -- Stay in this loop until we need to send */  
    do {
      /* If the ouput is full we can take no more triggers */
      if ((dataInBuf > (SEND_BUF_SIZE - SEND_BUF_MARGIN)) || 
      ( g_events_in_buffer >= g_max_ev_in_buf) ||
	  (clear_to_send  == 1)) {
	break;
      }      

      /* Primary list */

      /* We should always have a primary list but allow for not just
	 in case. We also should stop polling if ending.
      */

      if (((rolP = rocp->rolPs[0]) != NULL) && (rocp->state != DA_ENDING)) {
	
	/* If we are the only ROL we can use the "BIG_BUFFER" method 
	   for network transfer.
	*/
	if ((rocp->buffer_method == USE_BIG_BUFFERS) && (rocp->rolPs[1] == NULL)) { 
	  dabufp[0] = 0;
	  /* If rolP->dabufp != NULL then the trigger routine will
	     put the event in the buffer pointed to by dabufp
	  */
	  rolP->dabufp = (long *) dabufp;
	  
	  /* Do we actually need to poll ?? 
	     Don't poll if this is an interrupt driven list
	  */
	  if (rolP->poll) {
	    int len;
	    /* We are going to call the trigger procedure */
	    rolP->daproc = DA_POLL_PROC;
#ifdef DEBUG
	    printf("POLL 1 %08x\n", rolP->dabufp); 
#endif
	    /* Call the dispatcher, which calls the trigger routine
	       if there is a trigger.
	    */
	    (*rolP->rol_code) (rolP);

	    /* dabufp[0] is the event length, if this is non zero (we zeroed it earlier)
	       then we got an event
	    */
	    if ((len = dabufp[0]) > 0) {
	      int ev_type;

	      /* Count events handled by this list and set event type */
	      rol1_events++;
	      ev_type = (dabufp[1] >> 16) & 0xff;
	      /* Bump dabufp by event length plus one (wordcount)*/
	      len++;
	      dabufp += len;
	      /* Bump dataInBuf counter by same amount.*/
	      dataInBuf += len<<2;
	      /* Remember last Physics event Processed if there is NO Secondary list */
	      if( (ev_type >= 0) && (ev_type < 16) && ((rocp->rolPs[1]) == NULL) ) {
		rocp->last_event++;
	      }else{
		/* printf("NON Physics Event type=%d\n",ev_type); */
	      }
	      /* Remember globally the number of events in the buffer.
	       */
	      g_events_in_buffer++;
	    }
	    /* Do we need to call the "done" routine to enable trigger?
	       If yes do so only if we have free buffers
	    */
	  }
	  if (rolP->doDone) {
	    /* Can't call done if no room left in buffer */

	    if (dataInBuf <= (SEND_BUF_SIZE - SEND_BUF_MARGIN)) {
#ifdef VXWORKS
	      lockKey = intLock ();
#endif
	      /* Dispatch the done routine */
	      rolP->daproc = DA_DONE_PROC;
	      rolP->doDone = 0;
	      (*rolP->rol_code) (rolP);
#ifdef VXWORKS
	      intUnlock (lockKey);
#endif  
	    } else {
	      /*
		No use staying in the polling loop if output full.
		The "clear_to_send" flag triggers sending.
	      */
	      clear_to_send = 1;
	      break;
	    }
	  }
	} else {
	  /* Not using big buffers...
	     If rolP->dabufp == NULL the trigger routine will get a
	     buffer out of the pool
	  */
	  rolP->dabufp = NULL;
	  /* Do we actually need to poll ?? 
	     Don't poll if this is an interrupt driven list
	     Don't poll if we have no free buffers
	  */
	  if (rolP->poll && rolP->pool->list.c) {
	    rolP->daproc = DA_POLL_PROC;
	    /* 	   printf("POLL 1 %08x\n", rolP->dabufp); */
	    (*rolP->rol_code) (rolP);	/* pseudo-trigger cdopoll */

	  }

	  if (rolP->doDone) {
	    /* Do we need to call the "done" routine to enable trigger?
	       If yes do so only if we have free buffers
	    */
	    if (rolP->pool->list.c) {
#ifdef VXWORKS
	      lockKey = intLock ();
#endif
	      rolP->daproc = DA_DONE_PROC;
	      rolP->doDone = 0;
	      (*rolP->rol_code) (rolP);
#ifdef VXWORKS
	      intUnlock (lockKey);
#endif  
	    } else {
	      /* If there is no secondary list we need to break now !! 
	       */
	      if (rocp->rolPs[1] == NULL)
		break;
	      /* else let the secondary list eat some events */
	    }
	  }
	}
      }
      /* Secondary list 
	 The secondary list always polls until there is nothing left
	 on the input queue or the output is full...
       */
      if ((rolP = rocp->rolPs[1]) != NULL) {
	if (rocp->state == DA_ENDING && (listCount(&rolP->input->list) == 0)) {
	  break;
	}
	if (rolP->poll) {
	  int len;
	  if (rocp->buffer_method == USE_BIG_BUFFERS) {
	    dabufp[0] = 0;
	    rolP->dabufp = (long *) dabufp;
	    rolP->daproc = DA_POLL_PROC;
	    /* 	  printf("POLL 2 %08x\n", rolP->dabufp); */
	    (*rolP->rol_code) (rolP);	/* pseudo-trigger cdopoll */
	    if ((len = dabufp[0]) > 0) {
	      static int oldevnb = 0;
	      int newevnb;
	      int ev_type;
	      
	      newevnb = dabufp[1] & 0xff;
	      ev_type = (dabufp[1] >> 16) & 0xff;
	      
	      if (newevnb < oldevnb) 
		newevnb += 256;
	      
	      if (newevnb - oldevnb != 1) {
		printf("nevents %d newevnb %d old %d\n",object->nevents, newevnb, oldevnb);
	      }
	      oldevnb = dabufp[1] & 0xff;
	      
	      dabufp += (len+1);
	      dataInBuf += (len+1)<<2;
	      rol2_events++;
	      if((ev_type >= 0) && (ev_type < 16)) {
		rocp->last_event++;   /* Increment Physics Events processed */
	      }else{
		/* printf("NON Physics Event type=%d\n",ev_type); */
	      }
	      g_events_in_buffer++;
	    }
	    if (rolP->doDone) {
	      if (dataInBuf <= (SEND_BUF_SIZE - SEND_BUF_MARGIN)) {
#ifdef VXWORKS
		lockKey = intLock ();
#endif
		rolP->daproc = DA_DONE_PROC;
		rolP->doDone = 0;
		(*rolP->rol_code) (rolP);
#ifdef VXWORKS
		intUnlock (lockKey);
#endif  
	      } else {
		/* Can't do anything with this thing full 
		 */
		clear_to_send = 1;
		break;
	      }
	    }
	  } else {
	    rolP->dabufp = NULL;
	    rolP->daproc = DA_POLL_PROC;
	    /* 	  printf("POLL 2 %08x\n", rolP->dabufp); */
	    (*rolP->rol_code) (rolP);	/* pseudo-trigger cdopoll */
	    if (rolP->doDone) {
	      if (rolP->pool->list.c) {
#ifdef VXWORKS
		lockKey = intLock ();
#endif
		rolP->daproc = DA_DONE_PROC;
		rolP->doDone = 0;
		(*rolP->rol_code) (rolP);
#ifdef VXWORKS
		intUnlock (lockKey);
#endif  
	      } else {
		break;
	      }
	    }
	  }
	}
      }
      if (dataInBuf > (SEND_BUF_SIZE - SEND_BUF_MARGIN) ||
            ( g_events_in_buffer >= g_max_ev_in_buf)) {
	clear_to_send = 1;
	break;
      }      
#ifdef VXWORKS
      if (vxTicks > timeout) {
	if (dataInBuf > 12) {
	  clear_to_send  = 1;
	}
	timedout = 1;
	break;
      }
#else
      if (time(0) > timeout) {
	if (dataInBuf > 12) {
	  clear_to_send  = 1;
	}
	timedout = 1;
	break;
      }
#endif
      
    } while (1);
  }
 
 

  /* Handle state changes */

  switch (rocp->state) {
  case DA_DOWNLOADED:
    
    if ((rocp->output_switch == 0) && (doclose == 1)) {
      /* printf("delete \n"); */
      Tcl_VarEval(Main_Interp,object->name, " close_links",NULL);
      /* printf("result of delete %s\n",Main_Interp->result); */
      doclose = 0;
    }
    break;
  case DA_ACTIVE:

    /*
     * If we are active then all we need to do is pass data to EB
     */
    break;
  case DA_PAUSING:

    /*
     * If we got this far then either the last event is either on
     * the iov or was the last event on the last iov.
     */

    if (rocp->active != 1) {
      if (rocp->async_roc_flag == 0) {
	informEB (object, (ulong) EV_PAUSE, (ulong) 0, (ulong) object->nevents);
      }
    }
    if (Tcl_VarEval (Main_Interp, "itcl_context ", object->name, " ROC status paused", NULL) != TCL_OK)
      return;
    rocp->state = DA_PAUSED;
    /*
     * in pause we leave the partial iov hanging in the air until
     * someone hits go
     */
    rocp->active = 1;

    break;
  case DA_ENDING:

    /* printf("rocp->last_event = %d , nevents = %d\n",rocp->last_event,object->nevents); */
    if ((dataInBuf > 12) || (rocp->last_event < object->nevents)) {
      /*
       * We dont send anything until we are sure we have the
       * last event in the output buffer
       *    Also make sure the output buffer gets sent if there
       *    is any data in it.
       */      
      if(dataInBuf > 12) clear_to_send = 1;
      break;
    }

    /*
     * If we got this far then either the last event sent on the
     * net was the last event taken OR the last event taken is sat
     * at the end of the output queue waiting to go.
     */
    if (rocp->active == 2) {
      if (rocp->async_roc_flag == 0) {
	informEB (object, (ulong) EV_END, (ulong) object->runNumber, (ulong) object->nevents);
      }
      printf("Inserted End event on queue\n");
      /* trigger sending the partial iov */
      /* clear_to_send = 1;*/
      rocp->active = 1;

#ifdef DEBUG_MSGQ
      printf("SND args=%X: fd  -- buf -- bytes --\n", MQEND);
#endif
      
#ifdef VXWORKS 
      { 
	int status;
	status = msgQSend (outputQueue, (char *) &MQEND, 4,
			   WAIT_FOREVER, MSG_PRI_NORMAL) ;
	if (status == ERROR) {
	  return TCL_ERROR;
	}
      }
#else
      printf("SND END2\n",MQEND);
      
      mq_put(outputQueue, MQEND);
#endif

      rocp->state = DA_DOWNLOADED;
      ready_to_send = 0;
      
      if (rocp->output_switch == 4) {
	evClose(rocp->primefd);
	daLogMsg ("INFO","Closed CODA file");
      } else if (rocp->output_switch == 1) {
	close(rocp->primefd);
	daLogMsg ("INFO","Closed BINARY file");
      } 
      
      if (Tcl_VarEval(Main_Interp,"close_callback ",object->name,NULL) != TCL_OK) {
	printf("no close callback\n");
      }
      
      if (Tcl_VarEval (Main_Interp, "itcl_context ", object->name, " ROC status downloaded", NULL) != TCL_OK) {
	return;
      }
      
      daLogMsg ("INFO","ended after %d events",object->nevents);	  
      
      rol1_events = rol2_events = 0;
      break;
      
    }

    break;
  default:

    /*
     * By default just pass data to the write_thread.
     */
    break;
  }

 dosend:

#ifdef VXWORKS
  /* bugbug: this check could be NUM_SEND_BUFS - 3 */
  /* There should be a buffer being sent, one in the msgQ, and one or */
  /* more being filled. */
  /* bugbug: playing it safe for now - rwm. */

  /* bugbug */
  if (clear_to_send && ( msgQNumMsgs (outputQueue) < 2 ) && (rocp->primefd>=0)) {
#else
  if (clear_to_send && (outputQueue->cnt < 2) && (rocp->primefd>=0)) {
#endif
    /* Send all current output buffers */
    int res;
    unsigned long id;
    trArg args = malloc(sizeof(struct thread_args)); 
    args->dofree = 0;
    args->output_switch = rocp->output_switch;

    /* Construct header */
    rocp->recNb++;

    g_bigBuffer[whichBuf][0] = rocp->recNb;
    g_bigBuffer[whichBuf][1] = object->codaid;
    g_bigBuffer[whichBuf][2] = g_events_in_buffer;

    g_events_in_buffer = 0;    
#ifdef DEBUG_MSGQ
    printf("SND args = %X: buf # = %d, whichBuf = %d\n",args, g_bigBuffer[whichBuf][0] , whichBuf);
#endif
    /* determine total # of bytes to be sent */    
    sending = 1;

    args->fd = rocp->primefd;
    args->buf = g_bigBuffer[whichBuf];
    args->nbytes = dataInBuf;

    object->nlongs += dataInBuf >> 2;
    dataInBuf = 12;   /* allow for header !! */

    whichBuf = (whichBuf + 1) & (NUM_SEND_BUFS -1);
    g_bigBuffer[whichBuf][2] = 0;

    dabufp = &g_bigBuffer[whichBuf][3];

#ifdef DEBUG_MSGQ
    printf("SND args (output_proc_network) = %X: fd %d buf %08x bytes %d\n",args, args->fd, args->buf, args->nbytes);
#endif
   if ( args->nbytes > 16 ) { 
#ifdef VXWORKS 
    { 
      int status;
      status = msgQSend (outputQueue, (char *) &args, 4,
			 WAIT_FOREVER, MSG_PRI_NORMAL);
      if (status == ERROR) {
	puts("Error! Sending to write_thread.\n");
	return TCL_ERROR;
      }
    }
#else
    mq_put(outputQueue, args);
#endif  
    } else {
    	free(args);
    	printf("attempt to send short buffer foiled!!\n");
    }

    if (rocp->state == DA_DOWNLOADED) {
#ifdef DEBUG_MSGQ
      printf("SND args=%X: fd  -- buf -- bytes --\n", MQEND);
#endif

#ifdef VXWORKS 
      { 
	int status;
	status = msgQSend (outputQueue, (char *) &MQEND, 4,
			   WAIT_FOREVER, MSG_PRI_NORMAL) ;
	if (status == ERROR) {
	  puts("Error! Download Sending to write_thread.\n");
	  return TCL_ERROR;
	}
      }
#else
      printf("SND END3\n",MQEND);

      mq_put(outputQueue, MQEND);
#endif   
    }
    ready_to_send = 0;
    clear_to_send = 0;
  } else {
    if (sending) {
      full_send_buf++;
    }
  }

  if (rocp->active > 0) {
#ifdef IDLE_METHOD
    Tk_DoWhenIdle ((Tk_IdleProc *) output_proc, (void *) output);
#else
    network_token = Tk_CreateTimerHandler (10, (Tk_TimerProc *) output_proc, (ClientData) output);
#endif
  }
  return;
}
