#define QSIZE				8

typedef struct cbt {
  char *name;
  char *parent;
  int  wait_get;
  int  wait_put;
  pthread_mutex_t buf_lock;	/* lock the structure */
  int start_idx;		/* start of valid data */
  int num_full;			/* # of full locations */
  int deleting;			/* are we in a delete somewhere? */
  pthread_cond_t notfull;	/* full -> not full condition */
  pthread_cond_t notempty;	/* empty -> notempty condition */
  pthread_cond_t empty;		/* empty -> notempty condition */
  void *data[QSIZE];		/* Circular buffer of pointers */
} circ_buf_t;

circ_buf_t *new_cb(char *name);
void delete_cb(circ_buf_t **cbp);
int put_cb_data(circ_buf_t **cbp, void *data);
void *get_cb_data(circ_buf_t **cbp);
char *get_cb_name(circ_buf_t *cbp);
