/*----------------------------------------------------------------------------*
 *  Copyright (c) 1991, 1992  Southeastern Universities Research Association, *
 *                            Continuous Electron Beam Accelerator Facility   *
 *                                                                            *
 *    This software was developed under a United States Government license    *
 *    described in the NOTICE file included as part of this distribution.     *
 *                                                                            *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606 *
 *      heyes@cebaf.gov   Tel: (804) 249-7030    Fax: (804) 249-7363          *
 *----------------------------------------------------------------------------*
 * Discription: follows this header.
 * 
 * Author:
 *	Graham Heyes
 *	CEBAF Data Acquisition Group
 *
 * Revision History:
 *      $Log: LINK_support.c,v $
 *      Revision 2.49  1999/10/28 14:49:57  abbottd
 *      Fixwd #define of MSG_WAITALL to be consistent for LINUX and Solaris
 *
 *      Revision 2.48  1998/11/13 20:10:09  timmer
 *      endian awareness program
 *
 *      Revision 2.47  1998/11/06 17:31:32  timmer
 *      Linux port
 *
 *      Revision 2.46  1998/07/31 17:33:00  abbottd
 *      Remove diagnostic print statements
 *
 *      Revision 2.45  1998/07/30 13:01:37  rwm
 *      Fixed test_link.
 *
 *      Revision 2.44  1998/07/27 19:17:47  heyes
 *      added support for xfrag.tcl, turned off evsize debugging in ROC
 *
 *      Revision 2.43  1998/07/24 15:06:37  rwm
 *      Fixes for test_link.
 *
 *      Revision 2.42  1998/07/23 13:00:19  heyes
 *      Fix coda_ts + improve error reporting
 *
 *      Revision 2.41  1998/07/21 18:29:15  heyes
 *      auto exit shell
 *
 *      Revision 2.40  1998/07/17 15:39:07  heyes
 *      control events were handled incorrectly in deb_component fixed that...
 *
 *      Revision 2.39  1998/07/15 19:13:45  heyes
 *      better thread handling at exit of EB or ROC
 *
 *      Revision 2.38  1998/07/10 12:29:56  heyes
 *      link support remove other crap
 *
 *      Revision 2.36  1998/06/30 17:23:53  heyes
 *      tidy up a lot of handle_build...
 *
 *      Revision 2.35  1998/06/17 13:05:46  rwm
 *      Added flag to recv to wait for all requested data. Added checks to count how many times recv is actually called.
 *
 *      Revision 2.34  1998/06/04 14:50:09  heyes
 *      send events in buffer to EB
 *
 *      Revision 2.33  1998/06/04 14:12:07  rwm
 *      Various msgQ fixes...
 *
 *      Revision 2.32  1998/06/03 19:25:50  heyes
 *      change read to recv
 *
 *      Revision 2.31  1998/06/03 17:47:00  heyes
 *      oops, forgot to change link_debug flag to 1 when on!
 *
 *      Revision 2.29  1998/06/03 17:15:19  rwm
 *      Tuning for faster rate. Only 2 send buffers.  Fix LINK_sized_read.
 *
 *      Revision 2.28  1998/05/29 17:39:35  rwm
 *      Removed printf in handle_link, read thread.
 *
 *      Revision 2.27  1998/05/27 13:44:59  heyes
 *      add message Q to ROC, improve EB stability on EBD transition
 *
 *      Revision 2.25  1998/05/04 17:25:58  heyes
 *      new ROC
 *
 *      Revision 2.24  1998/03/09 19:50:46  heyes
 *      tidy memory leaks etc
 *
 *      Revision 2.23  1998/03/09 18:56:19  heyes
 *      the fastest EB in the galaxy
 *
 *      Revision 2.22  1998/03/06 15:05:14  heyes
 *      new faster multi-thread EB
 *
 *      Revision 2.20  1998/02/23 20:30:44  heyes
 *      add multi_mode to EB
 *
 *
 *----------------------------------------------------------------------------*/

/* INCLUDES */
#ifndef VXWORKS
#include <unistd.h>
#include <sys/types.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include "da.h"
#include "itcl.h"
#include "./circ_fifo.h"

#ifdef LINUX
#include <errno.h>
#else
extern int *___errno();
#define errno (*(___errno()))
#endif

#ifndef MSG_WAITALL

#ifdef __sun
#define MSG_WAITALL 0x40  /* from Solaris 2.6: Not defined in 2.5.1 */
#endif

#ifdef LINUX
#define MSG_WAITALL 0x100  /* Red Hat 6.0 still not implemented */
#endif

#endif

extern unsigned long *eventNumber;
extern unsigned long *dataSent;
extern int roc_queue_evsize[64];
#define DATA_DEBUG 1

#define TCL_PROC(name) int name (objClass object, Tcl_Interp *interp, int argc, char **argv)

extern void Tdp_FreeReadBuffer _ANSI_ARGS_((int fd));

static int (*ProcessData_call)();
static Itcl_Object *LINK_Parent;
long LINK_block_count = 0;
unsigned long *LINK_block_list[8192];
static char processing[1024];
static FILE *debug_file;

static int link_debug_mode_ = 0;

extern int         roc_queue_ix;
extern circ_buf_t *roc_queues[64];

typedef struct data_link *DATA_LINK;

typedef struct data_link {
  char *name;
  char *parent;
#ifndef VXWORKS
  pthread_t thread;
#endif
  int sock;
  int fd;
  char host[100];
  int port;
  int thread_exit;
  int bufCnt;
  circ_buf_t *roc_queue;
} DATA_LINK_S;

typedef struct thread_args *trArg;

typedef struct thread_args {
  objClass object;
  int fd;
  DATA_LINK link;
} TRARGS;

static trArg args;

extern int do_command(char *host,int port,char *command,char *result,int *so, int async);
extern int get_hostport(char *msqlHost,char *theName,char *theHost,int *thePort,char *result);

static unsigned long broad_addr,broad_port,broad_sock;
static struct sockaddr_in sockaddr;

int	/* returns number of bytes read or -1 if error (i.e. EOF) */ 
LINK_sized_read(int fd,char **buf)
{
  int size;	/* size of incoming packet */
  int cc;
  int rembytes;	/* remaining bytes */
  int n_retries = 0;
  int n_retry2;
  u_long netlong;	/* network byte ordered length */
  char *bufferp=0;

  /* Wait for all the data requested */
  int recv_flags = MSG_WAITALL;
  
  /* read header off socket. */
  rembytes = sizeof(netlong);
  bufferp = (char *) &netlong;
  while (rembytes) {
    cc = recv (fd, bufferp, rembytes, recv_flags);

    if ( cc == -1) {
      if (errno == EWOULDBLOCK) {
	puts("sized_read: recv would block, retrying.");
	/* retry */
      } else {
 	if (errno != ECONNRESET) {
	  perror("read ");
	}
	return -1;
      }
    } else {
      /* It is OK for a socket to return with wrong number of bytes. */
      if ( cc != rembytes ) {
	if (cc > rembytes) {
	  /* read() returned more bytes than requested!?!?!?! */
	  /* this can't happen, but appears to anyway */
	  fprintf(stderr,"LINK_sized_read(,,%d) = read(,,%d) = %d!?!?!\n",
		  size,rembytes,cc);
	  fprintf(stderr,"read() returned more chars than requested!  Aborting program.\n");
	  (void) abort();
	} else if (cc == 0) {
	  printf("socket %d closed\n",fd);
	  return 0;
	}
      }
      /* Always adjust these to get out of the while. */
      bufferp += cc;
      rembytes -= cc;
    }
  }

  size = (int) ntohl(netlong);

  /* read data */
  if (size == 0) {
  	/* GHGHGH */
  	unsigned long *p;
  	printf("warning zero length block from ROC\n");
  	*buf = (char *) ckalloc(24);
  	p = (unsigned long *) *buf;
  	p[0] = -1;
  	p[1] = -1;
  	p[2] = -1;
  	p[3] = -1;  /* setting this to -1 makes handle_link ignor the buffer */
  	p[4] = -1;
	p[5] = -1;

    return(24);
  }	

  *buf = (char *) ckalloc(size+6);	/* two bytes extra for null term strings */
  
  *((unsigned long *) *buf) = size>>2;
  bufferp = *buf + sizeof(size);

  rembytes = size;
  n_retry2 = 0;

  while (rembytes) {
  retry1:
    if ((cc = recv(fd,bufferp,rembytes, recv_flags)) == -1) {
      if (errno == EWOULDBLOCK) goto retry1;
      if (errno != ECONNRESET) perror("read2");
      puts("Error 2.");
      printf("cc = %d, Errno is %d.\n", cc, errno);
      return(-1);
    }
    if (0 == cc) {	/* EOF - process died */
      /* GHGHGH */
      return(0);
    }
    else if (cc > rembytes) {
      /* read() returned more bytes than requested!?!?!?! */
      /* this can't happen, but appears to anyway */

      fprintf(stderr,"sized_read(,,%d) = read(,,%d) = %d!?!?!\n",
	      size,rembytes,cc);
      fprintf(stderr,"read() returned more chars than requested!  Aborting program.\n");
      (void) abort();
    }
    else if (cc != rembytes) {
      /* (cc > 0) && (cc < rembytes) */
      n_retry2++;
    }
    
    bufferp += cc;
    rembytes -= cc;
  }

  /* printf("nrt = %d ", n_retry2); */
  return(size);
}

int LINK_support_Init(Tcl_Interp *interp)
{
  char tmp[400];
  sprintf(tmp,"%s {%s} %s {%s}",
	  __FILE__,
	  DAYTIME,
	  CODA_USER,
	  "$Id: LINK_support.c,v 2.49 1999/10/28 14:49:57 abbottd Exp $");
  Tcl_SetVar (interp, "tcl_modules",tmp,TCL_LIST_ELEMENT|TCL_APPEND_VALUE|TCL_GLOBAL_ONLY);
  return TCL_OK;
}

#ifdef __sun
extern int     go_rt(int pri, int tp, int id);
#endif

void *handle_link(trArg arg)
{
  FILE *filePtr;
  int fd;
  int numRead;
  int headerSize;
  char *errMsg;
  char *buf;
  signed long *buf_long_p;
  int count, i;
  DATA_LINK theLink = (DATA_LINK) arg->link;

  fd = theLink->fd;
  
#ifdef __sun
  go_rt(20,P_LWPID,lwp_self());
#endif

  ckfree(arg);
  
  while (1) {
    /*  puts("Sending frag info to rocs."); */
    numRead = send(fd, (const void *)roc_queue_evsize, 128, 0);
    if (numRead <= 0) {
      put_cb_data(&theLink->roc_queue, (void *) -1);
      break;
    }
    
    /* puts("Reading data from rocs."); */
    numRead = LINK_sized_read (fd,&buf);
    /* puts("Got data from rocs.\n"); */

    if (numRead <= 0) {
      put_cb_data(&theLink->roc_queue, (void *) -1);
      break;
    }

    /* bugbug?: Count all buffers even test_links? */
    *dataSent += (numRead>>2);

    buf_long_p = (signed long *) buf;
    {
      debug_printf(DATA_DEBUG,
		   "buffer from %s (%08x %08x %08x %08x %08x %08x %08x %08x)\n",
		   theLink->name,
		   buf_long_p[0],buf_long_p[1],buf_long_p[2],buf_long_p[3],
		   buf_long_p[4],buf_long_p[5],buf_long_p[6],buf_long_p[7]);
      if (buf_long_p[0] == 3) {
	printf("WARNING got empty buffer from ROC !!\n");
	free (buf);
	continue;
      }
    }

    /* Check for test_link data */
    if ( (buf_long_p[3] < 0) || (link_debug_mode_)) {
      /* Sum number of words, to get data rate. */
      arg->object->nlongs += (numRead/4);
/*       printf("WARNING - handle_link discarding buffer. count = %d.\n",  */
/* 	     buf_long_p[3]); */
      free (buf);
      continue;
    }
    
#ifdef DEAD_EB
    free(buf);
#else
    if (put_cb_data(&theLink->roc_queue, (void *) buf) < 0) {
      break;
    }
#endif
  }  

  /*
   *
   * If we're in non-blocking mode, and this would block, return.
   * If the connection is closed (numRead == 0), don't return an
   * error message.  Otherwise, return one.
   *
   * In either case, we close the file, delete the file handler, and
   * return a null string.
   */
  theLink->thread = 0;
  /*close(fd);*/

  printf("thread exit for %s\n",theLink->name);
  pthread_exit(0);
}
 
TCL_PROC(LINK_debug)
{
  if (link_debug_mode_) {
    link_debug_mode_ = 0;
    sprintf (interp->result,"off");
  } else {
    link_debug_mode_ = 1;
    sprintf (interp->result,"on");
  }
  return TCL_OK;
}

TCL_PROC(LINK_constructor_C)
{
  Itcl_Object    *obj;
  DATA_LINK theLink;

  /* we need to save the pointer to private object storage */

  bzero(LINK_block_list,sizeof(LINK_block_list));

  Tcl_Eval (interp, "set this");				     /* find out who we are */
  Itcl_FindObject (interp, interp->result, &obj);		     /* find pointer to itcl object */
  
  obj->ClientData = (ClientData) (theLink = (DATA_LINK) ckalloc(sizeof(DATA_LINK_S)));			     /* store private data */

  bzero ((char *) obj->ClientData, sizeof(DATA_LINK_S));

  if (Tcl_Eval (interp, "set name [info namespace tail $this]") != TCL_OK)
    return TCL_ERROR;
  
  /* copy name into structure */
  
  theLink->name = (char *) ckalloc (strlen (interp->result) + 1);
  strcpy (theLink->name, interp->result);
  theLink->parent = strdup(argv[3]);

  return TCL_OK;
}

TCL_PROC(LINK_get_outputH)
{
  DATA_LINK theLink = (DATA_LINK) object;

  sprintf(interp->result,"0x%08x",&theLink->roc_queue);

  return TCL_OK;
}

TCL_PROC(LINK_queue_name)
{
  DATA_LINK theLink = (DATA_LINK) object;

  sprintf(interp->result,"%s",theLink->roc_queue->name);

  return TCL_OK;
}

TCL_PROC(LINK_fifo_status)
{
  char tmp[200];
  DATA_LINK theLink = (DATA_LINK) object;
  circ_buf_t *f;

  Tcl_ResetResult(interp);
  f = theLink->roc_queue;
  pthread_mutex_lock(&f->buf_lock);
  sprintf(tmp,"%-10s %-8d %-8d %-8d %-6d %-8d",
	  theLink->name,
	  f->wait_get,
	  f->wait_put,
	  f->deleting,
	  QSIZE,
	  f->num_full
	  );
  pthread_mutex_unlock(&f->buf_lock);

  Tcl_AppendResult(interp,tmp,(char *) NULL);
  Tcl_AppendResult(interp, "\n",(char *) NULL);
  return (TCL_OK);
}

TCL_PROC(LINK_destructor_C)
{
  DATA_LINK theLink = (DATA_LINK) object;
  void *status;
  int thread = theLink->thread;

  if (theLink == NULL) return TCL_OK;

  if (theLink->thread) {
    pthread_t thread = theLink->thread;
    pthread_cancel(thread);
    pthread_join(thread,&status);
    theLink->thread = 0;
  }
  close(theLink->fd);
  ckfree((char *) theLink->name);
  ckfree((char *) theLink->parent);
  ckfree((char *) theLink);
  return TCL_OK;
}

/* here we are */
TCL_PROC(LINK_thread_init)
{
  FILE *filePtr;
  int fd;
  static int ix;
  char tmp[100];
  Itcl_Object    *obj;
  DATA_LINK theLink;
  pthread_attr_t detached_attr;

  Tcl_Eval (interp, "set this");				     /* find out who we are */
  Itcl_FindObject (interp, interp->result, &obj);		     /* find pointer to itcl object */
  
  theLink = (DATA_LINK) obj->ClientData;
  
  if (Tcl_GetOpenFile(interp, argv[1], 0, 1, &filePtr) != TCL_OK) {
    return TCL_ERROR;
  }
  
  theLink->fd = fd = fileno(filePtr);

  args = (trArg) ckalloc(sizeof(TRARGS));
  args->object = object;
  args->fd = fd;
  args->link = theLink;

  theLink->roc_queue = roc_queues[roc_queue_ix++];
  theLink->roc_queue->parent = theLink->name;
  pthread_attr_init(&detached_attr);

  pthread_attr_setscope(&detached_attr,
    PTHREAD_SCOPE_SYSTEM);

  if (pthread_create( &theLink->thread,&detached_attr,
		      (void *(*)(void *)) handle_link, (void *) args) != 0) {
    perror("pthread_create: ");
    return TCL_ERROR;
  }

  return TCL_OK;
}

TCL_PROC(LINK_process_data)
{
  if (argv[1][0] == 'e' ) {
    Tcl_VarEval(interp,"dalogmsg WARN \"link $name shut down\"",NULL);
    return TCL_OK;
  }
  return TCL_OK;
}
#endif
