/*----------------------------------------------------------------------------*
 *  Copyright (c) 1991, 1992  Southeastern Universities Research Association, *
 *                            Continuous Electron Beam Accelerator Facility   *
 *                                                                            *
 *    This software was developed under a United States Government license    *
 *    described in the NOTICE file included as part of this distribution.     *
 *                                                                            *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606 *
 *      heyes@cebaf.gov   Tel: (804) 249-7030    Fax: (804) 249-7363          *
 *----------------------------------------------------------------------------*
 * Discription: follows this header.
 *
 * Author:
 *	Graham Heyes
 *	CEBAF Data Acquisition Group
 *
 * Revision History:
 *      $Log: CODA_format.h,v $
 *      Revision 2.8  1998/05/27 13:44:58  heyes
 *      add message Q to ROC, improve EB stability on EBD transition
 *
 *      Revision 2.6  1997/05/19 15:44:57  heyes
 *      add comments
 *
 *      Revision 2.5  1997/03/13 16:58:20  heyes
 *      trying to get this stuff in cvs
 *
 *      Revision 2.4  1997/01/16 15:30:34  heyes
 *      Increase speed of EB, inc. changes after Dec run.
 *
 *      Revision 2.3  1996/10/29 19:03:09  heyes
 *      new rcServer
 *
 *      Revision 2.2  1996/09/19 17:16:08  heyes
 *      Support for CODA file format
 *
 *      Revision 2.1  1996/09/19 14:14:28  heyes
 *      Initial release
 *
 *      Revision 1.2  1996/08/29 17:03:58  heyes
 *----------------------------------------------------------------------------*/

/* The following data structure provides an interface between the event builder and the user provided 
	library of formatting and decoding routines. The data is generatev via calls to various decode
	routines written by the "user" which decode headers. The data is added to by the EB and finally
	passed to encode routines which regenerate the headers in the same, or another format.
	
	    The routine names start with a keyword (in this case CODA) which matches the name of the user
	provided library i.e. CODA_format.so.
	
	In the comments below, (R) = Read-only, (W) = write, (R/W) = read or write.
	
	*/
	
#ifndef __CODA_HEAD
#define  __CODA_HEAD

typedef struct data_description *evDesc;/* a pointer to the rest of this junk! */

typedef struct data_description {
  int evnb;			    /* (R/W) Event number - this can be extracted from the fragment header by
  							the *_decode_frag routine and is passed to the _encode_frag foutine.
  							In the case of *_decode_frag the EB checks that all the fragments of 
  							an event have the same event number. If the event number cannot be 
  							extracted from the header by _*decode_frag then this value should be 
  							set to zero 
  						 */
  						 
  int type;			    /* (R/W) Event type code  - this can be extracted from the fragment header
  							by *_decode_frag or set to zero if only one event (trigger) type exists.
  							For event types < 31 the EB checks that the type from all fragments 
  							matches. Types 0 to 15 are reserved for "physics events, 16 to 31 for
  							"control events and above 31 for "user events which do not require
  							building. */
  							
  int runnb;			/* (R/W) Run number - this can be extracted from control events which contain 
  							this information (i.e. prestart event), the EB checks this number, if the 
  							event format does not contain it *_decode_special should set it to zero.
  							It is set to the correct value (read from database by the EB at prestart)
  							before *_encode_special is called. */
  							
  int runty;			/* (R/W) Run type code (see RunTypes database table, also runnb above. */
  
  
  int syncev;			/* (R) Sync event reserved info. - not used. */
  
  int rocid;			/* (R) Roc ID (see process table in database) - this identifies which ROC 
                           the data came fromit matches the ID in the process table. */
                           
  unsigned long time;	/* (R) Integer time since epoch - set by the EB for use in *_encode_* routines.  
                         */
  
  int rocs[32];			/* (R) Reserved space: to be defined */
  
  int err[32];			/* (R) err[1] = mask of ROCs with sync errors. NOT USED*/
  
  int length;			/* (R/W) length in bytes of ALL data described by this fragment - i.e. the sum
                           of the lengths of all the banks (and partial banks) seen and generated by 
                           *_decode_*  it may be read by *_encode_* NB. do not modify in encode, 
                           this information is used by the EB to move pointers after *_encode_* is
                           called. */
 
  unsigned long *soe;   /* (R) pointer to start of event */
  
  unsigned long *fragments[32]; 
                        /* (W) For each fragment from a ROC there may be several banks or fragments
                        thereof, here the _decode_fragment routine stores pointers to the banks (bank
                        fragments) in the order in which they occur in the event fragment.
                        */
                        
  unsigned long bankTag[32];
  	                    /* (W) Bank tag - for each bank or (bank fragment) identified in "fragments 
  	                    here are the corresponding bank tags (See sub tags below). */
  	                    
  unsigned long bankSubTag[32];	
                       /* (W) Sub tag - for each bank tag (see above) this number specifies the order 
                       that this bank fragment appears in the bank. */
                       
  int fragLen[32];		/* (W) length in bytes of each bank fragment. */
  
  int bankCount;		/* (W) number of bank fragments in this event fragment. */
  
  unsigned long *last;	/* (Internal to EB only , i.e. not R or W) set to 1 if this is 
                        last event in buffer. USER'S DON'T TOUCH! */
  
  unsigned long *buf;	/* (Internal to EB only , i.e. not R or W) pointer to start of buffer which
                        was sent from ROC. If "last" is 1 (See above) this is used to free the 
                        memory allocated. USER"S DON'T TOUCH! */
  
  unsigned long user[20];
                        /* mostly user defined variables, except user[0] which is the length (in bytes)
                        of the event fragment header, This lets the EB skip the headers for bank 
                        fragments which are NOT the first in a bank.
                        */
} DATA_DESC;

/* For each type of event header, these routines move the pointer datap to the first word after
the end of the header. This routine is called TWICE once to calculate what size of buffer is 
required an then to place pointers within that buffer.
*/
extern int CODA_reserv_frag(unsigned long **datap); /* Space for a bank header */

extern int CODA_reserv_desc(unsigned long **datap); /* Space for the descriptor (bank 0) */

extern int CODA_reserv_head(unsigned long **datap); /* Space for the global event header. */

/* Given the descriptor (See above) These routines decode the event or fragment headers and fill
up the empty gaps in the descriptor.
*/
extern int CODA_decode_frag(unsigned long **datap, evDesc desc); /* Generate the contents of "desc" from
                                                                    the event fragment header, */
                                                                    
extern int CODA_decode_desc(unsigned long **datap, evDesc desc); /* Generate the contents of"desc" from
                                                                    the descriptor (bank 0) (NOT USED) */
extern int CODA_decode_head(unsigned long **datap, evDesc desc); /* Generate the contents of "desc" from
                                                                    the event header (NOT USED) */
extern int CODA_decode_spec(unsigned long **datap, evDesc desc); /* Generate the contents of "desc" from
                                                                    "special (or "control) events. */

/* Given the descriptor (See above) These routines generate the event headers
*/
extern int CODA_encode_frag(unsigned long **datap, evDesc desc); /* Generate a bank header from a descriptor. */
extern int CODA_encode_desc(unsigned long **datap, evDesc desc); /* Generate the descriptor (bank 0 (head bank)) 
                                                                    from a descriptor. */
extern int CODA_encode_head(unsigned long **datap, evDesc desc); /* Generate the global event header from 
                                                                    a descriptor. */
extern int CODA_encode_spec(unsigned long **datap, evDesc desc); /* Generate the "special" (or "control") event
                                                                    header from 
                                                                    a descriptor. */

#endif
