/* This file has been generated from the following Tcl source file(s): CODA_class.tcl
 * on Mon Feb  2 10:52:06 EST 2004 by abbottd
 */
#include <tcl.h>
static char initCmd[] = 
    "\n"
    "class CODA {\n"
    "    public  variable local_input \"\"\n"
    "    private variable prime_input \"\"\n"
    "    private variable poll_rate   \"\"\n"
    "    private variable targets     \"\"\n"
    "    private variable class \"0\"\n"
    "    public  variable state \"unknown\"\n"
    "    public  variable name  \"unknown\"\n"
    "    public  variable debug\n"
    "    public  variable nlongs \n"
    "    public  variable nevents \n"
    "\n"
    "    public  variable event_rate 0\n"
    "    public  variable data_rate 0\n"
    "\n"
    "    public  variable codaid  \n"
    "    public  variable targetOK \n"
    "    public  variable session\n"
    "\n"
    "    public variable user_flag1 \"\"\n"
    "    public variable user_flag2 \"\"\n"
    "    public variable user_flag3 0\n"
    "    public variable user_flag4 0\n"
    "    public variable bigendian 1\n"
    "    public variable telnetServer\n"
    "\n"
    "    private variable oldtime 0.0\n"
    "    private variable oldevents 0\n"
    "    private variable oldlongs 0\n"
    "\n"
    "    method   status         {{arg \"\"}}   {}\n"
    "    method   download       {}       {}\n"
    "    method   prestart       {}       {}\n"
    "    method   go             {}       {}\n"
    "    method   end            {}       {}\n"
    "    method   pause          {}       {}\n"
    "\n"
    "    method   exit           {}       {}\n"
    "    method   zap            {}       {}\n"
    "    method   dalogmsg       {sev msg} @logmsgcmd\n"
    "\n"
    "    private method  AcceptTelnetConnection {status file} {}\n"
    "    private method  ShutdownTelnet {file} {}\n"
    "    private method  ProcessData {status file} {}\n"
    "    method connectStdio {file} @CODAConnectStdio\n"
    "    method disconnectStdio {} @CODADisconnectStdio\n"
    "\n"
    "    method   version        {}       {\n"
    "	global tcl_modules coda_version\n"
    "	puts \"CODA version $coda_version\"\n"
    "	puts \"==========================\"\n"
    "	foreach module $tcl_modules  {\n"
    "	    puts \"module : [lindex $module 0]\"\n"
    "	    if {\"[lindex $module 2]\" != \"\"} {\n"
    "		puts \"         Compiled by [lindex $module 2] on [lindex $module 1]\"\n"
    "	    }\n"
    "	    puts \"         CVS info :\"\n"
    "	    set cvs [lindex $module 3]\n"
    "	    puts \"                   File version: [lindex $cvs 2]\"\n"
    "	    puts \"                   Commit by   : [lindex $cvs 5]\"\n"
    "	    puts \"                   Date        : [lindex $cvs 3]\"\n"
    "	    puts \"                   Time        : [lindex $cvs 4]\"\n"
    "	    puts \"                   File status : [lindex $cvs 6]\"\n"
    "	}\n"
    "    }\n"
    "\n"
    "    private method setRates {} {\n"
    "	set newtime [ns_time]\n"
    "	set timediff [expr $newtime - $oldtime]\n"
    "	set event_rate [expr ($nevents - $oldevents)/$timediff]\n"
    "	set data_rate [expr 4*($nlongs - $oldlongs)/$timediff]\n"
    "	set oldlongs $nlongs\n"
    "	set oldevents $nevents\n"
    "	set oldtime $newtime\n"
    "    }\n"
    "\n"
    "    method   statistics {} {\n"
    "	return [list $nevents $event_rate $nlongs $data_rate]\n"
    "    }\n"
    "\n"
    "    constructor             {sess} { \n"
    "	global os_name\n"
    "	set session $sess\n"
    "	if { \"$os_name\" == \"vxworks\" } {\n"
    "	    set rv [dp_connect -server 7030 -reuseAddr]\n"
    "	    \n"
    "	    set telnetServer [lindex $rv 0]\n"
    "	    set port [lindex $rv 1]\n"
    "	    dp_filehandler $telnetServer re \"itcl_context $this ::CODA AcceptTelnetConnection\"\n"
    "	    dp_atexit appendUnique \"close $telnetServer\"\n"
    "	    dp_atclose $telnetServer append \"dp_shutdown $telnetServer both;dp_filehandler $telnetServer;catch {dp_atexit delete \\\"close $telnetServer\\\"};set telnetServer \\\"\\\"\"\n"
    "	}\n"
    "    } @coda_constructor\n"
    "\n"
    "    destructor              @coda_destructor\n"
    "}\n"
    "\n"
    "body CODA::ProcessData {status file} {\n"
    "    \n"
    "    if { \"$status\" == \"e\" } {\n"
    "	puts \"close $file\"\n"
    "	disconnectStdio	\n"
    "	close $file\n"
    "    }\n"
    "\n"
    "}\n"
    "\n"
    "body CODA::AcceptTelnetConnection {status file} {\n"
    "    if {[string compare $status e] == 0} {\n"
    "	close $file;\n"
    "	return; \n"
    "    }\n"
    "    set connection [dp_accept $file]\n"
    "    set newFile [lindex $connection 0]\n"
    "    set inetAddr [lindex $connection 1]\n"
    "    puts \"new connection $newFile\"\n"
    "    dp_atclose $newFile prepend \"itcl_context $this ::CODA ShutdownTelnet $newFile\"\n"
    "    dp_atclose $file appendUnique \"itcl_context $this ::CODA ShutdownTelnet $newFile\"\n"
    "    dp_atexit appendUnique \"close $newFile\"\n"
    "    dp_filehandler $newFile e \"itcl_context $this ::CODA ProcessData\"\n"
    "\n"
    "    connectStdio $newFile\n"
    "}\n"
    "\n"
    "\n"
    "body CODA::ShutdownTelnet {file} {\n"
    "    disconnectStdio\n"
    "\n"
    "    catch \"dp_filehandler $file\"\n"
    "    dp_atexit delete \"close $file\"\n"
    "    catch \"dp_atclose $file clear\"\n"
    "    dp_atclose $server delete \"itcl_context $this ::CODA ShutdownTelnet $file\"\n"
    "}\n"
    "\n"
    "body CODA::status {{arg \"\"}} { \n"
    "    if { \"$arg\" != \"\" } {\n"
    "	$this configure -state $arg\n"
    "	database query \"UPDATE process SET state='$arg' WHERE name='$name'\"\n"
    "    }\n"
    "    return $state\n"
    "}\n"
    "\n"
    "body CODA::download {} {\n"
    "    status downloaded\n"
    "    return $state\n"
    "}\n"
    "\n"
    "body CODA::prestart {} {\n"
    "    status paused\n"
    "    return $state\n"
    "}\n"
    "\n"
    "body CODA::go {} {\n"
    "    status active\n"
    "    return $state\n"
    "}\n"
    "\n"
    "body CODA::end {} {\n"
    "    status downloaded\n"
    "    return $state\n"
    "}\n"
    "\n"
    "body CODA::pause {} {\n"
    "    status paused\n"
    "    return $state\n"
    "}\n"
    "\n"
    "body CODA::exit {} {\n"
    "    global os_name\n"
    "\n"
    "    end\n"
    "    set state configured\n"
    "}\n"
    "\n"
    "body CODA::zap {} {\n"
    "    global os_name\n"
    "\n"
    "    if {\"$os_name\" != \"vxworks\"} {\n"
    "	::exit\n"
    "    }\n"
    "}\n"
    "\n"
    ;
/* End of Tcl code */
/* Init routine to drag this code into our program...*/
int CODA_class_Init (Tcl_Interp *interp)
{
    if (Tcl_Eval(interp,initCmd) != 0) {
    char *val;
    fprintf (stderr, "ERROR:\\n      %s\\n", interp->result);
    val = Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY);
    fprintf (stderr, "TclStack:\\n      %s\\n",val);
       return TCL_ERROR;
    }
    return TCL_OK;
}
/* End of C code */
