/*----------------------------------------------------------------------------*
 *  Copyright (c) 1991, 1992  Southeastern Universities Research Association, *
 *                            Continuous Electron Beam Accelerator Facility   *
 *                                                                            *
 *    This software was developed under a United States Government license    *
 *    described in the NOTICE file included as part of this distribution.     *
 *                                                                            *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606 *
 *      heyes@cebaf.gov   Tel: (804) 249-7030    Fax: (804) 249-7363          *
 *----------------------------------------------------------------------------*
 * Discription: follows this header.
 *
 * Author:
 *	Graham Heyes
 *	CEBAF Data Acquisition Group
 *
 * Revision History:
 *      $Log: BOS_format.h,v $
 *      Revision 2.3  1998/05/27 13:44:56  heyes
 *      add message Q to ROC, improve EB stability on EBD transition
 *
 *      Revision 2.1  1996/11/01 13:39:14  heyes
 *      initial revision of event recorder
 *
 *      Revision 2.3  1996/10/29 19:03:09  heyes
 *      new rcServer
 *
 *      Revision 2.2  1996/09/19 17:16:08  heyes
 *      Support for BOS file format
 *
 *      Revision 2.1  1996/09/19 14:14:28  heyes
 *      Initial release
 *
 *      Revision 1.2  1996/08/29 17:03:58  heyes
 *----------------------------------------------------------------------------*/

typedef struct data_description *evDesc;
typedef struct data_description {
  int evnb;			    /* Event number */
  int type;			    /* Event type code */
  int runnb;			/* Run number */
  int runty;			/* Run type code (see RunTypes database table) */
  int syncev;			/* Sync event reserved info. */
  int rocid;			/* Roc ID (see process table in database) */
  unsigned long time;	/* Integer time since epoch */
  int rocs[32];			/* to be defined */
  int err[32];			/* err[1] = mask of ROCs with sync errors. */
  int length;			/* length in bytes of ALL data described by this
                           fragment */
  unsigned long *soe;           /* pointer to start of event */
  unsigned long *fragments[32]; /* If event consists of banks belonging to
                                   different tags then we store pointers to
                                   the fragments here */
  unsigned long bankTag[32];	/* For each fragment, here is the bank tag */
  unsigned long bankSubTag[32];	/* sequence of fragments in final bank */
  int fragLen[32];		        /* length in bytes of each bank fragment */
  int bankCount;	            /* number of bank fragments */
  int last;                     /* set if this is last event in buffer */
  unsigned long *buf;           /* pointer to start of buffer */
} DATA_DESC;

extern int BOS_reserv_frag(unsigned long **datap);
extern int BOS_reserv_desc(unsigned long **datap);
extern int BOS_reserv_head(unsigned long **datap);

extern int BOS_decode_frag(unsigned long **datap, evDesc desc);
extern int BOS_decode_desc(unsigned long **datap, evDesc desc);
extern int BOS_decode_head(unsigned long **datap, evDesc desc);
extern int BOS_decode_spec(unsigned long **datap, evDesc desc);

extern int BOS_encode_frag(unsigned long **datap, evDesc desc);
extern int BOS_encode_desc(unsigned long **datap, evDesc desc);
extern int BOS_encode_head(unsigned long **datap, evDesc desc);
extern int BOS_encode_spec(unsigned long **datap, evDesc desc);

