.so man.macros
'----------------------------------------------------------------------
.HS Utils tix 4.0
.BS
'
'
.SH NAME
Utils - Utility commands in Tix 4.0.
'
'
'
.SH SYNOPSIS
.TP
\fBtixDescendants\fI \fIpathName\fR
.TP
\fBtixDisableAll \fIpathName\fR
.TP
\fBtixEnableAll \fIpathName\fR
.TP
\fBtixPushGrab\fR ?\fI-global\fR? \fIwindow\fR
.TP
\fBtixPopGrab\fR
.BE
.PP
.SH DESCRIPTION
.PP
.TP
\fBtixDescendants\fR \fIpathName\fR
'
Returns a list of all the descendant widgets of \fIpathName\fR plus
\fIpathName\fR itself.
'
.TP
\fBtixDisableAll\fR \fIpathName\fR
'
Disables \fIpathName\fR and all its descendants.
'
'
.TP
\fBtixEnableAll\fR \fIpathName\fR
'
Enables \fIpathName\fR and all its descendants.
'
'
.TP
\fBtixPushGrab\fR ?\fI-global\fR? \fIwindow\fR
'
The \fBtixPushGrab\fR and \fBtixPopGrab\fR commands allows you to
perform "cascade-grabbing". \fBtixPushGrab\fR calls the \fBgrab(n)\fR
command on \fIwindow\fR and saves \fIwindow\fR on a grabbing
stack.
'
.TP
\fBtixPopGrab\fR
'
\fBtixPopGrab\fR pops the top-most element from the grabbing stack and
release its grab. If the grabbing stack is not empty, then
\fBtixPopGrab\fR will execute grab(n) on the current top-most element
in the grabbing stack.
'
.SH NOTES
.PP
Some Tix widgets (for example, tixComboBox and tixPanedWindow) grabs
the screen on certain occasions using \fBtixPushGrab\fR and
\fBtixPopGrab\fR. Therefore, if you need to grab the screen when these
widgets are present, you should also call \fBtixPushGrab\fR and
\fBtixPopGrab\fR in place of the Tk \fBgrab\fR and \fBgrab release\fR
commands. Otherwise, the behavior of these widgets may be undefined.
'
.SH KEYWORDS
Tix(n),grab(n)
