.so man.macros
'----------------------------------------------------------------------
.HS tixScrolledListBox tix 4.0
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
tixScrolledListBox \- Create and manipulate Tix ScrolledListBox widgets
'
'
'
'----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixScrolledListBox\fI \fIpathName ?\fIoptions\fR?
'
'
'
'----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fB
'
anchor	background	cursor
relief	borderWidth
'
\fR
.ta 4c 
.fi
.LP
See the \fBoptions(n)\fR manual entry for details on the standard options.
'
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'----------BEGIN
.LP
.nf
Name:		\fBanchor\fR
Class:		\fBAnchor\fR
Switch:		\fB\-anchor\fR
.fi
.IP
Specifies the alignment of the items inside the listbox subwidget.
Only the values \fBw\fR and \fBe\fR are allowed. When set to \fBw\fR,
the listbox is automatically aligned to the beginning of the items.
When set to \fBe\fR, the listbox is automatically aligned to the end
of the items.  Automatically alignment only happens when the
ScrolledListBox widget changes its size.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBbrowsecmd\fR
Class:		\fBBrowseCmd\fR
Switch:		\fB\-browsecmd\fR
.fi
.IP
Specifies the command to be called when the user browses the elements
inside the \fBlistbox\fR subwidget (see the BINDINGS section below).
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBcommand\fR
Class:		\fBCommand\fR
Switch:		\fB\-command\fR
.fi
.IP
Specifies the command to be called when the user invokes the \fBlistbox\fR
subwidget (see the BINDINGS section below).
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBheight\fR
Class:		\fBHeight\fR
Switch:		\fB\-height\fR
.fi
.IP
Specifies the desired height for the window, in pixels.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBscrollbar\fR
Class:		\fBScrollbar\fR
Switch:		\fB\-scrollbar\fR
.fi
.IP
Specifies the display policy of the scrollbars. The following
values are recognized:
.RS
'
.TP
\fBauto\fR \fR?\fI\+x\fR? \fR?\fI\-x\fR? \fR?\fI\+y\fR? \fR?\fI\-y\fR? 
'
When \fB\-scrollbar\fR is set to "\fBauto\fR", the scrollbars are
shown only when needed. Additional modifiers can be used to force a
scrollbar to be shown or hidden. For example, "\fBauto \-y\fR" means
the horizontal scrollbar should be shown when needed but the vertical
scrollbar should always be hidden; "\fBauto +x\fR" means the vertical
scrollbar should be shown when needed but the horizontal scrollbar
should always be shown, and so on.
'
.TP
\fBboth\fR
Both scrollbars are shown
'
.TP
\fBnone\fR
The scrollbars are never shown.
'
.TP
\fBx\fR
Only the horizontal scrollbar is shown;
'
.TP
\fBy\fR
Only the vertical scrollbar is shown.
'
.RE
'
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBwidth\fR
Class:		\fBWidth\fR
Switch:		\fB-width\fR
.fi
.IP
Specifies the desired width for the window, in pixels.
'----------END
'
'----------------------------------------------------------------------
.SH SUBWIDGETS
'
'----------BEGIN
.LP
.nf
Name:		\fBhsb\fR
Class:		\fBScrollbar\fR
.fi
.IP
The horizontal scrollbar subwidget.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBlistbox\fR
Class:		\fBListbox\fR
.fi
.IP
The listbox subwidget inside the ScrolledListBox widget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBvsb\fR
Class:		\fBScrollbar\fR
.fi
.IP
The vertical scrollbar subwidget.
'----------END
'
.BE
'
'
'----------------------------------------------------------------------
.SH DESCRIPTION
'
.PP
'
The \fBtixScrolledListBox\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a ScrolledListBox widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the
ScrolledListBox widget such as its cursor and relief.
'
'----------------------------------------------------------------------
.SH WIDGET COMMANDS
.PP
'
The \fBtixScrolledListBox\fR command creates a new Tcl command whose
name is the same as the path name of the ScrolledListBox widget's
window. This command may be used to invoke various operations on the
widget. It has the following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?

.DE
'
\fIPathName\fR is the name of the command, which is the same as the
ScrolledListBox widget's path name. \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following commands
are possible for ScrolledListBox widgets:
'
.TP
'
\fIpathName \fBcget\fR \fIoption\fR
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixScrolledListBox\fR command.
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'
Query or modify the configuration options of the widget.  If
no \fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string.  \fIOption\fR may have
any of the values accepted by the \fBtixScrolledListBox\fR command.
'
.TP
'
\fIpathName \fBsubwidget \fI name ?args?\fR 
'
When no additional arguments are given, returns the pathname of the
subwidget of the specified name.

When no additional arguments are given, the widget command of the
specified subwidget will be called with these parameters.
'
'----------------------------------------------------------------------
'
.SH BINDINGS
.PP
.IP [1]
'
If the \fB\-browsecmd\fR option is set, the command which it referes
to is called whenever a <ButtonPress\-1> or a <Motion\-1> event occurrs
inside the \fBlistbox\fR subwidget.
'
.PP
.IP [2]
'
If the \fB\-selectmode\fR option of the \fBlistbox\fR subwidget is
\fBbrowse\fR, the command specified by the \fB\-command\fR option is
invoked when a <ButtonRelease\-1> event occurrs inside the
\fBlistbox\fR subwidget. If the \fB\-selectmode\fR option of the
\fBlistbox\fR subwidget is \fBsingle\fR, \fBmultiple\fR or
\fBextended\fR, the command specified by the \fB\-command\fR option is
invoked when a <Double\-1> event occurrs inside the \fBlistbox\fR
subwidget.
'
'----------------------------------------------------------------------
'
.SH BUGS
'
The capitalization of some of the commands names in Tix 3.x has been
changed in Tix 4.0. All commands that ended with \fBbox\fR have been
changed to a capitalized \fBBox\fR. Hence, the command
\fBtixScrolledListbox\fR in Tix 3.x has been changed to
\fBtixScrolledListBox\fR in Tix 4.0
'
'
'----------------------------------------------------------------------
.SH KEYWORDS
Tix(n)
