.so man.macros
'----------------------------------------------------------------------
.HS tixPopupMenu tix 4.0
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
tixPopupMenu \- Create and manipulate tixPopupMenu widgets
'
'
'
'----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixPopupMenu\fI \fIpathName ?\fIoptions\fR?
'
'
'----------------------------------------------------------------------
.PP
.SH SUPER-CLASS
The \fBtixPopupMenu\fR class is derived from the \fBTixShell\fR
class and inherits all the commands, options and subwidgets of its
super-class.
'
'----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
'
The PopupMenu widget supports all the standard options of a frame widget.
See the \fBoptions(n)\fR manual entry for details on the standard options.
'
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'
'
'----------BEGIN
.LP
.nf
Name:		\fBstate\fR
Class:		\fBState\fR
Switch:		\fB\-state\fR
.fi
.IP
Must be either \fBdisabled\fR or \fBnormal\fR. The PopupMenu widget will not
pop up unless its \fB\-state\fR is set to \fBnormal\fR.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBtitle\fR
Class:		\fBTitle\fR
Switch:		\fB\-title\fR
.fi
.IP
Specifies a text string to display inside the \fBmenubutton\fR
subwidget, as the title of this PopupMenu.
'----------END
'
'----------------------------------------------------------------------
.SH SUBWIDGETS
'----------BEGIN
.LP
.nf
Name:		\fBmenu\fR
Class:		\fBMenu\fR
.fi
.IP
The menu subwidget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBmenubutton\fR
Class:		\fBMenubutton\fR
.fi
.IP
The menubutton subwidget.
'----------END
'
.BE
'
'----------------------------------------------------------------------
.SH DESCRIPTION
'
.PP
'
The \fBtixPopupMenu\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a PopupMenu widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the
PopupMenu widget such as its cursor and relief.

The Tix PopupMenu widget can be used as a replacement of the
\fBtk_popup\fR command. The advantage of the Tix PopupMenu widget is
it requires less application code to manipulate. Also, it provides a
title for the popup menu, which is not available from \fBtk_popup\fR.
'
'----------------------------------------------------------------------
.SH WIDGET COMMANDS
.PP
'
The \fBtixPopupMenu\fR command creates a new Tcl command whose name is
the same as the path name of the PopupMenu widget's window.  This
command may be used to invoke various operations on the widget. It has
the following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?
.PP
.DE
'
\fIPathName\fR is the name of the command, which is the same as the
PopupMenu widget's path name. \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command. The following commands
are possible for PopupMenu widgets:
.TP
\fIpathName \fBbind \fIwidget \fR?\fIwidget ...\fR?
'
Binds this PopupMenu to one or more \fIwidgets\fR. The PopupMenu
will be activated when the user presses the right mouse button over
these \fIwidgets\fR.
'
.TP
\fIpathName \fBcget\fR \fIoption\fR
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixPopupMenu\fR command.
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string.  \fIOption\fR may have
any of the values accepted by the \fBtixPopupMenu\fR command.
'
'
.TP
\fIpathName \fBpost \fIwidget x y\fR
'
Posts the PopupMenu inside the \fIwidget\fR at the coordinate
\fIx\fR,\fIy\fR.
'
'
.TP
\fIpathName \fBunbind \fIwidget \fR?\fIwidget ...\fR?
'
Cancels the PopupMenu's binding with the \fIwidget(s)\fR.
'
'
.TP
\fIpathName \fBsubwidget \fI name ?args?\fR 
'
When no options are given, this command returns the pathname of the
subwidget of the specified name.

When options are given, the widget command of the specified subwidget
will be called with these options.
'
'
'----------------------------------------------------------------------
'.SH BINDINGS
'.PP
'
'
'----------------------------------------------------------------------
.SH KEYWORDS
Tix(n)
