.so man.macros
'----------------------------------------------------------------------
.HS tixLabelFrame tix 4.0
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
tixLabelFrame \- Create and manipulate tixLabelFrame widgets
'
'
'
'----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixLabelFrame\fI \fIpathName ?\fIoptions\fR?
'
'
'----------------------------------------------------------------------
.PP
.SH SUPER-CLASS
The \fBTixLabelFrame\fR class is derived from the \fBTixLabelWidget\fR
class and inherits all the commands, options and subwidgets of its
super-class.
'
'----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
'
The LabelFrame widget supports all the standard options of a frame
widget. See the \fBoptions(n)\fR manual entry for details on the
standard options.
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'
'
'----------BEGIN
.LP
.nf
Name:		\fBlabel\fR
Class:		\fBLabel\fR
Switch:		\fB\-label\fR
.fi
.IP
Specifies the string to display as the label of this LabelFrame widget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBlabelSide\fR
Class:		\fBLabelSide\fR
Switch:		\fB\-labelside\fR
.fi
.IP
Specifies where the label should be displayed relative to the entry
subwidget. Valid options are: \fBtop\fR, \fBleft\fR, \fBright\fR,
\fBbottom\fR, \fBnone\fR or \fBacrosstop\fR.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBpadX\fR
Class:		\fBPad\fR
Switch:		\fB\-padx\fR
.fi
.IP
Specifies the amount of the horizontal padding around the \fBframe\fR
subwidget. Must be a valid non-negative integer number.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBpadY\fR
Class:		\fBPad\fR
Switch:		\fB\-pady\fR
.fi
.IP
Specifies the amount of the vertical padding around the \fBframe\fR
subwidget.
'----------END
'
'----------------------------------------------------------------------
.SH SUBWIDGETS
'
'----------BEGIN
.LP
.nf
Name:		\fBframe\fR
Class:		\fBFrame\fR
.fi
.IP
The frame subwidget.
'----------END
'----------BEGIN
.LP
.nf
Name:		\fBlabel\fR
Class:		\fBLabel\fR
.fi
.IP
The label subwidget.
'----------END
.BE
'
'----------------------------------------------------------------------
.SH DESCRIPTION
'
.PP
'
The \fBtixLabelFrame\fR command creates a new window (given by
the \fIpathName\fR argument) and makes it into a LabelFrame
widget. Additional options, described above, may be specified on the
command line or in the option database to configure aspects of the
LabelFrame such as its cursor and relief.
'
.SH CREATING WIDGETS INSIDE A LABELFRAME
.PP
'
The LabelFrame widget packages a frame widget and a label into one
mega widget. To create widgets inside a LabelFrame widget, one must
create the new widgets relative to the \fBframe\fR subwidget and
manage them inside the \fBframe\fR subwidget. An error will be
generated if one tries to create widgets as immediate children of the
LabelFrame. For example: the following is correct code, which creates
new widgets inside the frame subwidget:
.PP
.nf
    tixLabelFrame .f
    set f [.f subwidget frame]
    button $f.b \-text hi
    pack $f.b
.fi
.PP
The following example code is \fIincorrect\fR because it tries to
create immediate children of the LabelFrame \fB\.f\fR:
.PP
.nf
    tixLabelFrame .f
    button .f.b \-text hi
    pack .f.b
.fi
'
'
'----------------------------------------------------------------------
.SH WIDGET COMMANDS
.PP
'
The \fBtixLabelFrame\fR command creates a new Tcl command whose
name is the same as the path name of the LabelFrame's
window. This command may be used to invoke various operations on the
widget. It has the following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?
.PP
.DE
'
\fIPathName\fR is the name of the command, which is the same as the
LabelFrame widget's path name. \fIOption\fR and the
\fIarg\fRs determine the exact behavior of the command. The following
commands are possible for LabelFrame widgets:
'
.TP
\fIpathName \fBcget\fR \fIoption\fR
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixLabelFrame\fR command.
'
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string.  \fIOption\fR may have
any of the values accepted by the \fBtixLabelFrame\fR command.
'
'
'
.TP
\fIpathName \fBsubwidget \fIname ?args?\fR 
'
When no options are given, this command returns the pathname of the
subwidget of the specified name.

When options are given, the widget command of the specified subwidget
will be called with these options.
'
'
'
'----------------------------------------------------------------------
'.SH BINDINGS
'.PP
'
'
'
'----------------------------------------------------------------------
.SH KEYWORDS
Tix(n)
