/************************************************************************
 *									*
 *	Copyright 1993 by Motorola Wireless Data Group,			*
 *			  Bothell, WA					*
 *									*
 *	Motorola hereby grants permission to use, copy, modify and	*
 *	distribute  this software and its documentation for any		*
 *	purpose and without fee, provided that you retain this		*
 *	copyright notice in all copies.  Motorola makes no		*
 *	representations about the suitability of this software for any	*
 *	purpose.  Motorola provides this software ``as is'' without	*
 *	express or implied warranty.					*
 *									*
 ************************************************************************/

/* $Header: /mizar/local/source/coda_source/Tcl/src7.4/svipc/svipc.h,v 1.1.1.1 1996/08/21 19:30:09 heyes Exp $ */

/*
 * File: svipc.h
 * Facility: System V IPC interface to Tcl.
 * Description:
 *	Define the alignment checking macros for svipcShm and svipcLink.
 */

#define SVIPC_VERSION "2.1"
#define SVIPC_MAJOR_VERSION 2
#define SVIPC_MINOR_VERSION 1

#ifndef SVIPC_CHECK_ALIGN
# define SVIPC_CHECK_ALIGN 1
#endif /* SVIPC_CHECK_ALIGN */

#if SVIPC_CHECK_ALIGN
# define SVIPC_DOUBLE_ALIGN	(sizeof(double)-1)
# define SVIPC_LONG_ALIGN	(sizeof(long)-1)
# define SVIPC_SHORT_ALIGN	(sizeof(short)-1)
#else /* not SVIPC_CHECK_ALIGN */
# define SVIPC_DOUBLE_ALIGN	0
# define SVIPC_LONG_ALIGN	0
# define SVIPC_SHORT_ALIGN	0
#endif /* not SVIPC_CHECK_ALIGN */

#define SVIPC_LINK_CHAR		(TCL_LINK_STRING+1)
#define SVIPC_LINK_UCHAR	(TCL_LINK_STRING+2)
#define SVIPC_LINK_SHORT	(TCL_LINK_STRING+3)
#define SVIPC_LINK_USHORT	(TCL_LINK_STRING+4)
#define SVIPC_LINK_STATICSTR	(TCL_LINK_STRING+5)
