/* tcpClient.c - TCP client example */ 
/* DESCRIPTION This file contains the client-side of the VxWorks TCP example code. 
   The example code demonstrates the usage of several BSD 4.4-style socket routine calls. */ 

/* includes */ 
#ifdef VXWORKS
#include "vxWorks.h" 
#include "sockLib.h" 
#include "inetLib.h" 
#include "stdioLib.h" 
#include "strLib.h" 
#include "hostLib.h" 
#include "ioLib.h" 
#else
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#define TRUE 1
#define FALSE 0
#define OK 0
#define ERROR -1
#define STD_IN stdin
#endif
#include "tcpExample.h" 

/**************************************************************************** 
* * tcpClient - send requests to server over a TCP socket 
* * This routine connects over a TCP socket to a server, and sends a 
* user-provided message to the server. Optionally, this routine 
* waits for the server's reply message. 
* * This routine may be invoked as follows: 
* -> tcpClient "remoteSystem" 
* Message to send: 
* Hello out there 
* Would you like a reply (Y or N): 
* y 
* value =0 =0x0 
* -> MESSAGE FROM SERVER: 
* Server received your message 
* * RETURNS: OK, or ERROR if the message could not be sent to the server. */ 

#ifdef VXWORKS

STATUS 
tcpClient ( char * serverName) 
{
#else

main(argc,argv)
     int argc;
     char *argv[];
{

  struct hostent *hptr;
#endif
 
  struct request myRequest; /* request to send to server */ 
  struct sockaddr_in serverAddr; /* server's socket address */ 
  char replyBuf[REPLY_MSG_SIZE]; /* buffer for reply */ 
  char reply; /* if TRUE, expect reply back */ 
  int sockAddrSize; /* size of socket address structure */ 
  int sFd; /* socket file descriptor */ 
  int mlen; /* length of message */
  int rBytes;

#ifndef VXWORKS  /* make sure all arguments are there */
  if (argc<3) {
    printf("Usage: vxcmd <target name> [command]\n");
    exit(1);
  }
#endif

  /* create client's socket */ 
  if ((sFd = socket (AF_INET, SOCK_STREAM, 0)) == ERROR) { 
    perror ("socket"); 
    return (ERROR); 
  } 

  /* bind not required - port number is dynamic */ 
  /* build server socket address */ 
  sockAddrSize = sizeof (struct sockaddr_in); 
  bzero ((char *) &serverAddr, sockAddrSize); 
  serverAddr.sin_family = AF_INET; 
#ifdef VXWORKS
  serverAddr.sin_len = (u_char) sockAddrSize; 
#endif
  serverAddr.sin_port = htons (SERVER_PORT_NUM); 

#ifdef VXWORKS
  if (((serverAddr.sin_addr.s_addr = inet_addr (serverName)) == ERROR) && 
      ((serverAddr.sin_addr.s_addr = hostGetByName (serverName)) == ERROR)) { 
    perror ("unknown server name"); 
    close (sFd); 
    return (ERROR); 
  } 
#else
  hptr = gethostbyname(argv[1]);
  if(hptr == NULL) {
      printf("unknown hostname %s \n",argv[1]); 
      close(sFd);
      exit(1);
    } else {
      memcpy(&serverAddr.sin_addr,*(hptr->h_addr_list),sizeof(sizeof(struct in_addr)));
    }
#endif

  /* connect to server */ 
  if (connect (sFd, (struct sockaddr *) &serverAddr, sockAddrSize) == ERROR) { 
    perror ("connect"); 
    close (sFd); 
    return (ERROR); 
  } 

  /* build request, prompting user for message */ 
#ifdef VXWORKS
  printf ("Message to send: \n"); 
  mlen = read (STD_IN, myRequest.message, REQUEST_MSG_SIZE); 
  myRequest.msgLen = mlen; 
  myRequest.message[mlen - 1] = '\0'; 
  printf ("Would you like a reply (Y or N): \n"); 
  read (STD_IN, &reply, 1); 
  switch (reply) { 
  case 'y': 
  case 'Y': 
    myRequest.reply = TRUE; 
    break; 
  default: 
    myRequest.reply = FALSE; 
    break; 
  } 
#else

  myRequest.msgLen = strlen(argv[2]);
  sprintf(myRequest.message,"%s\0",argv[2]);
  myRequest.reply = TRUE;

  printf(" Sending %d bytes: %s\n",myRequest.msgLen, myRequest.message);

#endif

  /* send request to server */ 
  if (write (sFd, (char *) &myRequest, sizeof (myRequest)) == ERROR) { 
    perror ("write"); 
    close (sFd); 
    return (ERROR);
  } 

  if (myRequest.reply) /* if expecting reply, read and display it */ { 
    int remB = 0;
    while ( (rBytes = read (sFd, (char *)&replyBuf[remB], REPLY_MSG_SIZE)) > 0) { 
      remB += rBytes;
    } 
    printf ("MESSAGE FROM SERVER (%d bytes) :\n%s\n", remB,replyBuf); 
  } 
  close (sFd); 
  return (OK); 
} 

