/******************************************************************************
*
*  sis3801Lib.h  -  Driver library header file for readout of a Struck 3801
*                   Multi-scaler using a VxWorks 5.3.1 or
*                   later based single board computer.
*
*  Author: David Abbott 
*          Jefferson Lab Data Acquisition Group
*          September 2006
*/

/* Define a Structure for access to  Scaler */
struct s3801_struct {
  volatile unsigned int csr;
  volatile unsigned int irq;
  volatile unsigned int blank1;
  volatile unsigned int cdr;
  volatile unsigned int wfifo;
  volatile unsigned int blank2[3];
  volatile unsigned int clear;
  volatile unsigned int next;
  volatile unsigned int enable;
  volatile unsigned int disable;
  volatile unsigned int blank3[8];
  volatile unsigned int enablerefpulser;
  volatile unsigned int disablerefpulser;
  volatile unsigned int blank4[2];
  volatile unsigned int reset;
  volatile unsigned int blank5;
  volatile unsigned int test;
  volatile unsigned int blank6[5];
  volatile unsigned int prescalefactor;
  volatile unsigned int blank7[31];
  volatile unsigned int fifo[64];
};

/* Define default interrupt vector/level */
#define S3801_INT_VEC      0xda
#define S3801_VME_INT_LEVEL   5
#define S3801_BOARD_ID    0x38010000

/* Define CSR Register Bits */
#define S3801_CSR_LED                        0x1
#define S3801_CSR_FIFO_TEST                  0x2
#define S3801_CSR_INPUT_BIT0                 0x4
#define S3801_CSR_INPUT_BIT1                 0x8
#define S3801_CSR_25MHZ_TEST                0x10
#define S3801_CSR_INPUT_TEST                0x20
#define S3801_CSR_BROADCAST_MODE            0x40
#define S3801_CSR_HANDSHAKE_MODE            0x80
#define S3801_CSR_EXT_NEXT                0x1000
#define S3801_CSR_EXT_CLEAR               0x2000
#define S3801_CSR_EXT_DISABLE             0x4000
#define S3801_CSR_SOFT_DISABLE            0x8000
#define S3801_CSR_IRQ_CIP                0x10000
#define S3801_CSR_IRQ_FIFO_ALMOST_EMPTY  0x20000
#define S3801_CSR_IRQ_FIFO_HALF_FULL     0x40000
#define S3801_CSR_IRQ_FIFO_FULL          0x80000

/* Define CSR Status bits */
#define S3801_STATUS_TEST_MODE              0x20
#define S3801_STATUS_FIFO_EMPTY            0x100
#define S3801_STATUS_FIFO_ALMOST_EMPTY     0x200
#define S3801_STATUS_FIFO_HALF_FULL        0x400
#define S3801_STATUS_FIFO_ALMOST_FULL      0x800
#define S3801_STATUS_FIFO_FULL            0x1000
#define S3801_STATUS_ENABLE_NEXT          0x8000


#define S3801_CLEAR(a)       (a<<8)

/* Define Masks */
#define S3801_INPUT_MODE_MASK          0xc
#define S3801_FIFO_STATUS_MASK      0x1f00
#define S3801_VERSION_MASK          0xf000
#define S3801_ENABLE_IRQ_MASK     0xf00000
#define S3801_DISABLE_IRQ_MASK  0xf0000000
#define S3801_INT_VEC_MASK            0xff
#define S3801_INT_LEVEL_MASK         0x700
#define S3801_INT_ENABLED_MASK       0x800
#define S3801_BOARD_ID_MASK    0xffff0000





 


