# Bootfile for JLAB F1 TDC
# PowerPC version
# Boot file for CODA ROC 2.5 
# PowerPC version

#loginUserAdd "abbottd","yzzbdbccd"

# Load host table
hostAdd "mizar","129.57.14.33"
hostAdd "mizar.jlab.org","129.57.14.33"
hostAdd "alcor","129.57.14.30"
hostAdd "alcor.jlab.org","129.57.14.30"

# Setup environment / load coda_roc
putenv "MSQL_TCP_HOST=mizar"
putenv "EXPID=experiment_0"
putenv "TCL_LIBRARY=/usr/local/coda/2.5/common/lib/tcl7.4"
putenv "ITCL_LIBRARY=/usr/local/coda/2.5/common/lib/itcl2.0"
putenv "DP_LIBRARY=/usr/local/coda/2.5/common/lib/dp"
putenv "CMLOG_PORT=8103"
putenv "CMLOG_HOST=alcor"  
putenv "TOKEN_PORT=5555"
putenv "SESSION=davetest"


# Download Message logging libraries/client
ld < /group/da/CMLOG/CMLOG-R2_1-PROD-1/bin/ppc-vw55/cmlogClientD
ld < /group/da/CMLOG/CMLOG-R2_1-PROD-1/lib/ppc-vw55/libcmlog.a
ld < /group/da/CMLOG/CMLOG-R2_1-PROD-1/bin/ppc-vw55/cmlogVxLogMsg

#load the ROC
cd "/usr/local/coda/2.5/VXWORKSPPC/bin"
ld < coda_roc

cd "/mizar/home/abbottd/vxWorks/f1tdc"

# Load Universe DMA Library
ld<../universeDma/universeDma.o
#initialize (no interrupts (1))
sysVmeDmaInit(1) 
# Set for 32bit (0) or 64bit (1) PCI transfers
sysVmeDmaSet(4,1)
# A24 (1) or A32 (2) VME Slave
sysVmeDmaSet(11,2)
# BLK32 (4) or MBLK(64) (5) VME transfers
sysVmeDmaSet(12,4)

# Load F1 library
ld<f1tdcLib.o
# Load a Config Datafile
f1ConfigReadFile("normal_120.dat")
# Initialize 8 F1TDCs using datafile config and use a Backplane Dist Card
# flag = 4 (from a file) + 8 (Use BDC) = 12 = 0xc
f1Init(0xed0000,0x1000,8,0xc)


# Spawn tasks
sp cmlogClientD
sp cmlogVxLogMsg
taskDelay (60*5)
taskSpawn ("ROC",200,8,250000,coda_roc,"","-s","davetest","-objects","ROC1 ROC")
