# Boot file for CODA ROC 2.5 
# PowerPC version

# Create host table
hostAdd "mizar","129.57.14.33"
hostAdd "mizar.jlab.org","129.57.14.33"
hostAdd "alcor","129.57.14.30"
hostAdd "alcor.jlab.org","129.57.14.30"


# Setup environment / load coda_roc
putenv "MSQL_TCP_HOST=mizar"
putenv "EXPID=experiment_0"
putenv "TCL_LIBRARY=/site/coda/2.5/common/lib/tcl7.4"
putenv "ITCL_LIBRARY=/site/coda/2.5/common/lib/itcl2.0"
putenv "DP_LIBRARY=/site/coda/2.5/common/lib/dp"
putenv "CMLOG_PORT=8103"
putenv "CMLOG_HOST=alcor"  
putenv "TOKEN_PORT=5555"
putenv "SESSION=davetest"


# Download Message logging libraries/client
ld < /site/coda/CMLOG/2.1/bin/ppc-vw54/cmlogClientD
ld < /site/coda/CMLOG/2.1/lib/ppc-vw54/libcmlog.a
ld < /site/coda/CMLOG/2.1/bin/ppc-vw54/cmlogVxLogMsg

# load the ROC
cd "/site/coda/2.5/VXWORKSPPC54/bin"
ld < coda_roc

# load hardware libraries
#cd "../lib"
#ld < libsfifb.o
#fb_init_1(0xfae00000)

# Load Universe Library
ld< /site/coda/2.5/extensions/universeDma/universeDma.o.5.4
#initialize (1 no interrupts) or (0 interrupts enabled)
sysVmeDmaInit(1) 
# Set for 64bit PCI transfers
sysVmeDmaSet(4,1)
# A24 VME Slave (1) or A32 Slave (2)
sysVmeDmaSet(11,2)
# BLK32 (4) or MBLK(64) (5) VME transfers
sysVmeDmaSet(12,4)


# Spawn tasks
sp cmlogClientD
#sp cmlogVxLogMsg
taskDelay (60*5)
#taskSpawn ("ROC",200,8,250000,coda_roc,"-i","-s","davetest","-objects","ROC1 ROC")
taskSpawn ("ROC",200,8,250000,coda_roc,"","-s","davetest","-objects","ROC1 ROC")


