.\"**********************************************************************
.\"*									*
.\"*	Copyright 1993 by Motorola Mobile Data Division,		*
.\"*			  Bothell, WA					*
.\"*									*
.\"*	Motorola hereby grants permission to use, copy, modify and	*
.\"*	distribute  this software and its documentation for any		*
.\"*	purpose and without fee, provided that you retain this		*
.\"*	copyright notice in all copies.  Motorola makes no		*
.\"*	representations about the suitability of this software for any	*
.\"*	purpose.  Motorola provides this software ``as is'' without	*
.\"*	express or implied warranty.					*
.\"*									*
.\"**********************************************************************
.\"
.\" $Header: /mizar/local/source/coda_source/Tcl/src7.4/svipc/man/shmacc.n,v 1.1.1.1 1996/08/21 19:30:10 heyes Exp $
.\"
.TH "Tcl_memory_access" TCL "" "Tcl"
.SH NAME
getchar, getlong, getshort, getstr, getstrn, setchar, setlong,
setshort, setstr, setstrn - Tcl interface to memory access functions.

.SH SYNOPSIS
.nf
\fBgetchar \fIaddr nitems ?varName?\fR

\fBgetlong \fIaddr nitems ?varName?\fR

\fBgetshort \fIaddr nitems ?varName?\fR

\fBgetstr \fIaddr ?varName?\fR

\fBgetstrn \fIaddr length ?varName?\fR

\fBsetchar \fIaddr ?value...?\fR

\fBsetlong \fIaddr ?value...?\fR

\fBsetshort \fIaddr ?value...?\fR

\fBsetstr \fIaddr ?string?\fR

\fBsetstrn \fIaddr length ?string?\fR
.fi

.SH DESCRIPTION
These commands access virtual memory addresses and convert the
contents into Tcl strings.  The \fIchar\fR, \fIlong\fR, and
\fIshort\fR commands treat the memory locations as signed binary and
return integer strings.  The \fIstr\fR and \fIstrn\fR functions treat
the address as the start of a string of characters and return that
string value (using either strcpy(3) or strncpy(3).)
.PP
The \fIaddr\fR argumentspecifies the memory location which contains
the requested data (\fIget\fR operation) or the location to modify
(\fIset\fR operation.)  The procedures verify alignment to the
appropriate boundary in the \fIshort\fR and \fIlong\fR instances.
.PP
The \fIget\fR commands return a list of integers taken from the
starting address, and optionally set the \fIvarName\fR parameter to
the returned values.
.PP
The \fIset\fR commands place the indicated \fIvalue\fRs into the cells
starting at \fIaddr\fR and return the new contents as a list of
integers.  If no \fIvalue\fR parameters exist, the \fIset\fR commands
simply return the current contents of the addressed cell (similar to
the Tcl \fIset\fR command.)
.PP
These commands work on arbitrary virtual memory addresses, but seem
most usefully applied to addresses in a shared memory segment, as
Tcl commands cannot acquire other program addresses.

.SH SEE ALSO

.SH AUTHOR
.nf
Joe Kelsey
Motorola Wireless DataGroup
19807 NorthCreek Parkway N.
Bothell, WA  98011
206.489.5746
kelsey@mdd.comm.mot.com
