/****************************** Copyright Notice ******************************
 *                                                                            *
 * Copyright (c) 1992 Universities Research Association, Inc.                 *
 *               All Rights Reserved.                                         *
 *                                                                            *
 ******************************************************************************/
/*

File:		fb_errtxt.h
=====

Author:		Margaret Votava
=======		on-line support department
		Fermilab MS 120
		P.O. Box 500
		Batavia, IL  60510
		(708) 840-2625

	e-mail: "votava@fnal.fnal.gov"

Creation date:	8-Jun-1992
==============

Revision history:-
=================

8-Jun-1992	creation


Description:-
============

	Error text for the error that can be returned from FASTBUS
	standard routines.

	We need to start with a null string to match murmur - it does
	not allow a base number of 0.

Macros:-
=======
*/

#ifndef INCfb_errtxt
#define INCfb_errtxt

  char	*FB_ERRTXT[FB_ERROR_MAX+1] =
	{
	"",
	"ERROR: Fastbus error 0x%X in %s in %s - address release timeout, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - AK timeout, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - block data - SS=2, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - data cycle parity error, PAD = %d, SAD = %d\n",	
	"ERROR: Fastbus error 0x%X in %s in %s - data cycle SS=0, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - data cycle SS=1, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - data cycle SS=2, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - data cycle SS=3, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - data cycle SS=4, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - data cycle SS=5, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - data cycle SS=6, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - data cycle SS=7, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - DK release timeout, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - DK timeout, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - long timeout, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - primary address cycle SS=0, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - primary address cycle SS=1, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - primary address cycle SS=2, PAD = %d, SAD = %d\n",	
	"ERROR: Fastbus error 0x%X in %s in %s - primary address cycle SS=3, PAD = %d, SAD = %d\n",	
	"ERROR: Fastbus error 0x%X in %s in %s - primary address cycle SS=4, PAD = %d, SAD = %d\n",	
	"ERROR: Fastbus error 0x%X in %s in %s - primary address cycle SS=5, PAD = %d, SAD = %d\n",	
	"ERROR: Fastbus error 0x%X in %s in %s - primary address cycle SS=6, PAD = %d, SAD = %d\n",	
	"ERROR: Fastbus error 0x%X in %s in %s - primary address cycle SS=7, PAD = %d, SAD = %d\n",	
	"ERROR: Fastbus error 0x%X in %s in %s - secondary address cycle DK timeout, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - secondary address cycle SS=0, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - secondary address cycle SS=1, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - secondary address cycle SS=2, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - secondary address cycle SS=3, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - secondary address cycle SS=4, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - secondary address cycle SS=5, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - secondary address cycle SS=6, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - secondary address cycle SS=7, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - software timeout, PAD = %d, SAD = %d\n",
	"ERROR: Fastbus error 0x%X in %s in %s - wait timeout, PAD = %d, SAD = %d\n",

	"ERROR: Fastbus error 0x%X in %s in %s - normal successful completion\n",
	"ERROR: Fastbus error 0x%X in %s in %s - error accessing data buffer\n",
	"ERROR: Fastbus error 0x%X in %s in %s - abort action\n",
	"ERROR: Fastbus error 0x%X in %s in %s - already connected\n",
	"ERROR: Fastbus error 0x%X in %s in %s - bad parameter value\n",
	"ERROR: Fastbus error 0x%X in %s in %s - buffer overflow\n",
	"ERROR: Fastbus error 0x%X in %s in %s - session closed, no actions possible\n",
	"ERROR: Fastbus error 0x%X in %s in %s - routine connection failed\n",
	"ERROR: Fastbus error 0x%X in %s in %s - routine disconnect failed\n",
	"ERROR: Fastbus error 0x%X in %s in %s - environment active\n",
	"ERROR: Fastbus error 0x%X in %s in %s - environment id overflow\n",
	"ERROR: Fastbus error 0x%X in %s in %s - environment overflow\n",
	"ERROR: Fastbus error 0x%X in %s in %s - environment release\n",
	"ERROR: Fastbus error 0x%X in %s in %s - generic error\n",
	"ERROR: Fastbus error 0x%X in %s in %s - generic fatal\n",
	"ERROR: Fastbus error 0x%X in %s in %s - hardware error\n",
	"ERROR: Fastbus error 0x%X in %s in %s - hardware warning\n",
	"ERROR: Fastbus error 0x%X in %s in %s - holding address\n",
	"ERROR: Fastbus error 0x%X in %s in %s - holding bus\n",
	"ERROR: Fastbus error 0x%X in %s in %s - error was ignored\n",
	"ERROR: Fastbus error 0x%X in %s in %s - illegal parameter value\n",
	"ERROR: Fastbus error 0x%X in %s in %s - illegal sequential buffer id\n",
	"ERROR: Fastbus error 0x%X in %s in %s - unexpected implementation error\n",
	"ERROR: Fastbus error 0x%X in %s in %s - generic informational\n",
	"ERROR: Fastbus error 0x%X in %s in %s - invalid environment id\n",
	"ERROR: Fastbus error 0x%X in %s in %s - invalid list pointer\n",
	"ERROR: Fastbus error 0x%X in %s in %s - invalid port id\n",
	"ERROR: Fastbus error 0x%X in %s in %s - invalid sequential buffer id\n",
	"ERROR: Fastbus error 0x%X in %s in %s - last primary address\n",
	"ERROR: Fastbus error 0x%X in %s in %s - last secondary address\n",
	"ERROR: Fastbus error 0x%X in %s in %s - last list pointer\n",
	"ERROR: Fastbus error 0x%X in %s in %s - list overflow\n",
	"ERROR: Fastbus error 0x%X in %s in %s - long timer on\n",
	"ERROR: Fastbus error 0x%X in %s in %s - no address connection\n",
	"ERROR: Fastbus error 0x%X in %s in %s - no more status\n",
	"ERROR: Fastbus error 0x%X in %s in %s - no privilege\n",
	"ERROR: Fastbus error 0x%X in %s in %s - no supplementary status\n",
	"ERROR: Fastbus error 0x%X in %s in %s - not connected\n",
	"ERROR: Fastbus error 0x%X in %s in %s - not holding mastership\n",
	"ERROR: Fastbus error 0x%X in %s in %s - not master\n",
	"ERROR: Fastbus error 0x%X in %s in %s - session already open\n",
	"ERROR: Fastbus error 0x%X in %s in %s - operation pending\n",
	"ERROR: Fastbus error 0x%X in %s in %s - pipeline transfer\n",
	"ERROR: Fastbus error 0x%X in %s in %s - pointer overflow\n",
	"ERROR: Fastbus error 0x%X in %s in %s - port active\n",
	"ERROR: Fastbus error 0x%X in %s in %s - port already allocated\n",
	"ERROR: Fastbus error 0x%X in %s in %s - port not allocated\n",
	"ERROR: Fastbus error 0x%X in %s in %s - port not available\n",
	"ERROR: Fastbus error 0x%X in %s in %s - port owned\n",
	"ERROR: Fastbus error 0x%X in %s in %s - read only parameter\n",
	"ERROR: Fastbus error 0x%X in %s in %s - operation successfully retried\n",
	"ERROR: Fastbus error 0x%X in %s in %s - sequenctial buffer active\n",
	"ERROR: Fastbus error 0x%X in %s in %s - sequenctial buffer exists\n",
	"ERROR: Fastbus error 0x%X in %s in %s - sequenctial buffer id overflow\n",
	"ERROR: Fastbus error 0x%X in %s in %s - software timer on\n",
	"ERROR: Fastbus error 0x%X in %s in %s - status not found\n",
	"ERROR: Fastbus error 0x%X in %s in %s - status overflow\n",
	"ERROR: Fastbus error 0x%X in %s in %s - successful operation\n",
	"ERROR: Fastbus error 0x%X in %s in %s - unknown error\n",
	"ERROR: Fastbus error 0x%X in %s in %s - unknown parameter\n",
	"ERROR: Fastbus error 0x%X in %s in %s - unsupported port operation\n",
	"ERROR: Fastbus error 0x%X in %s in %s - unsupported paramter\n",
	"ERROR: Fastbus error 0x%X in %s in %s - unsupported routine\n",
	"ERROR: Fastbus error 0x%X in %s in %s - user array overflow\n",
	"ERROR: Fastbus error 0x%X in %s in %s - generic warning\n",
	"ERROR: Fastbus error 0x%X in %s in %s - fscc FIFO error\n",
	};

#endif 	/* (ifdef INCfb_errtxt) */
