#!/bin/sh
#\
exec $CODA_BIN/dpwish -notk -f "$0" ${1+"$@"}
#
# valid fifo modes are: all,request and conditional
# valid wait modes are: sleep and async
# prescale is 1 for every event 10 for every tenth event etc...
global nevents
set nevents 0

if { $argc == 4  } {

    eval "ddu_init $argv"
    
    ddu_start
    
    struct_typedef fev {struct
	{int shmid}
	{int dboff}
	{int p2da}
	{int len}
	{int ctlw1}
	{int ctlb1}
	{int ctlw2}
	{int ctlb2}
    }
    
    struct_typedef ev_buf {struct
	{ulong len}
	{ulong*0 data}
    }
    
    proc insert_event {} {
	global nevents	
	if {[catch "ddu_get_fev" addr]} return
	
	struct_new fifoev fev fev@$addr 
	
	struct_new buf ev_buf ev_buf@$fifoev(p2da)
	
	if { [expr $nevents % 1000] == 0} {
	    puts "nevents $nevents"
	    puts "len [set buf(len)], data(0)=[format "%08x" [set buf(data.0)]]"
	}
	incr nevents
	unset fifoev
	unset buf
	
	if {[catch "ddu_put_fev $addr"]} return
    }
    
    while {[ddu_attached]} {
	insert_event
    }

    exit
} else {
    puts "usage : $argv0 <fifo name> <fifo mode> <prescale> <wait mode>" 
    exit
}