/**************************************************************************
 * Copyright (c)   2001    Southeastern Universities Research Association,
 *                         Thomas Jefferson National Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
 **************************************************************************
 *
 * Description:
 *      Connect menu button inside File Menu
 *
 * Author:  
 *      Jie Chen
 *      Jefferson Lab HPC Group
 *
 * Revision History:
 *   $Log: Connect.java,v $
 *   Revision 1.1  2001/10/18 18:45:40  chen
 *   First version of Jcmlog
 *
 *
 *
 */
package cmlog.gui;

import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

import cmlog.*;

public class Connect extends JMenuItem implements ActionListener
{
    /**
     * Reference to display object.
     */
    private Disp disp_;

    /**
     * Connection dialog.
     */
    ConnectDialog dialog_ = null;

    /**
     * Constructor
     */
    public Connect (Disp disp, JMenu menu)
    {
	super ("Connect", KeyEvent.VK_C);
	
	disp_ = disp;

	addActionListener (this);

	menu.add (this);

	// create connect dialog
	dialog_ = new ConnectDialog (disp, this);
    }

    /**
     * Implmentation of actionPerformed when exit button is pressed.
     */
    public void actionPerformed(ActionEvent e) 
    {
	dialog_.pack ();
	dialog_.setLocationRelativeTo (disp_.getParentWindow());
	// I have to use setVisiable instead of show to make sure
	// dialog box is poped up on top of table widget.
	dialog_.setVisible (true);
    }
}









