//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG utility routines
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogUtil.h,v $
//   Revision 1.4  2001/07/25 14:26:39  chen
//   64 BIT Initial Port
//
//   Revision 1.3  2000/06/20 19:32:50  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.2  2000/01/04 14:19:53  chen
//   port to redhat 6.0
//
//   Revision 1.1.1.1  1999/09/07 15:29:10  chen
//   CMLOG version 2.0
//
// Revision 1.4  1998/11/19  17:29:42  chen
// Support multiple directories for database
//
// Revision 1.3  1997/09/15  14:29:35  chen
// change PAGE_SIZE to DBASE_PAGESIZE
//
// Revision 1.2  1997/09/15  13:48:46  chen
// add page size as configuration parameter
//
// Revision 1.1  1997/08/01  15:27:45  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_UTIL_H
#define _CMLOG_UTIL_H

#include <stdio.h>
#include <string.h>

#define CMLOG_KEY_TAG_STR      (char *)("cmlogTime")
#define CMLOG_STR_TAG_STR      (char *)("cmlogString")
#define CMLOG_CLNTCXT_TAG_STR  (char *)("cmlogClntCxt")
#define CMLOG_HOST_TAG_STR     (char *)("host")
#define CMLOG_PID_TAG_STR      (char *)("pid")
#define CMLOG_NAME_TAG_STR     (char *)("name")
#define CMLOG_CLASS_TAG_STR    (char *)("class")
#define CMLOG_DOMAIN_TAG_STR   (char *)("domain")
#define CMLOG_FACILITY_TAG_STR (char *)("facility")
#define CMLOG_CODE_TAG_STR     (char *)("code")
#define CMLOG_VERBOSITY_TAG_STR (char *)("verbosity")
#define CMLOG_SEVERITY_TAG_STR (char *)("severity")
#define CMLOG_USER_TAG_STR     (char *)("user")
#define CMLOG_TEXT_TAG_STR     (char *)("text")
#define CMLOG_STATUS_TAG_STR   (char *)("status")
#define CMLOG_VALUE_TAG_STR    (char *)("value")
#define CMLOG_RESULT_TAG_STR   (char *)("resultCode")
#define CMLOG_INCOMPLETE_TAG_STR (char *)("incomplete")
#define CMLOG_CLNTID_TAG_STR   (char *)("cmlogClntId")
#define CMLOG_DISP_TAG_STR     (char *)("cmlogDispName")
#define CMLOG_DROPPED_TAG_STR  (char *)("dropped")
#define CMLOG_START_TAG_STR    (char *)("start")
#define CMLOG_END_TAG_STR      (char *)("end")
#define CMLOG_PROC_TAG_STR     (char *)("process")
#define CMLOG_NUMITEMS_TAG_STR (char *)("numberItems")
#define CMLOG_QUERYMSG_TAG_STR (char *)("queryMsg")
#define CMLOG_LINE_TAG_STR     (char *)("line")

#define CMLOG_BAD_FD           3456

class cmlogUtil
{
public:
  // get current host ip addr in ulong
  static unsigned long hostIpAddr (void);
  // set all useful tags
  static          void setTags    (void);
  // get current time for unix
  static          double currentTime (void);

  // check whether a process is dead or not
  static          int    isProcessDead (long pid);


#ifndef __vxworks

#ifdef _CMLOG_BUILD_SERVER
  // printf for server message
  static int      serverPrintf (const char *format, ...);
  
  // parse configuration file
  static int      parseConfigFile (char* filename);

  // check a particular socket valid or not
  // return 1: ok, return -1: bad
  static int      checkSocket     (int fd);

  // do a simple insertion sort: 
  // reason: most of time the file names are sorted already.
  // insertion sort will be optimal in this case O (n)
  // on memory sorting
  static          void isort (int* a, int len);

  // get database file names from start/end time
  // return 0: success, -1: failed
  // caller free filenames and filesnames[] if numfiles != 0
  static          int dbaseFilenames (double start, double end,
				      char** &filenames, int& numfiles);
  static          int dbaseCxtFilenames (double start, double end,
					 char** &filenames, int& numfiles);

  // free memory from the above two routines
  static         void freeFileNames (char** filename, char** cxtfnames,
				     int    numfiles);
  // send opend file descriptor from one process to another
  static          int sendfile       (int sendfd, int openedfd);
  // receive an opened file descriptor from a pipe
  static          int recvfile       (int recvfd, int* opendfd);

#endif  // _CMLOG_BUILD_SERVER

#endif

public:
  static int      tagInserted;
  
  static int      CMLOG_KEY_TAG, CMLOG_STR_TAG, CMLOG_CLNTCXT_TAG;
  static int      CMLOG_HOST_TAG,CMLOG_PID_TAG, CMLOG_NAME_TAG;
  static int      CMLOG_CLASS_TAG, CMLOG_DOMAIN_TAG, CMLOG_FACILITY_TAG;
  static int      CMLOG_CODE_TAG, CMLOG_VERBOSITY_TAG, CMLOG_SEVERITY_TAG;
  static int      CMLOG_TEXT_TAG, CMLOG_STATUS_TAG, CMLOG_INCOMPLETE_TAG;
  static int      CMLOG_USER_TAG, CMLOG_CLNTID_TAG, CMLOG_DISP_TAG;
  static int      CMLOG_DROPPED_TAG, CMLOG_START_TAG, CMLOG_END_TAG;
  static int      CMLOG_RESULT_TAG, CMLOG_VALUE_TAG, CMLOG_PROC_TAG;
  static int      CMLOG_NUMITEMS_TAG, CMLOG_QUERYMSG_TAG, CMLOG_LINE_TAG;

#ifdef _CMLOG_BUILD_SERVER
  // configuration information
  static int      MAXCLNT_CONS, MAXBRSER_CONS;
  static char     *DEFAULT_DIRECTORY, *LOG_FILE;
  static char     *DATABASE_NAME, *CXTDBASE_NAME;
  static char     *SECONDARY_DBASE, *SECONDARY_CXTDBASE;
  static char     *TAGTABLE_NAME;
  static int      PORT;
  static int      DBASE_CHANGE_INTERVAL;
  static int      DBASE_PAGESIZE;
#endif
};

#ifdef _CMLOG_BUILD_SERVER
class cmlogDirHandle
{
public:
  // constructor
  cmlogDirHandle  (void);
  // destructor
  ~cmlogDirHandle (void);

  // parse a input
  // return 0 success, -1 failure
  int  parseDir   (char* dirname);

  // return directory name
  const char* directory (void) const;
  // return file name prefix
  const char* prefix    (void) const;
  // return file name prefix without full path
  const char* sprefix   (void) const;

  // return number of directories by parsing input path
  static int directories (char* dirpaths, char**& dirs, int* numdirs);

private:
  char* dir_;
  char* prefix_;
  char* sprefix_;
};

class cmlogFileHandle
{
public:
  // constructor
  cmlogFileHandle  (void);
  cmlogFileHandle  (const cmlogFileHandle& handle);

  cmlogFileHandle& operator = (const cmlogFileHandle& handle);

  // destrcuctor
  ~cmlogFileHandle (void);

  // return time stamp in long integer of this file
  // this time stamp is starting time for this file
  const int timeStamp (void) const;

  // return 0: equal, -1: <, 1 >
  int compare      (const cmlogFileHandle& handle) const;

  // return full path name of this file
  // caller has to free returned char string
  char* filename (void) const;

  // operators
  friend int operator > (const cmlogFileHandle& h1, const cmlogFileHandle& h2);
  friend int operator >=(const cmlogFileHandle& h1, const cmlogFileHandle& h2);
  friend int operator < (const cmlogFileHandle& h1, const cmlogFileHandle& h2);
  friend int operator <=(const cmlogFileHandle& h1, const cmlogFileHandle& h2);
  friend int operator ==(const cmlogFileHandle& h1, const cmlogFileHandle& h2);
  friend int operator !=(const cmlogFileHandle& h1, const cmlogFileHandle& h2);
  
  static cmlogFileHandle* createFileHandle (char* filename, 
					    cmlogDirHandle* dh);

  static void isort (cmlogFileHandle* fhs, int len);

protected:

  cmlogFileHandle  (int ts, cmlogDirHandle* dh);


private:
  // time stamp
  int timeStamp_;
  // directory handle
  cmlogDirHandle* dh_;
};
#endif

#endif
