#include <cmlog_cdevMessage.h>
#include <cmlog_cdevPacket1.h>

#ifdef __vxworks
static char* strdup (char* s)
{
  char* p = new char[::strlen (s) + 1];
  ::strcpy (p, s);
  return p;
}
#endif

// *****************************************************************************
// * cmlog_cdevMessage::cmlog_cdevMessage :
// *	This is a parameterized constructor for the cmlog_cdevMessage object.  If none
// *	of the parameters are specified then this constructor will build a 
// *	cmlog_cdevMessage object made completely from defaults.
// *****************************************************************************
cmlog_cdevMessage::cmlog_cdevMessage ( short      ClientID, 
			   unsigned   TransIndex,
	                   unsigned   CancelTransIndex,
			   unsigned   LocalDataIndex,
			   unsigned   ForeignDataIndex,
			   unsigned   OperationCode,
	                   unsigned   DeviceCount,
			   char **    DeviceList,
			   char *     Message,
			   cdevData * Data,
			   cdevData * Context,
			   cdevData * TagMap)
	: clientID         (ClientID),
	  transIndex       (TransIndex),
	  cancelTransIndex (CancelTransIndex),
	  localDataIndex   (LocalDataIndex),
	  foreignDataIndex (ForeignDataIndex),
	  operationCode    (OperationCode),
	  deviceCount      (DeviceCount),
	  deviceList       (NULL),
	  message          (NULL),
	  data             (NULL),
	  context          (NULL),
	  tagMap           (NULL),
	  arg              (NULL)
	{
	saveTbl.rawData=0;

	if(DeviceCount>0 && DeviceList!=NULL)
		{
		deviceList = (char **)new char * [deviceCount];
		for(int i=0; i<deviceCount; i++)
			{
			deviceList[i] = strdup(DeviceList[i]);
			}
		}
	if(Message!=NULL) {
	  message = new char[strlen (Message) + 1];
	  strcpy (message, Message);
	}
	if(Data!=NULL)    data    = new cdevData(*Data);
	if(Context!=NULL) context = new cdevData(*Context);
	if(TagMap!=NULL)  tagMap  = new cdevData(*TagMap);
	}
	

// *****************************************************************************
// * cmlog_cdevMessage::cmlog_cdevMessage : 
// * 	This is the constructor for the object.  It serves to initialize the 
// *	internals of the object with default values or the user specified 
// *	binary data if provided.
// *****************************************************************************
cmlog_cdevMessage::cmlog_cdevMessage ( char * binary, unsigned binaryLen )
	: deviceCount(0), deviceList(NULL), message(NULL),
	  data(NULL), context(NULL), tagMap(NULL), arg (NULL)
	{
	saveTbl.rawData = 0;
	streamIn(binary, binaryLen);
	}


// *****************************************************************************
// * cmlog_cdevMessage::cmlog_cdevMessage :
// *	This is the copy constructor for the object.  It creates a new 
// *	cmlog_cdevMessage object that contains all of the data specified in the
// *	user provided object.
// *****************************************************************************
cmlog_cdevMessage::cmlog_cdevMessage ( cmlog_cdevMessage & Message )
	: clientID         (Message.clientID),
	  transIndex       (Message.transIndex),
	  cancelTransIndex (Message.cancelTransIndex),
	  localDataIndex   (Message.localDataIndex),
	  foreignDataIndex (Message.foreignDataIndex),
	  operationCode    (Message.operationCode),
	  deviceCount      (Message.deviceCount),
	  deviceList       (NULL),
	  message          (NULL),
	  data             (NULL),
	  context          (NULL),
	  tagMap           (NULL),
	  arg              (NULL)
	{
	  saveTbl.rawData = Message.saveTbl.rawData;

	  if(Message.deviceCount>0 && Message.deviceList!=NULL) {
	    if (!saveTbl.value.saveDeviceList) {
	      deviceList = (char **)new char * [deviceCount];
	      for(int i=0; i<deviceCount; i++) 
		deviceList[i] = strdup(Message.deviceList[i]);
	    }
	    else
	      deviceList = Message.deviceList;
	  }
	  
	  if(Message.message!=NULL) {
	    if (!saveTbl.value.saveMessage) {
	      message = new char[strlen(Message.message) + 1];
	      strcpy (message, Message.message);
	    }
	    else
	      message = Message.message;
	  }

	  if(Message.data!=NULL) {
	    if (!saveTbl.value.saveData)
	      data    = new cdevData(*Message.data);
	    else
	      data    = Message.data;
	  }
	

	  if(Message.context!=NULL) {
	    if (!saveTbl.value.saveContext)
	      context = new cdevData(*Message.context);
	    else
	      context = Message.context;
	  }

	  if(Message.tagMap!=NULL) {
	    if (!saveTbl.value.saveTagMap)
	      tagMap  = new cdevData(*Message.tagMap);
	    else
	      tagMap  = Message.tagMap;
	  }
	}
	

// *****************************************************************************
// * cmlog_cdevMessage::~cmlog_cdevMessage :
// *	This is the destructor for the class.  It releases any previously 
// *	allocated memory prior to the destruction of the object.
// *****************************************************************************
cmlog_cdevMessage::~cmlog_cdevMessage ( void )
	{
	clear();
	}
	

// *****************************************************************************
// * cmlog_cdevMessage::clear :
// *	This is the clear mechanism for the object.  It is used to deallocate
// *	any memory that has been allocated and set all data items to their
// *	initial default values.
// *****************************************************************************
void cmlog_cdevMessage::clear ( void )
	{
	setClientID(-1);
	setTransIndex(0);
	setCancelTransIndex(0);
	setLocalDataIndex(0);
	setForeignDataIndex(0);
	setOperationCode(0);
	setDeviceCount(0);
	setDeviceList(NULL, 0);
	setMessage(NULL);
	setData(NULL);
	setContext(NULL);
	setTagMap(NULL);
	setArg (NULL);
	}
	

// *****************************************************************************
// * cmlog_cdevMessage::streamIn :
// *	This mechanism is used to use a binary packet to populate the 
// *	cmlog_cdevMessage object.
// *
// *	The binary stream remains the property of the caller and must be
// *	delete by him.
// *****************************************************************************
int cmlog_cdevMessage::streamIn( char * binary, unsigned binaryLen )
	{
	int         result = 0;
	cmlog_cdevPacket1 packet;
	
	clear();
	if (packet.attachData(binary, binaryLen) == -1)
	  return -1;
	if(packet.hasClientID())         result+=packet.getClientID(clientID);
	if(packet.hasTransIndex())       result+=packet.getTransIndex(transIndex);
	if(packet.hasCancelTransIndex()) result+=packet.getCancelTransIndex(cancelTransIndex);
	if(packet.hasLocalDataIndex())   result+=packet.getLocalDataIndex(localDataIndex);
 	if(packet.hasForeignDataIndex()) result+=packet.getForeignDataIndex(foreignDataIndex);
	if(packet.hasOperationCode())    result+=packet.getOperationCode(operationCode);
	if(packet.hasDeviceList())       result+=packet.getDeviceList(deviceList, deviceCount);	
	if(packet.hasMessage())          result+=packet.getMessage(message);	
	if(packet.hasData())
		{
		data = new cdevData;
		result+=packet.getData(*data);
		}
	if(packet.hasContext())
		{
		context = new cdevData;
		result+=packet.getContext(*context);
		}
	if(packet.hasTagMap())
		{
		tagMap = new cdevData;
		result+=packet.getTagMap(*tagMap);
		} 
	packet.detachData();
	return result;
	}
	

// *****************************************************************************
// * cmlog_cdevMessage::streamOut :
// *	This mechanism is used to generate a binary representation of the 
// *	cmlog_cdevMessage object.
// *
// *	The binary stream becomes the property of the caller and he must delete 
// *	it when it is no longer needed.
// *****************************************************************************
int cmlog_cdevMessage::streamOut( char ** binary, unsigned * binaryLen )
	{
	cmlog_cdevPacket1 packet;

	packet.set(clientID, transIndex, cancelTransIndex,
		   localDataIndex, foreignDataIndex, operationCode,
		   deviceCount, deviceList,
		   message, data, context, tagMap);
	packet.streamOut (binary, binaryLen);
	packet.detachData();

	return 0;
	}

// *****************************************************************************
// * cmlog_cdevMessage::streamOut :
// *	This mechanism is used to generate a binary representation of the 
// *	cmlog_cdevMessage object into a given buffer
// *
// *    return actual buffer size on success, 0 failure (overflow)
// *****************************************************************************
int cmlog_cdevMessage::streamOut( char binary[], unsigned size )
	{
	cmlog_cdevPacket1 packet;
	int         st;
	unsigned int bufsize;
	char        *tbuf;

	st = packet.set(binary, size, clientID, transIndex, cancelTransIndex,
			localDataIndex, foreignDataIndex, operationCode,
			deviceCount, deviceList,
			message, data, context, tagMap);
	if (st == 0) 
	  packet.streamOut (&tbuf, &bufsize);
	else
	  bufsize = 0;

	packet.detachData();

	return (int)bufsize;
	}


// *****************************************************************************
// * cmlog_cdevMessage::binarySize
// *	This mechanism is used to check size of a binary representation of the 
// *	cmlog_cdevMessage object.
// *
// *****************************************************************************
unsigned cmlog_cdevMessage::binarySize (void)
{
  return cmlog_cdevPacket1::checkLength (clientID, transIndex, cancelTransIndex,
				   localDataIndex, foreignDataIndex, operationCode,
				   deviceCount, deviceList,
				   message, data, context, tagMap);
}
	
	
// *****************************************************************************
// * cmlog_cdevMessage::asciiDump :
// *	This mechanism is included to provide the ability to generate a 
// *	diagnostic dump of the cmlog_cdevMessage object.
// *****************************************************************************
void cmlog_cdevMessage::asciiDump ( FILE * fp )
	{
	fprintf(fp, "----------------------------------------------------------\n");
	fprintf(fp, "             Diagnostic Dump of CDEV Message\n");
	fprintf(fp, "----------------------------------------------------------\n\n");
	fprintf(fp, "Client Identifier  : %s\n", clientID==-1?"(not specified)":ltoa(clientID));
	fprintf(fp, "Transaction Index  : %s\n", transIndex==0?"(not specified)":ultoa(transIndex));
	fprintf(fp, "Cancel Transaction : %s\n", cancelTransIndex==0?"(not specified)":ultoa(cancelTransIndex));
	fprintf(fp, "Local Data Index   : %s\n", localDataIndex==0?"(not specified)":ultoa(localDataIndex));
	fprintf(fp, "Foreign Data Index : %s\n", foreignDataIndex==0?"(not specified)":ultoa(foreignDataIndex));
	fprintf(fp, "Operation Code     : %s\n", operationCode==0?"(not specified)":ultoa(operationCode));
	
	fprintf(fp, "Save Table         :\n");
	fprintf(fp, "                     Device List %s Permanent\n", saveTbl.value.saveDeviceList?"IS":"IS NOT");
	fprintf(fp, "                     Message %s Permanent\n", saveTbl.value.saveMessage?"IS":"IS NOT");
	fprintf(fp, "                     Data %s Permanent\n", saveTbl.value.saveData?"IS":"IS NOT");
	fprintf(fp, "                     Context %s Permanent\n", saveTbl.value.saveContext?"IS":"IS NOT");
	fprintf(fp, "                     Tag Map %s Permanent\n", saveTbl.value.saveTagMap?"IS":"IS NOT");		

	fprintf(fp, "Number of Devices  : %s\n", deviceCount==0?"(not specified)":ultoa(deviceCount));
	fprintf(fp, "List of Devices    : ");
	
	if(deviceCount==0) fprintf(fp, "(not specified)\n");
	else fprintf(fp, "%s\n", deviceList[0]);
	
	for(int i=1; i<deviceCount; i++) 
		{
		fprintf(fp, "                     %s\n", deviceList[i]);
		}

	fprintf(fp, "Message String     : %s\n", message==NULL?"(not specified)":message);
	
	fprintf(fp, "Data Object        : %s", data!=NULL?"\n":"(not specified)\n");
	if(data) data->asciiDump(fp);

	fprintf(fp, "Context Object     : %s", context!=NULL?"\n":"(not specified)\n");
	if(context) context->asciiDump(fp);

	fprintf(fp, "Tag Map            : %s", tagMap!=NULL?"\n":"(not specified)\n");
	if(tagMap)
		{
		unsigned  tagNumCnt  = 0;
		int  *  tagNums    = NULL;
		unsigned  tagNameCnt = 0;
		char ** tagNames   = NULL;

		if(tagMap->getElems(1, &tagNumCnt)==CDEV_SUCCESS  && 
		   tagMap->getElems(2, &tagNameCnt)==CDEV_SUCCESS &&
		   tagMap->getType (2)==CDEV_STRING               &&
		   tagNumCnt==tagNameCnt)
			{
			char ** tagNames   = NULL;
			char *  singleName = NULL;

			tagNums = new int[tagNumCnt];
			tagMap->get(1, tagNums);
			
			if(tagNameCnt==1)
				{
				tagNames = &singleName;
				tagMap->find(2, (void *&)singleName);
				}
			else tagMap->find(2, (void *&)tagNames);

			for(int i=0; i<tagNumCnt; i++)
				{
				fprintf(fp, "\t%-26.26s= %i\n", tagNames[i], tagNums[i]);
				} 
			delete tagNums;
			}
		}

	fprintf(fp, "----------------------------------------------------------\n");
	fprintf(fp, "            End of Diagnostic Dump of CDEV Message\n");
	fprintf(fp, "----------------------------------------------------------\n\n");
	fflush(fp);
	}
