//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdev global tag table
//
// Author:  Jie Chen
//
// Revision History:
//   $Log: cdevGlobalTagTable.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:14  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:33:58  bickley
// Added cmlog to application development system.
//
// Revision 1.1  1995/10/03  19:54:40  chen
// single instance of cdevTagTable
//
//
#ifndef _CDEV_GBL_TAG_TABLE_H
#define _CDEV_GBL_TAG_TABLE_H

// Use singleton design pattern to ensure that there is only
// one tag table in the system without using global variable 
// which is not desirable in C++

#include <cdevTagTable.h>

class cdevGlobalTagTable
{
public:
  static cdevTagTable* tagTable (void);

protected:
  // constructor
  cdevGlobalTagTable (void);
  virtual ~cdevGlobalTagTable (void);

private:
  static cdevTagTable* instance_;
};
#endif
