//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Update Toggle Button of Options Menu
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiUpdate.h,v $
//   Revision 1.2  2000/06/20 19:36:45  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:27  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_UPDATE_H
#define _CMLOG_XUI_UPDATE_H

#include <stdio.h>
#include <string.h>
#include <cmlogXuiMenuTog.h>

class cmlogXuiUpdateDialog;

class cmlogXuiUpdate: public cmlogXuiMenuTog
{
public:
  // constructor and destructor
  cmlogXuiUpdate  (const char* name, int active,
		   const char* acc, const char* acc_text, int state,
		   cmlogXuiMenuWin* win,
		   cmlogXuiBrowser& browser);
  ~cmlogXuiUpdate (void);

  // operations
  void startUpdating (char* selection);
  void stopUpdating  (void);

  // class name
  const char* className (void) const {return "cmlogXuiUpdate";}

protected:
  // inherited operations
  void doit   (void);
  void undoit (void);

  // dialog box
  cmlogXuiUpdateDialog* dialog_;
};
#endif
