//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogXuiUbufDialog class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiUbufDialog.cc,v $
//   Revision 1.2  2000/06/20 19:36:45  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:20  bickley
// Added cmlog to application development system.
//
//
//
#include <ctype.h>
#include <Xm/PushBG.h>
#include <Xm/LabelG.h>
#include <Xm/ToggleBG.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/TextF.h>
#include <cmlogXuiUbuf.h>
#include "cmlogXuiUbufDialog.h"

cmlogXuiUbufDialog::cmlogXuiUbufDialog (cmlogXuiUbuf* comm,
					const char* name, 
					const char* title,
					cmlogXuiBrowser& browser)
:XcodaFormDialog (comm->dialogBaseWidget (), name, title),
 ok_ (0), cancel_ (0), ubuf_ (comm), browser_ (browser)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Create cmlogXuiUbufDialog Class Object\n");
#endif
  // empty
}

cmlogXuiUbufDialog::~cmlogXuiUbufDialog (void)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Delete cmlogXuiUbufDialog Class Object\n");
#endif
  // empty: from_ to_ will be destroyed by XtDestroyCallback
}

void
cmlogXuiUbufDialog::createFormChildren (void)
{
  Arg arg[20];
  int ac = 0;
  XmString t;
  char temp[128];

  // create top title
  sprintf (temp, "How many messages do you want to keep \n");
  strcat  (temp, "during entire process of monitoring incoming messages ?");

  t = XmStringCreateLtoR (temp, XmSTRING_DEFAULT_CHARSET);
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  Widget title = XtCreateManagedWidget ("ubuf_title",
					xmLabelGadgetClass, _w,
					arg, ac);
  ac = 0;
  XmStringFree (t);


  // create action form
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;  
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  Widget act_form = XtCreateWidget ("ubuf_act_form",
				    xmFormWidgetClass,
				    _w, arg, ac);
  ac = 0;

  t = XmStringCreateSimple ((char *)("  Ok  "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNleftPosition, 5); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  ok_ = XtCreateManagedWidget ("ubuf_ok", xmPushButtonGadgetClass,
			       act_form, arg, ac);
  ac = 0;
  XmStringFree (t);

  t = XmStringCreateSimple ((char *)("Cancel"));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNrightPosition, 95); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  cancel_ = XtCreateManagedWidget ("ubuf_cancel", xmPushButtonGadgetClass,
				   act_form, arg, ac);
  ac = 0;
  XmStringFree (t);


  // create a frame widget that hold size of the buffer
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, title); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;  
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNbottomWidget, act_form); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  XtSetArg (arg[ac], XmNshadowType, XmSHADOW_ETCHED_IN); ac++;
  Widget size_frame = XtCreateWidget ("ubuf_from_frame",
				      xmFrameWidgetClass, _w,
				      arg, ac);
  ac = 0;
  

  // create from time selector and title
  t = XmStringCreateSimple ((char *)("Updating Window Size"));
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNchildType, XmFRAME_TITLE_CHILD); ac++;
  Widget size_label = XtCreateManagedWidget ("ubuf_from_label",
					     xmLabelGadgetClass, size_frame,
					     arg, ac);
  ac = 0;
  XmStringFree (t);

  // create a form widget inside the frame
  Widget size_form = XtCreateWidget ("ubuf_size_form",
				     xmFormWidgetClass, size_frame,
				     arg, ac);
  ac = 0;

  // create toggle widget inside the form
  t = XmStringCreateSimple ((char *)("Keep all messages"));
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNindicatorType, XmN_OF_MANY); ac++;
  XtSetArg (arg[ac], XmNvisibleWhenOff, True); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNrightPosition, 45); ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5) ;ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  toggle_ = XtCreateManagedWidget ("cmlog_ubuf_toggle",
				   xmToggleButtonGadgetClass,
				   size_form, arg, ac);
  ac = 0;
  XmStringFree (t);


  // create text widget
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNleftPosition, 55); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5) ;ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  size_ = XtCreateManagedWidget ("cmlog_ubuf_size", 
				 xmTextFieldWidgetClass,
				 size_form, arg, ac);
  ac = 0;


  // manage all
  XtManageChild (size_frame);
  XtManageChild (size_form);
  XtManageChild (act_form);

  // add all callbacks
  XtAddCallback (ok_, XmNactivateCallback, 
		 (XtCallbackProc)&(cmlogXuiUbufDialog::okCallback),
		 (XtPointer)this);

  XtAddCallback (cancel_, XmNactivateCallback, 
		 (XtCallbackProc)&(cmlogXuiUbufDialog::cancelCallback),
		 (XtPointer)this);
}

void
cmlogXuiUbufDialog::ok (void)
{
  char*  tstr = 0;
  int    keepall;
  int    bufsize;
  char   temp[32];

  keepall = XmToggleButtonGadgetGetState (toggle_);

  if (keepall) {
    ubuf_->changeUbufsize (0);
    popdown ();
  }
  else {
    // get buffer size
    tstr = XmTextFieldGetString (size_);

    if (tstr && *tstr) {
      if (sscanf (tstr, "%d", &bufsize) < 1) {
	XtFree (tstr);
	// reset value to the old value
	sprintf (temp, "%d", ubuf_->ubufSize ());
	XmTextFieldSetString (size_, temp);
	XBell (XtDisplay (_w), 0);
	return;
      }
      ubuf_->changeUbufsize (bufsize);
      popdown ();
    }
    else {
      sprintf (temp, "%d", ubuf_->ubufSize ());
      XmTextFieldSetString (size_, temp);
      XBell (XtDisplay (_w), 0);
      return;	
    }
  }
}


void
cmlogXuiUbufDialog::okCallback (Widget w, XtPointer data,
				 XmAnyCallbackStruct* cbs)
{
  cmlogXuiUbufDialog* obj = (cmlogXuiUbufDialog *)data;

  obj->ok ();
}

void
cmlogXuiUbufDialog::cancelCallback (Widget w, XtPointer data,
				     XmAnyCallbackStruct* cbs)
{
  cmlogXuiUbufDialog* obj = (cmlogXuiUbufDialog *)data;

  obj->popdown ();
}

void
cmlogXuiUbufDialog::popup (void)
{
  int bufsize = 0;
  char temp[32];

  bufsize = ubuf_->ubufSize () ;
  if (bufsize == 0) {
    XmToggleButtonGadgetSetState (toggle_, 1, 0);
    XmTextFieldSetString (size_, (char *)(""));
  }
  else {
    sprintf (temp, "%d", bufsize);
    XmToggleButtonGadgetSetState (toggle_, 0, 0);
    XmTextFieldSetString (size_, temp);
  }
  XcodaFormDialog::popup ();
}

