//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Xui Browser Title Bar
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiTitleBar.h,v $
//   Revision 1.2  2000/06/20 19:36:44  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:13  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_TITLE_BAR_H
#define _CMLOG_XUI_TITLE_BAR_H

#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <MultiList.h>
#include <XcodaUi.h>
#include <cmlogXuiBrowser.h>
#include <cdevData.h>

#ifndef _CMLOG_XUI_MAX_COLUMNS
#define _CMLOG_XUI_MAX_COLUMNS 64
#endif


class cmlogXuiDisp;

class cmlogXuiTitleBar: public XcodaUi
{
public:
  // constructor and destructor
  cmlogXuiTitleBar     (Widget parent,   const char* name, 
			int num_columns, Dimension* columns_widths,
			char** tags, char** titles,
			cmlogXuiBrowser& browser);
  ~cmlogXuiTitleBar    (void);

  // create widget and realize the widget
  void   init      (void);

  // configure this list
  // number of columns, column widths and tags for each column
  void   configure (int num_columns, Dimension* columns_widths,
		    char** tags, char** titles);

  void   configure (int num_columns, Dimension* columns_widths);

  // return titles
  char** titles (void);


  // set up pointer of display window
  void   displayWindow (cmlogXuiDisp* disp);

  virtual const char* className (void) const {return "cmlogXuiTitleBar";}

protected:
  // callback for separator moving mechanism
  static void sepMoveCallback (Widget w, XtPointer data,
			       MultiListSepMoveStruct* val);

private:
  // parent widget
  Widget parent_;
  // Real base widget is a scrolled window

  int          num_cols_;
  Dimension    col_widths_[_CMLOG_XUI_MAX_COLUMNS];
  char*        tags_ [_CMLOG_XUI_MAX_COLUMNS];
  char*        titles_[_CMLOG_XUI_MAX_COLUMNS];

  // network handler
  cmlogXuiBrowser& browser_;

  // display window pointer
  cmlogXuiDisp* disp_;
};
#endif
