//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG XUI start/end time display window
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiTimeWin.h,v $
//   Revision 1.2  2000/06/20 19:36:44  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:32:10  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_TIME_WIN_H
#define _CMLOG_XUI_TIME_WIN_H

#include <stdio.h>
#include <string.h>
#include <XcodaUi.h>
#include <cmlogXuiBrowser.h>

class cmlogXuiMenuWin;

class cmlogXuiTimeWin: public XcodaUi
{
public:
  // constructor and destructor
  cmlogXuiTimeWin  (Widget parent, const char* name,
		    cmlogXuiMenuWin* win,
		    cmlogXuiBrowser& browser);
  ~cmlogXuiTimeWin (void);

  // create all widgets
  void        init (void);

  // operations
  void setStartTime (time_t t);  // passing -1 will erase
  void setEndTime   (time_t t);  // passing -1 will erase

  const char* className (void) const {return "cmlogXuiTime";}

private:
  // data area
  Widget parent_;
  Widget start_, end_;
  
  // Menu window pointer
  cmlogXuiMenuWin* window_;

  // network handler
  cmlogXuiBrowser& browser_;
};
#endif
