//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of Save Dialog Box
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiSaveDialog.cc,v $
//   Revision 1.2  2000/06/20 19:36:43  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:14  chen
//   CMLOG version 2.0
//
//
//
#include <cmlogXuiSave.h>
#include "cmlogXuiSaveDialog.h"
#include "cmlogXuiSaveFileDialog.h"
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>
#include <Xm/LabelG.h>
#include <Xm/TextF.h>
#include <Xm/ArrowBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>

cmlogXuiSaveDialog::cmlogXuiSaveDialog (cmlogXuiSave* save,
					const char* name, 
					const char* title,
					cmlogXuiBrowser& browser)
  :XcodaFormDialog (save->dialogBaseWidget(), name, title), save_ (save),
   browser_ (browser), fdialog_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Create cmlogXuiSaveDialog Class Object\n");
#endif
  // empty
}

cmlogXuiSaveDialog::~cmlogXuiSaveDialog (void)
{
#ifdef _TRACE_OBJECTS
  printf ("                   Delete cmlogXuiSaveDialog Class Object\n");
#endif   
  // no need to delete fdialog_ which is deleted by Xt machanism
}

void
cmlogXuiSaveDialog::createFormChildren (void)
{
  Arg arg[30];
  int ac = 0;
  XmString t;

  t = XmStringCreateSimple ((char *)("Save cmlog screen(s) to a file"));
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  Widget title = XtCreateManagedWidget ("save_title",
                                        xmLabelGadgetClass, _w,
                                        arg, ac);
  ac = 0;
  XmStringFree (t);

  // create a separator widget
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;  
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, title); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 2); ac++;
  Widget tsep = XtCreateManagedWidget ("top_sep", xmSeparatorGadgetClass,
				       _w, arg, ac);
  ac = 0;

  // create action form
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;  
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  Widget act_form = XtCreateWidget ("save_act_form",
                                    xmFormWidgetClass,
                                    _w, arg, ac);
  ac = 0;

  t = XmStringCreateSimple ((char*)("  Ok  "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNleftPosition, 5); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  ok_ = XtCreateManagedWidget ("save_ok", xmPushButtonGadgetClass,
                               act_form, arg, ac);
  ac = 0;
  XmStringFree (t);
  
  t = XmStringCreateSimple ((char *)("Cancel"));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNrightPosition, 95); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  cancel_ = XtCreateManagedWidget ("save_cancel", xmPushButtonGadgetClass,
                                   act_form, arg, ac);
  ac = 0;
  XmStringFree (t);

  // create a separator widget
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;  
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNbottomWidget, act_form); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 2); ac++;
  Widget bsep = XtCreateManagedWidget ("bottom_sep", xmSeparatorGadgetClass,
				       _w, arg, ac);
  ac = 0;

  // create a row column widget that holds three form widget
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;  
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNbottomWidget, bsep); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 2); ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, tsep); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 2); ac++;
  XtSetArg (arg[ac], XmNorientation, XmVERTICAL); ac++;
  XtSetArg (arg[ac], XmNnumColumns, 4); ac++;
  Widget form_row = XtCreateWidget ("save_form_row", xmRowColumnWidgetClass,
				    _w, arg, ac);
  ac = 0;

  // create the first row
  Widget row1 = XtCreateWidget ("save-row-1", xmFormWidgetClass,
				form_row, 0, 0);

  t = XmStringCreateSimple ((char *)("Save From: "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNalignment, XmALIGNMENT_END); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  Widget savefromtolabel = XtCreateManagedWidget ("savefromto", 
						  xmLabelGadgetClass,
						  row1, arg, ac);
  ac = 0;
  XmStringFree (t);

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, savefromtolabel); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 2); ac++;
  XtSetArg (arg[ac], XmNcolumns, 10); ac++;
  from_ = XtCreateManagedWidget ("savefromline", xmTextFieldWidgetClass,
				 row1, arg, ac);
  ac = 0;
  
  // create two arrow buttons for from line number
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;  
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;  
  XtSetArg (arg[ac], XmNleftWidget, from_); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 2); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNbottomPosition, 49); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_UP); ac++;
  Widget fromarrup = XtCreateManagedWidget ("savefromarrup", 
					    xmArrowButtonGadgetClass, row1,
					    arg, ac);
  ac = 0;

  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;  
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;  
  XtSetArg (arg[ac], XmNleftWidget, from_); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 2); ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNtopPosition, 51); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_DOWN); ac++;
  Widget fromarrdown = XtCreateManagedWidget ("savefromarrdown", 
					      xmArrowButtonGadgetClass, row1,
					      arg, ac);
  ac = 0;  

  // create two arrow buttons for to line number
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;  
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;  
  XtSetArg (arg[ac], XmNrightOffset, 2); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNbottomPosition, 49); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_UP); ac++;
  Widget toarrup = XtCreateManagedWidget ("savetoarrup", 
					  xmArrowButtonGadgetClass, row1,
					  arg, ac);
  ac = 0;

  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;  
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;  
  XtSetArg (arg[ac], XmNrightOffset, 2); ac++;
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_POSITION); ac++;
  XtSetArg (arg[ac], XmNtopPosition, 51); ac++;
  XtSetArg (arg[ac], XmNarrowDirection, XmARROW_DOWN); ac++;
  Widget toarrdown = XtCreateManagedWidget ("savetoarrdown", 
					    xmArrowButtonGadgetClass, row1,
					    arg, ac);
  ac = 0;    

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNrightWidget, toarrdown); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 2); ac++;
  XtSetArg (arg[ac], XmNcolumns, 10); ac++;
  to_ = XtCreateManagedWidget ("savetoline", xmTextFieldWidgetClass,
			       row1, arg, ac);
  ac = 0;  

  t = XmStringCreateSimple ((char *)("to: "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNrightWidget, to_); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 2); ac++;
  XtSetArg (arg[ac], XmNalignment, XmALIGNMENT_END); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  Widget tolabel = XtCreateManagedWidget ("saveto", 
					  xmLabelGadgetClass,
					  row1, arg, ac);
  ac = 0;
  XmStringFree (t);

  // second row
  Widget row2 = XtCreateWidget ("save-row-2", xmFormWidgetClass,
				form_row, 0, 0);

  t = XmStringCreateSimple ((char *)("Current Line Number: "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNalignment, XmALIGNMENT_END); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  Widget currlinelabel = XtCreateManagedWidget ("currlinelable", 
						xmLabelGadgetClass,
						row2, arg, ac);  
  ac = 0;
  XmStringFree (t);

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, currlinelabel); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 2); ac++;
  XtSetArg (arg[ac], XmNeditable, False); ac++;
  XtSetArg (arg[ac], XmNcolumns, 10); ac++;
  currline_ = XtCreateManagedWidget ("currline", xmTextFieldWidgetClass,
				     row2, arg, ac);
  ac = 0;

  // create 3rd row
  Widget row3 = XtCreateWidget ("save-row-2", xmFormWidgetClass,
				form_row, 0, 0);

  t = XmStringCreateSimple ((char *)("File: "));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNalignment, XmALIGNMENT_END); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  Widget filelabel = XtCreateManagedWidget ("filelable", 
					    xmLabelGadgetClass,
					    row3, arg, ac);  
  ac = 0;
  XmStringFree (t);

  t = XmStringCreateSimple ((char *)("Browse..."));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  filebutton_ = XtCreateManagedWidget ("filebutton", 
				       xmPushButtonGadgetClass,
				       row3, arg, ac);
  ac = 0;
  XmStringFree (t);

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNleftWidget, filelabel); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 2); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNrightWidget, filebutton_); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
  XtSetArg (arg[ac], XmNcolumns, 40); ac++;
  file_ = XtCreateManagedWidget ("currline", xmTextFieldWidgetClass,
				 row3, arg, ac);
  ac = 0;  

  // create 4th row
  Widget row4 = XtCreateWidget ("save-row-4", xmFormWidgetClass,
				form_row, 0, 0);
  
  t = XmStringCreateSimple ((char *)("Save Current Page"));
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 5); ac++;
  XtSetArg (arg[ac], XmNlabelString, t); ac++;
  pagetog_ = XtCreateManagedWidget ("pagetoggle",
				    xmToggleButtonGadgetClass, row4,
				    arg, ac);
  ac = 0;
  XmStringFree (t);


  // Manage all  widgets
  XtManageChild (row4);  
  XtManageChild (row3);
  XtManageChild (row2);
  XtManageChild (row1);
  XtManageChild (form_row);  
  XtManageChild (act_form);

  XtAddCallback (filebutton_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiSaveDialog::fileButtonCallback), 
		 (XtPointer)this);

  XtAddCallback (fromarrup, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiSaveDialog::fromArrowUpCallback),
		 (XtPointer)this);
  XtAddCallback (fromarrdown, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiSaveDialog::fromArrowDownCallback),
		 (XtPointer)this);
  XtAddCallback (toarrup, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiSaveDialog::toArrowUpCallback),
		 (XtPointer)this);
  XtAddCallback (toarrdown, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiSaveDialog::toArrowDownCallback),
		 (XtPointer)this);


  XtAddCallback (ok_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiSaveDialog::okCallback),
		 (XtPointer)this);
  XtAddCallback (cancel_, XmNactivateCallback,
		 (XtCallbackProc)&(cmlogXuiSaveDialog::cancelCallback),
		 (XtPointer)this);

}

void
cmlogXuiSaveDialog::fileButtonCallback (Widget w, XtPointer data,
					XmAnyCallbackStruct *cbs)
{
  cmlogXuiSaveDialog* obj = (cmlogXuiSaveDialog *)data;

  if (!obj->fdialog_) {
    obj->fdialog_ = new cmlogXuiSaveFileDialog (obj, "savefiledialog",
						"Save File Dailog");
    obj->fdialog_->init();
  }
  obj->fdialog_->popup ();
}

void
cmlogXuiSaveDialog::fromArrowUpCallback (Widget w, XtPointer data,
					 XmAnyCallbackStruct* cbs)
{
  cmlogXuiSaveDialog* obj = (cmlogXuiSaveDialog *)data;
  
  Arg arg[10];
  int ac = 0;
  int oldnum;
  char* str;
  char  temp[80];
  
  str = XmTextFieldGetString (obj->from_);
  if (!str || !*str) {
    obj->save_->reportErrorMsg ("No input for line number");
    return;
  }

  if (sscanf (str, "%d", &oldnum) < 1) {
    obj->save_->reportErrorMsg ("Syntax error for line number");
    XtFree (str);
    return;
  }
  
  if (oldnum >= obj->save_->numMsgsInBuffer ()) {
    XtFree (str);
    return;
  }
  oldnum ++;
  
  sprintf (temp, "%d", oldnum);
  XtSetArg (arg[ac], XmNvalue, temp); ac++;
  XtSetValues (obj->from_, arg, ac);
  ac = 0;
}

void
cmlogXuiSaveDialog::fromArrowDownCallback (Widget w, XtPointer data,
					 XmAnyCallbackStruct* cbs)
{
  cmlogXuiSaveDialog* obj = (cmlogXuiSaveDialog *)data;
  
  Arg arg[10];
  int ac = 0;
  int oldnum;
  char* str;
  char  temp[80];
  
  str = XmTextFieldGetString (obj->from_);
  if (!str || !*str) {
    obj->save_->reportErrorMsg ("No input for line number");
    return;
  }

  if (sscanf (str, "%d", &oldnum) < 1) {
    obj->save_->reportErrorMsg ("Syntax error for line number");
    XtFree (str);
    return;
  }
  
  if (oldnum <= 1) {
    XtFree (str);
    return;
  }
  oldnum = oldnum - 1;
  
  sprintf (temp, "%d", oldnum);
  XtSetArg (arg[ac], XmNvalue, temp); ac++;
  XtSetValues (obj->from_, arg, ac);
  ac = 0;
}


void
cmlogXuiSaveDialog::toArrowUpCallback (Widget w, XtPointer data,
				       XmAnyCallbackStruct* cbs)
{
  cmlogXuiSaveDialog* obj = (cmlogXuiSaveDialog *)data;
  
  Arg arg[10];
  int ac = 0;
  int oldnum;
  char* str;
  char  temp[80];
  
  str = XmTextFieldGetString (obj->to_);
  if (!str || !*str) {
    obj->save_->reportErrorMsg ("No input for line number");
    return;
  }

  if (sscanf (str, "%d", &oldnum) < 1) {
    obj->save_->reportErrorMsg ("Syntax error for line number");
    XtFree (str);
    return;
  }
  
  if (oldnum >= obj->save_->numMsgsInBuffer ()) {
    XtFree (str);
    return;
  }
  oldnum ++;
  
  sprintf (temp, "%d", oldnum);
  XtSetArg (arg[ac], XmNvalue, temp); ac++;
  XtSetValues (obj->to_, arg, ac);
  ac = 0;
}

void
cmlogXuiSaveDialog::toArrowDownCallback (Widget w, XtPointer data,
					 XmAnyCallbackStruct* cbs)
{
  cmlogXuiSaveDialog* obj = (cmlogXuiSaveDialog *)data;
  
  Arg arg[10];
  int ac = 0;
  int oldnum;
  char* str;
  char  temp[80];
  
  str = XmTextFieldGetString (obj->to_);
  if (!str || !*str) {
    obj->save_->reportErrorMsg ("No input for line number");
    return;
  }

  if (sscanf (str, "%d", &oldnum) < 1) {
    obj->save_->reportErrorMsg ("Syntax error for line number");
    XtFree (str);
    return;
  }
  
  if (oldnum <= 1) {
    XtFree (str);
    return;
  }
  oldnum = oldnum - 1;
  
  sprintf (temp, "%d", oldnum);
  XtSetArg (arg[ac], XmNvalue, temp); ac++;
  XtSetValues (obj->to_, arg, ac);
  ac = 0;
}

  
void
cmlogXuiSaveDialog::setFileName (char* name)
{
  Arg arg[20];
  int ac = 0;

  XtSetArg (arg[ac], XmNvalue, name); ac++;
  XtSetValues (file_, arg, ac);
  ac = 0;
}

void
cmlogXuiSaveDialog::setPointedMsgNumber (int number)
{
  Arg arg[20];
  int ac = 0;
  char temp[80];

  sprintf (temp, "%d", number);
  XtSetArg (arg[ac], XmNvalue, temp); ac++;
  XtSetValues (currline_, arg, ac);
  ac = 0;
}

void
cmlogXuiSaveDialog::okCallback (Widget w, XtPointer data,
				XmAnyCallbackStruct* cbs)
{
  cmlogXuiSaveDialog* obj = (cmlogXuiSaveDialog *)data;
  char* filename = XmTextFieldGetString (obj->file_);
  char* from;
  char* to;
  int   fnum, tnum;
  char  msg[128];

  if (!filename || !*filename) {
    obj->save_->reportErrorMsg ("No output filename provided");
    return;
  }
  
  Boolean savecurrpage = XmToggleButtonGadgetGetState (obj->pagetog_);
  if (savecurrpage) {
    if (obj->save_->doSave (filename, 1, 1, savecurrpage) == 0) 
      obj->save_->reportInfoMsg ("Current screen has been saved");
    else {
      sprintf (msg, "Cannot current screen to file %s", filename);
      obj->save_->reportErrorMsg (msg);
      XtFree (filename);
      return;
    }
  }
  else {
    from = XmTextFieldGetString (obj->from_);
    if (!from || !*from) {
      obj->save_->reportErrorMsg ("No begnning line number information");
      XtFree (filename);
      return;
    }
    to = XmTextFieldGetString (obj->to_);
    if (!from || !*from) {
      obj->save_->reportErrorMsg ("No ending line number information");
      XtFree (filename);
      XtFree (from);
      return;
    }    
    if (sscanf (from, "%d", &fnum) < 1) {
      obj->save_->reportErrorMsg ("Syntax error for beginning line number");
      XtFree (filename); XtFree (from); XtFree (to);
      return;
    }
    if (sscanf (to, "%d", &tnum) < 1) {
      obj->save_->reportErrorMsg ("Syntax error for ending line number");
      XtFree (filename); XtFree (from); XtFree (to);
      return;
    }
    if (obj->save_->doSave (filename, fnum, tnum, 0) == 0) {
      sprintf (msg, "All messages between message %d and message %d have been saved", fnum, tnum);
      obj->save_->reportInfoMsg (msg);
    }
    else {
      sprintf (msg, "Cannot save messages to file %s", filename);
      obj->save_->reportErrorMsg (msg);
      XtFree (filename); XtFree (from); XtFree (to);
      return;
    }
  }
  obj->popdown ();
}

void
cmlogXuiSaveDialog::cancelCallback (Widget w, XtPointer data,
				    XmAnyCallbackStruct* cbs)
{
  cmlogXuiSaveDialog* obj = (cmlogXuiSaveDialog *)data;
  obj->popdown ();
}

void
cmlogXuiSaveDialog::popup (void)
{
  Arg arg[20];
  int ac = 0;
  char temp[80];

  XcodaFormDialog::popup ();

  // set starting and ending line number
  int nummsgs = save_->numMsgsInBuffer ();
  int start = 1;
  int end = nummsgs;

  sprintf (temp, "%d", start);
  XtSetArg (arg[ac], XmNvalue, temp); ac++;
  XtSetValues (from_, arg, ac);
  ac = 0;

  sprintf (temp, "%d", end);
  XtSetArg (arg[ac], XmNvalue, temp); ac++;
  XtSetValues (to_, arg, ac);
  ac = 0;  

  XmToggleButtonGadgetSetState (pagetog_, 1, 0);
}
