//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Save Command in the file menu
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiSave.cc,v $
//   Revision 1.2  2000/06/20 19:36:42  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:14  chen
//   CMLOG version 2.0
//
//
//
#include <XcodaApp.h>
#include "cmlogXuiDisp.h"
#include "cmlogXuiMenuWin.h"
#include "cmlogXuiTopW.h"
#include "cmlogXuiSave.h"
#include "cmlogXuiSaveDialog.h"

cmlogXuiSave::cmlogXuiSave (const char* name, int active,
			    const char* acc, const char* acc_text,
			    cmlogXuiMenuWin* win,
			    cmlogXuiBrowser& browser)
:cmlogXuiMenuBtn (name, active, acc, acc_text, win, browser), dialog_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiSave Class Object\n");
#endif
}

cmlogXuiSave::~cmlogXuiSave (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiSave Class Object\n");
#endif
}

int
cmlogXuiSave::doSave (char* fname, int from, int end, int saveCurrentPage)
{
  if (saveCurrentPage) 
    return disp_->saveCurrentScreen (fname);
  return disp_->saveMessages (fname, from, end);
}

void
cmlogXuiSave::pointedMsgNumber (int number)
{
  if (!dialog_ || !dialog_->isMapped())
    return;
  dialog_->setPointedMsgNumber (number);
}


void
cmlogXuiSave::doit (void)
{
  char temp[128];

  if (disp_->numberMessagesInBuffer() == 0) {
    reportErrorMsg ("No messages available");
    return;
  }

  if (!dialog_) {
    dialog_ = new cmlogXuiSaveDialog (this, "saveDialog", 
				      "cmlog_save_dialog",
				       browser_);
    dialog_->init ();
  }
  dialog_->popup ();
}

int
cmlogXuiSave::numMsgsInBuffer (void)
{
  return disp_->numberMessagesInBuffer ();
}


void
cmlogXuiSave::undoit (void)
{
  // empty
}

