//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Stop a long query process dialog box
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiQueryCancelDialog.h,v $
//   Revision 1.2  2000/06/20 19:36:41  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
//
//
#ifndef _CMLOG_XUI_QUERY_CANCEL_DIALOG_H
#define _CMLOG_XUI_QUERY_CANCEL_DIALOG_H

#include <stdio.h>
#include <string.h>
#include <XcodaWarningDialog.h>

class cmlogXuiDisp;

class cmlogXuiQueryCancelDialog : public XcodaWarningDialog
{
public:
  // constructor and destructor
  cmlogXuiQueryCancelDialog  (cmlogXuiDisp* disp, 
			      const char* name, const char* title,
			      cmlogXuiBrowser& browser);
  ~cmlogXuiQueryCancelDialog (void);

  const char *className() const {return "cmlogXuiQueryCancelDialog";}

protected:
  // inherited operation
  void ok (void);
  
private:
  // a message being send to the server
  static char* serverMsg_;

  // a message being displayed
  static const char* dispMsg_;

  // display window
  cmlogXuiDisp* disp_;

  // network handler
  cmlogXuiBrowser& browser_;
};
#endif

