//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of RunControl MenuCommand Class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiMenuWin.cc,v $
//   Revision 1.3  2000/06/20 19:36:40  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.2  1999/11/12 17:32:07  chen
//   beta 2.0
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:43  bickley
// Added cmlog to application development system.
//
//
#include <stdio.h>
#include <string.h>
#include <Xm/Form.h>
#include <Xm/PanedW.h>

#include <XcodaApp.h>
#include <codaComd.h>
#include <codaComdXInterface.h>
#include <codaComdList.h>
#include <codaSepComd.h>
#include <XcodaMenuBar.h>
#include <XcodaXpmLabel.h>

#include "cmlogXuiConfig.h"
#include "cmlogXuiMenuWin.h"
#include "cmlogXuiClose.h"
#include "cmlogXuiNew.h"
#include "cmlogXuiSave.h"
#include "cmlogXuiConnect.h"
#include "cmlogXuiDisc.h"
#include "cmlogXuiExit.h"
#include "cmlogXuiUpdate.h"
#include "cmlogXuiQuery.h"
#include "cmlogXuiRefresh.h"
#include "cmlogXuiRmAll.h"
#include "cmlogXuiSvrInfo.h"
#include "cmlogXuiConfigInfo.h"
#include "cmlogXuiConvOption.h"
#include "cmlogXuiBlinkOption.h"
#include "cmlogXuiUbuf.h"
#include "cmlogXuiSaveSettings.h"
#include "cmlogXuiTitleBar.h"
#include "cmlogXuiDisp.h"
#include "cmlogXuiClock.h"
#include "cmlogXuiTimeWin.h"
#include "cmlogXuiHelpAbout.h"

cmlogXuiMenuWin::cmlogXuiMenuWin (Widget parent,
				  const char* name,
				  cmlogXuiBrowser& browser)
:XcodaMenuWindow (parent, name), browser_ (browser)
{
#ifdef _TRACE_OBJECTS
  printf ("         Create cmlogXuiMenuWin Class Object\n");
#endif
  neww_ = 0;
  close_ = 0;
  save_ = 0;
  connect_ = 0;
  disc_ = 0;
  sep0_ = 0;
  sep1_ = 0;
  exit_ = 0;
  disp_ = 0;

  update_ = 0;
  query_ = 0;
  refresh_ = 0;
  rmall_ = 0;
  svrinfo_ = 0;
  confinfo_ = 0;
  conv_ = 0;
  blink_ = 0;

  ubuf_ = 0;
  saves_ = 0;
  titleBar_ = 0;
  topw_ = 0;
  clock_ = 0;
  twin_ = 0;

  about_ = 0;
}


cmlogXuiMenuWin::~cmlogXuiMenuWin (void)
{
#ifdef _TRACE_OBJECTS
  printf ("         Delete cmlogXuiMenuWin Class Object\n");
#endif
  delete neww_;
  delete close_;
  delete save_;
  delete connect_;
  delete disc_;
  delete sep0_;
  delete sep1_;
  delete exit_;

  delete update_;
  delete query_;
  delete svrinfo_;
  delete confinfo_;
  delete refresh_;
  delete rmall_;
  delete conv_;
  delete blink_;

  delete ubuf_;
  delete saves_;

  delete about_;
  // no need to delete disp_ that is deleted upon destruction of widget
}

void
cmlogXuiMenuWin::createMenuPanes (void)
{
  codaComdList* list;

  // file menu
  neww_ = new cmlogXuiNew ("New", 1, "Alt<Key>n", "Alt/N",
			  this, browser_);
  close_ = new cmlogXuiClose ("Close", 1, "Alt<Key>l", "Alt/L",
			      this, browser_);
  save_ = new cmlogXuiSave ("Save Screen", 1, "Alt<Key>p", "Alt/P",
			    this, browser_);
  sep0_ = new codaSepComd ("sep0");
  if (browser_.connected ()) {
    connect_ = new cmlogXuiConnect ("Connect", 0, "Alt<Key>c", "Alt/C",
				    this, browser_);
    disc_ = new cmlogXuiDisc ("Disconnect", 1, "Alt<Key>d", "Alt/D",
			      this, browser_);
  }
  else {
    connect_ = new cmlogXuiConnect ("Connect", 1, "Alt<Key>c", "Alt/C",
				    this, browser_);
    disc_ = new cmlogXuiDisc ("Disconnect", 0, "Alt<Key>d", "Alt/D",
			      this, browser_); 
  }
  sep1_ = new codaSepComd ("sep1");

  exit_ = new cmlogXuiExit ("Exit", 1, "Alt<Key>q", "Alt/Q",
			    this, browser_);

  list = new codaComdList ();
  list->add (neww_);
  list->add (close_);
  list->add (save_);
  list->add (sep0_);
  list->add (connect_);
  list->add (disc_);
  list->add (sep1_);
  list->add (exit_);
  
  MenuBar->addRegMenuEntry (list, (char *)("File"), 'F');
  delete list;

  // options menu
  refresh_ = new cmlogXuiRefresh ("Refresh", 1, "Alt<Key>f", "Alt/F",
				  this, browser_);
  rmall_ = new cmlogXuiRmAll ("Remove All", 1, "Alt<Key>r", "Alt/R",
				  this, browser_);
  svrinfo_ = new cmlogXuiSvrInfo ("Server Info", 1, "Alt<Key>i", "Alt/I",
				  this, browser_);
  confinfo_ = new cmlogXuiConfigInfo ("Configuration Info", 1, 
				      "Alt<Key>g", "Alt/g",
				      this, browser_);
  if (browser_.connected () ) {
    query_ = new cmlogXuiQuery ("Query", 1, "Alt<Key>s", "Alt/S",
				this, browser_);
    update_ = new cmlogXuiUpdate ("Update", 1, "Alt<Key>u", "Alt/U",
				  0, this, browser_);
  }
  else {
    query_ = new cmlogXuiQuery ("Query", 0, "Alt<Key>s", "Alt/S",
				this, browser_);
    update_ = new cmlogXuiUpdate ("Update", 0, "Alt<Key>u", "Alt/U",
				  0, this, browser_);
  }
  list = new codaComdList ();
  list->add (refresh_);
  list->add (rmall_);
  list->add (svrinfo_);
  list->add (confinfo_);
  list->add (query_);
  list->add (update_);
  
  MenuBar->addRegMenuEntry (list, (char *)("Options"), 'O');
  delete list;

  // preferences menu
  ubuf_ = new cmlogXuiUbuf ("Updating Buffer Size", 1, "Alt<Key>b",
			    "Alt/B", this, browser_);
  saves_ = new cmlogXuiSaveSettings ("Save Current Settings", 1, "Alt<Key>t",
				     "Alt/T", this, browser_);
  conv_ = new cmlogXuiConvOption ("Code Conversion", 0, "Alt<Key>v",
				  "Alt/V", 0, this, browser_);
  blink_ = new cmlogXuiBlinkOption ("Blink", 0, "Alt<Key>k",
				    "Alt/K", 0, this, browser_);
  
  list = new codaComdList ();
  list->add (ubuf_);
  list->add (saves_);
  list->add (conv_);
  list->add (blink_);

  MenuBar->addRegMenuEntry (list, (char *)("Preferences"), 'P');
  delete list;

  // help menu
  about_ = new cmlogXuiHelpAbout ("About", 1, "Alt<Key>a", "Alt/A",
				  this, browser_);
  list = new codaComdList ();
  list->add (about_);
  MenuBar->addHelpMenuEntry (list, (char *)("Help"), 'H');
 
  delete list;

  // set pointer for menu buttons
  neww_->displayWindow (disp_);
  close_->displayWindow (disp_);
  save_->displayWindow (disp_);
  connect_->displayWindow (disp_);
  disc_->displayWindow (disp_);
  exit_->displayWindow (disp_);

  refresh_->displayWindow (disp_);
  rmall_->displayWindow (disp_);
  conv_->displayWindow (disp_);
  blink_->displayWindow (disp_);
  query_->displayWindow (disp_);
  svrinfo_->displayWindow (disp_);
  confinfo_->displayWindow (disp_);
  update_->displayWindow (disp_);

  ubuf_->displayWindow (disp_);
  saves_->displayWindow (disp_);

  about_->displayWindow (disp_);
}


Widget
cmlogXuiMenuWin::createMenuWindow (Widget parent)
{
  Arg arg[20];
  int ac = 0;
  Widget tform;
  cmlogXuiConfig* config = cmlogXuiConfig::config ();

  Widget form = XtCreateWidget ("cmlogTopForm", xmFormWidgetClass, parent,
				arg, ac);
  ac = 0;

  // create a widget holding all time displays
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 3); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 15 + 4 + 4); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 2); ac++;
  tform = XtCreateWidget ("time_form", xmFormWidgetClass, form,
			  arg, ac);
  ac = 0;

  // clock
  clock_ = new cmlogXuiClock (tform, "clockDisplay",
			      this, browser_);
  clock_->init ();
  // time interval display
  twin_ = new cmlogXuiTimeWin (tform, "timeDisplay",
			       this, browser_);
  twin_->init ();

  // set x resources
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetValues (clock_->baseWidget (), arg, ac);
  ac = 0;

  
  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetValues (twin_->baseWidget (), arg, ac);  
  ac = 0;
			  

  // create title bar
  titleBar_ = new cmlogXuiTitleBar (form, "titleBarList", 
				    config->numColumns (),
				    config->columnWidths (),
				    config->columnTags (),
				    config->columnTitles (),
				    browser_);

  titleBar_->init ();

  // create display window
  disp_ = new cmlogXuiDisp (form, "displayList", config->numColumns (),
			    config->columnWidths (),
			    config->columnTags (),
			    config->updateBufsize (),
			    this,
			    browser_);

  disp_->init ();

  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 5); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 2); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 15 + 2 + 4); ac++;
  XtSetValues (titleBar_->baseWidget (), arg, ac);
  ac = 0;


  XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNtopWidget, titleBar_->baseWidget ()); ac++;
  XtSetArg (arg[ac], XmNtopOffset, 2); ac++;
  XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNleftOffset, 2); ac++;
  XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg (arg[ac], XmNrightOffset, 2); ac++;
  XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg (arg[ac], XmNbottomWidget, tform); ac++;
  XtSetArg (arg[ac], XmNbottomOffset, 2); ac++;
  XtSetValues (disp_->baseWidget (), arg, ac);
  ac = 0;

  // set pointers to each other
  disp_->titleBar (titleBar_);
  titleBar_->displayWindow (disp_);

  XtManageChild (tform);
  
  XtManageChild (form);

  return form;
}

void
cmlogXuiMenuWin::topLevelWindow (XcodaTopLevel* top)
{
  topw_ = top;
}

XcodaTopLevel *
cmlogXuiMenuWin::topLevelWindow (void) const
{
  return topw_;
}

void
cmlogXuiMenuWin::defineCursor (unsigned int cursor)
{
  if (topw_)
    topw_->defineCursor (cursor);
}

void
cmlogXuiMenuWin::undefineCursor (void)
{
  if (topw_)
    topw_->undefineCursor ();
}

void
cmlogXuiMenuWin::connectionConfig (void)
{
  cmlogXuiConfig* config = cmlogXuiConfig::config ();

  connect_->deactivate ();
  disc_->activate ();
  query_->activate ();
  update_->activate ();
  update_->setState (0);

  if (config->doCodeConversion()) {
    conv_->activate();
    conv_->setState(1);
  }
  else {
    conv_->deactivate ();
    conv_->setState(0);
  }

  if (config->blinkOn ()) {
    blink_->activate();
    blink_->setState(1);
  }
  else {
    blink_->deactivate ();
    blink_->setState(0);
  }
}

void
cmlogXuiMenuWin::disconnectConfig (void)
{
  connect_->activate ();
  disc_->deactivate ();
  query_->deactivate ();
  update_->deactivate ();
  update_->setState (0);
  conv_->deactivate();
  blink_->deactivate();

  // enable close and exit window
  close_->activate ();
  exit_->activate ();  
}

void
cmlogXuiMenuWin::serverCrashConfig (void)
{
  connect_->activate ();
  disc_->deactivate ();
  update_->deactivate ();
  update_->setState (0);
  query_->deactivate ();
  conv_->deactivate();
  blink_->deactivate();

  // enable close and exit window
  close_->activate ();
  exit_->activate ();  

  disp_->reportErrorMsg ("The cmlogServer has gone away !!!");
}

cmlogXuiDisp *
cmlogXuiMenuWin::displayWindow (void) const
{
  return disp_;
}

void
cmlogXuiMenuWin::updateTime (time_t t)
{
  if (clock_)
    clock_->display (t);
}

void
cmlogXuiMenuWin::setStartTime (time_t t0)
{
  if (twin_)
    twin_->setStartTime (t0);
}

void
cmlogXuiMenuWin::setEndTime (time_t t0)
{
  if (twin_)
    twin_->setEndTime (t0);  
}

void
cmlogXuiMenuWin::normalConfig (void)
{
  update_->activate ();
  query_->activate ();
  update_->setState (0);

  // enable close and exit window
  close_->activate ();
  exit_->activate ();  
}

void
cmlogXuiMenuWin::updatingConfig (void)
{
  update_->activate ();
  query_->deactivate ();

  // disable close and exit window
  close_->deactivate ();
  exit_->deactivate ();
}

void
cmlogXuiMenuWin::queryConfig (void)
{
  query_->deactivate ();
  update_->deactivate ();

  // disable close and exit window
  close_->deactivate ();
  exit_->deactivate ();
}

void
cmlogXuiMenuWin::pointedMsgNumber (int number)
{
  save_->pointedMsgNumber (number);
}
