//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of CMLOG XUI generic menu toggle button class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiMenuTog.cc,v $
//   Revision 1.2  2000/06/20 19:36:39  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:40  bickley
// Added cmlog to application development system.
//
//
//
#include <stdio.h>
#include <string.h>
#include <XcodaApp.h>
#include <XcodaErrorDialog.h>
#include <codaComdXInterface.h>
#include <cmlogXuiDisp.h>
#include <cmlogXuiMenuWin.h>
#include "cmlogXuiMenuTog.h"

cmlogXuiMenuTog::cmlogXuiMenuTog (const char* name, int active,
				  const char* acc, const char* acc_text,
				  int state,
				  cmlogXuiMenuWin* menuwin,
				  cmlogXuiBrowser& browser)
:codaTbtnComd (name, active, acc, acc_text, state), disp_ (0), 
 menuwin_ (menuwin), browser_ (browser)
{
#ifdef _TRACE_OBJECTS
  printf ("         Create cmlogXuiMenuTog Class Object\n");
#endif
  // empty
}

cmlogXuiMenuTog::~cmlogXuiMenuTog (void)
{
#ifdef _TRACE_OBJECTS
  printf ("         Delete cmlogXuiMenuTog Class Object\n");
#endif
  // empty
}

void
cmlogXuiMenuTog::reportErrorMsg (const char* msg)
{
  if (disp_)
    disp_->reportErrorMsg (msg);
}

void
cmlogXuiMenuTog::reportInfoMsg (const char* msg)
{
  if (disp_)
    disp_->reportInfoMsg (msg);
}


void
cmlogXuiMenuTog::displayWindow (cmlogXuiDisp* disp)
{
  disp_ = disp;
}

const Widget
cmlogXuiMenuTog::dialogBaseWidget (void)
{
  if (disp_)
    return disp_->baseWidget ();
  return 0;
}
