//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of CMLOG XUI generic menu button class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiMenuBtn.cc,v $
//   Revision 1.2  2000/06/20 19:36:39  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:37  bickley
// Added cmlog to application development system.
//
//
//
#include <stdio.h>
#include <string.h>
#include <XcodaApp.h>
#include <XcodaErrorDialog.h>
#include <codaComdXInterface.h>
#include <cmlogXuiDisp.h>
#include <cmlogXuiMenuWin.h>
#include "cmlogXuiMenuBtn.h"

cmlogXuiMenuBtn::cmlogXuiMenuBtn (const char* name, int active,
				  const char* acc, const char* acc_text,
				  cmlogXuiMenuWin* menuwin,
				  cmlogXuiBrowser& browser)
:codaPbtnComd (name, active, acc, acc_text), disp_ (0), 
 menuwin_ (menuwin), browser_ (browser)
{
#ifdef _TRACE_OBJECTS
  printf ("         Create cmlogXuiMenuBtn Class Object\n");
#endif
  // empty
}

cmlogXuiMenuBtn::~cmlogXuiMenuBtn (void)
{
#ifdef _TRACE_OBJECTS
  printf ("         Delete cmlogXuiMenuBtn Class Object\n");
#endif
  // empty
}

void
cmlogXuiMenuBtn::reportErrorMsg (const char* msg)
{
  if (disp_)
    disp_->reportErrorMsg (msg);
}

void
cmlogXuiMenuBtn::reportInfoMsg (const char* msg)
{
  if (disp_)
    disp_->reportInfoMsg (msg);
}


void
cmlogXuiMenuBtn::displayWindow (cmlogXuiDisp* disp)
{
  disp_ = disp;
}

const Widget
cmlogXuiMenuBtn::dialogBaseWidget (void)
{
  if (disp_)
    return disp_->baseWidget ();
  return 0;
}

void
cmlogXuiMenuBtn::defineCursor (unsigned int cursor)
{
  menuwin_->defineCursor (cursor);
}

void
cmlogXuiMenuBtn::undefineCursor (void)
{
  menuwin_->undefineCursor ();
}


