//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Xui Help About Dialog
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiHADialog.h,v $
//   Revision 1.2  2000/06/20 19:36:38  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:31:28  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_XUI_HADIALOG_H
#define _CMLOG_XUI_HADIALOG_H

#include <stdio.h>
#include <string.h>
#include <XcodaFormDialog.h>


class XcodaXpmLabel;
class cmlogXuiHelpAbout;

class cmlogXuiHADialog: public XcodaFormDialog
{
public:
  //constructor and destructor
  cmlogXuiHADialog  (cmlogXuiHelpAbout* base, 
		     const char* name, const char* title);
  ~cmlogXuiHADialog (void);

  // class name
  virtual const char* className (void) const {return "cmlogXuiHADialog";}

protected:
  // inherited operations
  void    createFormChildren (void);
  // callback for pushbuttons
  static void okCallback (Widget, XtPointer, XmAnyCallbackStruct* );

private:
  cmlogXuiHelpAbout* base_;
  XcodaXpmLabel* log_;
};
#endif
