//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of code conversion menu option
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiConvOption.cc,v $
//   Revision 1.2  2000/06/20 19:36:37  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:13  chen
//   CMLOG version 2.0
//
//
//
#include <cmlogXuiDisp.h>
#include <cmlogXuiMenuWin.h>
#include <cmlogXuiConfig.h>
#include "cmlogXuiConvOption.h"

cmlogXuiConvOption::cmlogXuiConvOption (const char* name, int active,
					const char* acc, 
					const char* acc_text,
					int state,
					cmlogXuiMenuWin* menuwin,
					cmlogXuiBrowser& browser)
:cmlogXuiMenuTog (name, active, acc, acc_text, state, menuwin, browser)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiConvOption Class Object\n");
#endif
  cmlogXuiConfig* config = cmlogXuiConfig::config ();
  cmlogXuiDisp* disp = menuwin_->displayWindow ();

  if (config->doCodeConversion()) {
    setState (1);
    disp->enableCodeConversion();
  }
  else 
    setState (0);
}

cmlogXuiConvOption::~cmlogXuiConvOption (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiConvOption Class Object\n");
#endif
  // empty
}

void
cmlogXuiConvOption::doit (void)
{
  cmlogXuiDisp* disp = menuwin_->displayWindow ();

  if (state () > 0) {
    disp->enableCodeConversion();
  }
  else {
    disp->disableCodeConversion(); 
  }
  disp->toggleCodeConvDisp ();
}

void
cmlogXuiConvOption::undoit (void)
{
  // empty
}


