//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of close command menu in the file menu
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogXuiClose.cc,v $
//   Revision 1.2  2000/06/20 19:36:36  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:12  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:30:59  bickley
// Added cmlog to application development system.
//
//
//
#include <XcodaApp.h>
#include "cmlogXuiMenuWin.h"
#include "cmlogXuiTopW.h"
#include "cmlogXuiClose.h"
#include "cmlogXuiCloseDialog.h"

cmlogXuiClose::cmlogXuiClose (const char* name, int active,
			      const char* acc, const char* acc_text,
			      cmlogXuiMenuWin* win,
			      cmlogXuiBrowser& browser)
:cmlogXuiMenuBtn (name, active, acc, acc_text, win, browser), dialog_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiClose Class Object\n");
#endif
}

cmlogXuiClose::~cmlogXuiClose (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiClose Class Object\n");
#endif
}

void
cmlogXuiClose::doClose (void)
{
  XcodaTopLevel* topw = menuwin_->topLevelWindow ();
  if (theApplication->numTopWindows() > 1) {
    // everything will be freed upon widget destroy callback 
    XtDestroyWidget(topw->baseWidget());
  }
  else{
    if (browser_.connected ())
      browser_.disconnect ();
    theApplication->cleanMemory();
  }
}

void
cmlogXuiClose::doit (void)
{
  char temp[128];

  if (!dialog_) {
    dialog_ = new cmlogXuiCloseDialog (this, (char *)("closeDialog"), 
				       (char *)("cmlog_close_dialog"),
				       browser_);
    dialog_->init ();
    dialog_->alignment (XmALIGNMENT_CENTER);
  }
  if (theApplication->numTopWindows() > 1) {
    sprintf (temp, "Do you really want to close this window ?");
    dialog_->setMessage (temp);
  }
  else {
    sprintf (temp, "You will exit this application, \n");
    strcat  (temp, "Are you sure ?");
    dialog_->setMessage (temp);
  }
  dialog_->popup ();
}

void
cmlogXuiClose::undoit (void)
{
  // empty
}

