//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of blink menu option
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: cmlogXuiBlinkOption.cc,v $
//   Revision 1.2  2000/06/20 19:36:36  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1  1999/11/12 17:31:57  chen
//   beta 2.0
//
//
//
//
#include <cmlogXuiDisp.h>
#include <cmlogXuiMenuWin.h>
#include <cmlogXuiConfig.h>
#include "cmlogXuiBlinkOption.h"

cmlogXuiBlinkOption::cmlogXuiBlinkOption (const char* name, int active,
					  const char* acc, 
					  const char* acc_text,
					  int state,
					  cmlogXuiMenuWin* menuwin,
					  cmlogXuiBrowser& browser)
:cmlogXuiMenuTog (name, active, acc, acc_text, state, menuwin, browser)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogXuiBlinkOption Class Object\n");
#endif
  cmlogXuiConfig* config = cmlogXuiConfig::config ();
  cmlogXuiDisp* disp = menuwin_->displayWindow ();

  if (config->blinkOn()) {
    setState (1);
    disp->enableBlinkOn();
  }
  else 
    setState (0);
}

cmlogXuiBlinkOption::~cmlogXuiBlinkOption (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogXuiBlinkOption Class Object\n");
#endif
  // empty
}

void
cmlogXuiBlinkOption::doit (void)
{
  cmlogXuiDisp* disp = menuwin_->displayWindow ();

  if (state () > 0) {
    disp->enableBlinkOn();
  }
  else {
    disp->disableBlinkOn(); 
  }
  disp->refresh();
}

void
cmlogXuiBlinkOption::undoit (void)
{
  // empty
}


