// test program for cmlog database
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#include <cmlogDatabase.h>
#include <cmlogUtil.h>

main (int argc, char **argv)
{
  if (argc != 3) {
    fprintf (stderr, "usage: %s dbasename count\n", argv[0]);
    exit (1);
  }
  int count = atoi (argv[2]);

  cdevData data;
  double key = 0.0;
  int    value;
  char   message[1024];

  cmlogUtil::setTags ();

  cmlogDatabase dbase (argv[1], O_RDONLY);

  if (dbase.cursorInit (data, &key) != CDEV_SUCCESS) 
    fprintf (stderr, "Thread2 cannot do init cursor\n");
  else {
    data.get (322, &value);
    data.get (324, message, sizeof (message));
    printf ("cursor data has value %d: %s and key %lf\n", value, message, key);
    for (int i = 1; i < count; i++) {
      data.remove ();
      if (dbase.cursorNext (data, &key) != CDEV_SUCCESS)
	break;
      else {
	data.get (322, &value);
	data.get (324, message, sizeof (message));
	printf ("Cursor data has value %d: %s and key %lf\n", value, message, 
		key);
      }
    }
  }  

  dbase.close ();
}

      
