// Test program for thread manager

#include "cpThread.h"
#include "cpThreadManager.h"

typedef struct buddle_
{
  cpThreadManager* manager;
  cpMutex*         lock;
  cpConditionMutex* cond;
}cpArg;

static  int  interrupted = 0;
static  int  flag = 0;

static void signalHandler (int signo)
{
  printf ("get signal %d\n", signo);
  interrupted = 1;
}

static int
reader (cpArg* arg)
{
 cpThreadControl control (arg->manager);

 arg->lock->acquire ();
 while (!flag) {
   printf ("%d: Wait on the flag\n", cpThread::self ());
   arg->cond->wait ();
 }
 printf ("%d: Get flag\n", cpThread::self ());
 flag = 0;
 arg->lock->release ();
}

static int
writer (cpArg* arg)
{
 cpThreadControl control (arg->manager);

 int i = 0;
 int loop = 10;

 for (i = 0; i < loop; i++)
   taskDelay (sysClkRateGet ());

 arg->lock->acquire ();
 flag = 1;
 arg->lock->release ();
 arg->cond->signal ();
 printf ("send out signal of thread  %d\n", cpThread::self ());
}
 

static int signals[] =
{SIGINT, SIGQUIT, SIGILL, SIGFPE,
 SIGPIPE, SIGQUIT,
 SIGTERM, SIGTSTP, SIGCONT};

static int numSignals = 9;

synchTest (void)
{
  cpThreadManager manager;
  cpMutex lock;
  cpConditionMutex cond (lock);

  cpArg   arg;
  arg.manager = &manager;
  arg.lock = &lock;
  arg.cond = &cond;

  
  int grpid = manager.spawn_n (1, CP_THREAD_FUNC (reader),
			       (void *)&arg);

  printf ("Group id is %d\n", grpid);

  grpid = manager.spawn_n (1, CP_THREAD_FUNC (writer),
			   (void *)&arg);

  printf ("Group id is %d\n", grpid);


  struct sigaction act, oact;
  act.sa_handler = signalHandler;
  act.sa_flags = 0;
  sigemptyset (&act.sa_mask);

  for (int i = 0; i < numSignals; i++)
    sigaction (signals[i], &act, &oact);

  //manager.wait (); // wait for all task to finish
  while (!interrupted)
    taskDelay (2*sysClkRateGet ());

  printf ("End of the task\n");
  interrupted = 0;
}


  
