//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Server Query Message Logic Expression Parser Supporting Routines
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogLogicSup.cc,v $
//   Revision 1.2  2002/12/21 01:31:05  chen
//   Fix a serious bug on multi-threaded
//
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.2  1997/10/08  18:37:36  chen
// add lock to yyparse
//
// Revision 1.1  1997/08/01  15:29:51  bickley
// Added cmlog to application development system.
//
//
//
#include <stdio.h>
#include <string.h>
#include <cmlogConfig.h>
#include <cdevData.h>
#include <cmlogLogic.h>


#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
#include <cpSynch.h>
#endif

// current cdevData object
static cdevData* _logic_data_;
// current parsing result
static int       _logic_result;

static void 
set_cdev_data (cdevData* data)
{
  _logic_data_ = data;
}

static void 
set_input_text (char* text)
{
  _logic_input_text = text;
}

void
set_final_result (int res)
{
  _logic_result = res;
}

int
cdev_data_equal_int (char* name, int val)
{
  int       temp;

  if (_logic_data_->get (name, &temp) == CDEV_SUCCESS) {
    if (temp == val)
      return 1;
  }
  return 0;
}

int
cdev_data_equal_dbl (char* name, double val)
{
  double    temp;

  if (_logic_data_->get (name, &temp) == CDEV_SUCCESS) {
    if (temp == val)
      return 1;
  }
  return 0;
}

int
cdev_data_less_int (char* name, int val)
{
  int       temp;

  if (_logic_data_->get (name, &temp) == CDEV_SUCCESS) {
    if (temp < val)
      return 1;
  }
  return 0;
}

int
cdev_data_less_dbl (char* name, double val)
{
  double    temp;

  if (_logic_data_->get (name, &temp) == CDEV_SUCCESS) {
    if (temp < val)
      return 1;
  }
  return 0;
}

int
cdev_data_greater_int (char* name, int val)
{
  int       temp;

  if (_logic_data_->get (name, &temp) == CDEV_SUCCESS) {
    if (temp > val)
      return 1;
  }
  return 0;
}

int
cdev_data_greater_dbl (char* name, double val)
{
  double    temp;

  if (_logic_data_->get (name, &temp) == CDEV_SUCCESS) {
    if (temp > val)
      return 1;
  }
  return 0;
}

int
cdev_data_lesseq_int (char* name, int val)
{
  int       temp;

  if (_logic_data_->get (name, &temp) == CDEV_SUCCESS) {
    if (temp <= val)
      return 1;
  }
  return 0;
}

int
cdev_data_lesseq_dbl (char* name, double val)
{
  double    temp;

  if (_logic_data_->get (name, &temp) == CDEV_SUCCESS) {
    if (temp <= val)
      return 1;
  }
  return 0;
}

int
cdev_data_greatereq_int (char* name, int val)
{
  int       temp;

  if (_logic_data_->get (name, &temp) == CDEV_SUCCESS) {
    if (temp >= val)
      return 1;
  }
  return 0;
}

int
cdev_data_greatereq_dbl (char* name, double val)
{
  double    temp;

  if (_logic_data_->get (name, &temp) == CDEV_SUCCESS) {
    if (temp >= val)
      return 1;
  }
  return 0;
}

int
cdev_data_noequal_int (char* name, int val)
{
  int       temp;

  if (_logic_data_->get (name, &temp) == CDEV_SUCCESS) {
    if (temp != val)
      return 1;
  }
  return 0;
}

int
cdev_data_noequal_dbl (char* name, double val)
{
  double    temp;

  if (_logic_data_->get (name, &temp) == CDEV_SUCCESS) {
    if (temp != val)
      return 1;
  }
  return 0;
}

int
cdev_data_equal_str (char* name, char* val)
{
  char      temp[256];

  if (_logic_data_->get (name, temp, sizeof (temp)) == CDEV_SUCCESS) {
    if (strcmp (temp, val) == 0)
      return 1;
  }
  return 0;

}

int
cdev_data_noequal_str (char* name, char* val)
{
  char      temp[256];

  if (_logic_data_->get (name, temp, sizeof (temp)) == CDEV_SUCCESS) {
    if (strcmp (temp, val) == 0)
      return 0;
  }
  return 1;

}

int
cdev_data_has_str (char* name, char* val)
{
  char      temp[256];

  if (_logic_data_->get (name, temp, sizeof (temp)) == CDEV_SUCCESS) {
    if (strstr (temp, val))
      return 1;
  }
  return 0;

}

int 
cdev_data_logic_result (void)
{
  return _logic_result;
}

/* global input_text buffer */
char* _logic_input_text;

/* forward declaration of yyparse */
extern "C" int yyparse (void);

int 
dataMatchLogic (cdevData& data, char* string)
{
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cpMutex lock;
  cpMutexGuard guard (lock);
#endif

  set_input_text (string);
  set_cdev_data  (&data);

  if (yyparse ()) /* error: grammer */
    return -1;
  else 
    return cdev_data_logic_result ();
}

#ifdef _CMLOG_PARSE_DEBUG
char* log_exp = "(value > 50 && severity > 8) && !class like 'epics'";
main (int argc, char** argv)
{
  char expression[256];
  cdevData data[100];
  int      i = 0;


  for (i = 0; i < 100; i++) {
    data[i].insert ("value", i);
    data[i].insert ("severity", i/10);
    if (i < 50) {
      data[i].insert ("status", 0);
      data[i].insert ("class", "epics");
    }
    else {
      data[i].insert ("status", 1);
      data[i].insert ("class", "coda");
    }
  }


  for (i = 0; i < 100; i++) {
    set_input_text (log_exp);
    set_cdev_data (&(data[i]));
    if (parse_logic (log_exp) == 0) {
      if (cdev_data_logic_result ()) 
	printf ("data %d is ok\n", i);
    }
  }
}
#endif

  
