/*
//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Header File for cmlogServer Query
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogLogic.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:29:50  bickley
// Added cmlog to application development system.
//
//
//
*/
#ifndef _CMLOG_LOGIC_H
#define _CMLOG_LOGIC_H

/* function decleration of supporting functions */
extern char* _logic_input_text;
#ifdef __cplusplus
extern "C" {
#endif

#if defined (__STDC__) || defined (__cplusplus)
extern void set_final_result                 (int res);
extern int  cdev_data_equal_int              (char* tag, int value);
extern int  cdev_data_equal_dbl              (char* tag, double value);
extern int  cdev_data_equal_str              (char* tag, char* str);
extern int  cdev_data_has_str                (char* tag, char* str);
extern int  cdev_data_less_int               (char* tag, int value);
extern int  cdev_data_less_dbl               (char* tag, double value);
extern int  cdev_data_greater_int            (char* tag, int value);
extern int  cdev_data_greater_dbl            (char* tag, double value);
extern int  cdev_data_lesseq_int             (char* tag, int value);
extern int  cdev_data_lesseq_dbl             (char* tag, double value);
extern int  cdev_data_greatereq_int          (char* tag, int value);
extern int  cdev_data_greatereq_dbl          (char* tag, double value);
extern int  cdev_data_noequal_int            (char* tag, int value);
extern int  cdev_data_noequal_dbl            (char* tag, double value);
extern int  cdev_data_noequal_str            (char* tag, char* str);
extern int  cdev_data_logic_result           (void);
#else
extern void set_final_result                 ();
extern int  cdev_data_equal_int              ();
extern int  cdev_data_equal_dbl              ();
extern int  cdev_data_equal_str              ();
extern int  cdev_data_has_str                ();
extern int  cdev_data_less_int               ();
extern int  cdev_data_less_dbl               ();
extern int  cdev_data_greater_int            ();
extern int  cdev_data_greater_dbl            ();
extern int  cdev_data_lesseq_int             ();
extern int  cdev_data_lesseq_dbl             ();
extern int  cdev_data_greatereq_int          ();
extern int  cdev_data_greatereq_dbl          ();
extern int  cdev_data_noequal_int            ();
extern int  cdev_data_noequal_dbl            ();
extern int  cdev_data_noequal_str            ();
extern int  cdev_data_logic_result           ();
#endif

#ifdef __cplusplus
};
#endif


#endif
