//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog Server Query Connection Acceptor
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogQueryAcceptor.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
//
//
#include <cmlogUtil.h>
#include "cmlogQueryAcceptor.h"
#include "cmlogQueryIO.h"

#if defined (solaris)
#define TCP_NODELAY 1
#elif defined (__hpux)
#include <netinet/tcp.h>
#elif defined (__linux)
#include <netinet/tcp.h>
#endif


#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
cmlogQueryAcceptor::cmlogQueryAcceptor (ACE_Reactor& r, 
					cpThreadManager& manager)
:cmlogAcceptor (r), manager_ (manager)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogQueryAcceptor Class Object\n");
#endif
}
#else
cmlogQueryAcceptor::cmlogQueryAcceptor (ACE_Reactor& r, 
					cpProcessManager& manager)

:cmlogAcceptor (r), manager_ (manager)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogQueryAcceptor Class Object\n");
#endif
}
#endif

cmlogQueryAcceptor::~cmlogQueryAcceptor (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogQueryAcceptor Class Object\n");
#endif
}

int
cmlogQueryAcceptor::handle_input (int)
{
  ACE_INET_Addr rem_addr;

  cmlogQueryIO *query = new cmlogQueryIO (manager_);

  // accept the connection from a client
  if (listener_.accept (*client, &rem_addr, 0) != -1){
#ifdef _CMLOG_DEBUG
    printf ("Received client connection from host %s at port %d\n",
	    rem_addr.get_host_name (), client->get_handle ());
#endif

    // remeber query address
    query->peerAddr (rem_addr);
    // set socket options to KEEP_ALIVE
    int alive = 1;
    query->setSockOption (SOL_SOCKET, SO_KEEPALIVE,
			   (void *)&alive, sizeof (alive));
    
    // set socket TCP_NODELAY option since we are handling buffering
    int nodelay = 1;
    query->setSockOption (IPPROTO_TCP, TCP_NODELAY, 
			   (void *)&nodelay, sizeof (nodelay));
    
    // turn non block socket option off
    // which gives problem when one transfers data from hp to solaris
    query->disable (ACE_NONBLOCK);
    
    // spawn a new detached thread to handle query
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
    cp_thread_t qthread;
    long        attrflag = CP_THREAD_DETACHED;
    manager_.spawn (CP_THREAD_FUNC(&(cmlogQueryIO::queryThread)),
		    (void *)query, attrflag, &qthread);
#else


#endif
    // log server message about new connection
    char tmp[128];
    sprintf (tmp,"Received query request from host %s at port %d\n",
	     rem_addr.get_host_name (), query->get_handle ());
    query->logServerMsg (tmp);
  }
  else {
#ifdef _CMLOG_DEBUG
    printf ("Accept failed\n");
#endif
    return -1;
  }
  return 0;
}


