//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog Server Admin Connection Acceptor
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogAdminAcceptor.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:28:40  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_ADMIN_ACCEPTOR_H
#define _CMLOG_ADMIN_ACCEPTOR_H

#include <cmlogAcceptor.h>

class cmlogAdminIO;
class cmlogClientAcceptor;
class cmlogBrowserAcceptor;

class cmlogAdminAcceptor: public cmlogAcceptor
{
public:
  // constructor and destructor
#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
  cmlogAdminAcceptor  (ACE_Reactor& r, 
		       cmlogDataQueue* dataqueue);
#else
  cmlogAdminAcceptor  (ACE_Reactor& r, 
		       cmlogDataQueue* dataqueue,
		       cmlogDataQueue* cmdqueue);
#endif
  ~cmlogAdminAcceptor (void);

  // admin acceptor needs other acceptor
  void clientManager  (cmlogClientAcceptor* ca);
  void browserManager (cmlogBrowserAcceptor* ba);

  // shut down all client daemons
  void shutdownAllClientD (void);

  
protected:
  // inherited operations
  virtual int handle_input (int fd);

private:
  cmlogClientAcceptor*  clientM_;
  cmlogBrowserAcceptor* browserM_;
};

#endif
