//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog Server TCP Connection Acceptor
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogAcceptor.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:11  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:28:35  bickley
// Added cmlog to application development system.
//
//
#include <errno.h>
#include "cmlogAcceptor.h"
#include "cmlogIO.h"

#if defined (CMLOG_USE_THREAD) && defined (_REENTRANT)
void *
cmlogAcceptor::acceptorThread (void *arg)
{
  cmlogAcceptor* obj = (cmlogAcceptor *)arg;
  char command[32];
  struct sockaddr addr;
  int    len;

  for (;;) {
    obj->handle_input ();
  }
  return 0;
}

cmlogAcceptor::cmlogAcceptor (ACE_Reactor& r, 
			      cmlogDataQueue* queue)
:ACE_Event_Handler (), listener_ (), reactor_ (r), 
 connectionList_ (), dataQueue_ (queue)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogAcceptor Class Object\n");
#endif
}

#else
cmlogAcceptor::cmlogAcceptor (ACE_Reactor& r, 
			      cmlogDataQueue* queue,
			      cmlogDataQueue* cmdQueue)
:ACE_Event_Handler (), listener_ (), reactor_ (r), 
 connectionList_ (), dataQueue_ (queue), cmdQueue_ (cmdQueue)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogAcceptor Class Object\n");
#endif

}
#endif



cmlogAcceptor::~cmlogAcceptor (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogAcceptor Class Object\n");
#endif
  // delete all clients
  deleteAllConnections ();
  // close socket
  handle_close (-1, ACE_Event_Handler::READ_MASK);
}

int
cmlogAcceptor::handle_close (int, ACE_Reactor_Mask)
{
  return listener_.close ();
}

int
cmlogAcceptor::get_handle (void) const
{
  return listener_.get_handle ();
}

int
cmlogAcceptor::open (void)
{
  // for multiple threaded version, use blocked version of accept
  ACE_INET_Addr addr ((unsigned short)0);

  if (listener_.open (addr, 1) == -1)
    return -1;
#if !defined (CMLOG_USE_THREAD) || !defined (_REENTRANT)
  else if (listener_.enable (O_NONBLOCK) == -1)
    return -1;
#endif
  else
    return 0;
}

unsigned short
cmlogAcceptor::port_number (void)
{
  ACE_INET_Addr addr;
  listener_.get_local_addr (addr);
  // get port number already has right order
  return addr.get_port_number();
}

int
cmlogAcceptor::setSockOption (int level, int option, void *optval,
			      int optlen) const
{
  return listener_.set_option (level, option, optval, optlen);
}

int
cmlogAcceptor::numberConnections (void)
{
  return connectionList_.count ();
}

int
cmlogAcceptor::remove (cmlogIO* client)
{
  return connectionList_.remove ((void *)client);
}

int
cmlogAcceptor::includes (cmlogIO* client)
{
  return connectionList_.includes ((void *)client);
}

void
cmlogAcceptor::sendToAllConnections (int command, cdevData& data, long id)
{
  cmlogSlistIterator ite (connectionList_);
  cmlogIO* cio = 0;

  for (ite.init (); !ite; ++ite) {
    cio = (cmlogIO *) ite ();
    cio->sendToPeer (command, data, id);
  }
}

void
cmlogAcceptor::deleteAllConnections (void)
{
  cmlogSlistIterator ite (connectionList_);
  cmlogIO* cio = 0;

  for (ite.init (); !ite; ++ite) {
    cio = (cmlogIO *) ite ();
    delete cio;
  }
}

cmlogSlist&
cmlogAcceptor::connectionList (void)
{
  return connectionList_;
}
