/* test program for logging client inside ISR C -inetrface */
#include <stdio.h>
#include <cmlog.h>
#include <unistd.h>
#include <wdLib.h>

#define DELAY_PERIOD 1

static WDOG_ID wdid;

char* temp="Error Happened inside my ISR C interface routine";
char* facility = "CODA";

static int
myWdIsr (cmlog_client_t client)
{
  static int count = 0;
  int status;
  
  status = cmlog_logtextI (client, "verbosity=%d severity=%d code=%d facility=%s highVIn = %d highVOut = %d text = %s", 
			    43, 12, CMLOG_ERROR, (int)facility,
			    count*2, count*100, (int)temp, 0, 0, 0); 
  count++;


  wdStart (wdid, sysClkRateGet () *DELAY_PERIOD, (void *)&myWdIsr, (int)client);
}

int isrTest (char* name)
{
  int status;
  cmlog_client_t client;

  client = cmlog_open (name);
  if (client == 0) {
    fprintf (stderr, "Cannot open cmlog\n");
    return;
  }

  printf ("open to client daemon success\n");

  wdid = wdCreate ();
  wdStart (wdid, DELAY_PERIOD, (void *)&myWdIsr, (int)client);

  for (;;)
    taskDelay (sysClkRateGet()*10);
}


int myWdShutdown (void)
{
  int status;

  status = wdCancel (wdid);
}
