//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Simple Process Manager
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cpProcessManager.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:10  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:48  bickley
// Added cmlog to application development system.
//
//
#ifndef _CP_PROCESS_MANAGER
#define _CP_PROCESS_MANAGER

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <sys/types.h>
#include <unistd.h>

typedef void* (*CP_PROCESS_FUNC) (void *);

class cpProcessManager
{
public:
  enum {DEFAULT_SIZE = 100};
  
  // constructor and destructor
  cpProcessManager  (size_t size = cpProcessManager::DEFAULT_SIZE);
  ~cpProcessManager (void);

  // spawn a single process
  int spawn (CP_PROCESS_FUNC func, void *arg, pid_t *pid);

  // spawn a detached process
  int spawn_detached (CP_PROCESS_FUNC func, void *arg, pid_t *pid);

  static int spawn_detached_process (CP_PROCESS_FUNC func, 
				     void *arg, pid_t *pid);

  // spawn a N processes
  int spawn_n (int n, CP_PROCESS_FUNC func,
	       void* arg);

  // spawn a N detached processes
  int spawn_n_detached (int n, CP_PROCESS_FUNC func,
			void* arg);

  // send signal to pid, if pid == 0, to all
  int sendSignal (int signum, pid_t pid = 0);

  // check whether a process is detached process or not
  int detached   (pid_t pid);

private:
  // all data area
  pid_t* pids_;
  int    numProcesses_;
  size_t size_;
};
#endif
