//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of cmlogUptimeData Class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogUptimeData.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:10  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:41  bickley
// Added cmlog to application development system.
//
//
//
#include <cmlogUtil.h>
#include "cmlogUptimeData.h"

cmlogUptimeData::cmlogUptimeData (char* name)
:cmlogData (name)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogUptimeData Class Object\n");
#endif
  struct timeval tv;
  gettimeofday (&tv, 0);
  itime_ = tv.tv_sec + (tv.tv_usec)/1000000.0;
}

cmlogUptimeData::cmlogUptimeData (char* name, const cdevData& data)
:cmlogData (name, data)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogUptimeData Class Object\n");
#endif
  struct timeval tv;
  gettimeofday (&tv, 0);
  itime_ = tv.tv_sec + (tv.tv_usec)/1000000.0;
}

cmlogUptimeData::~cmlogUptimeData (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cmlogUptimeData Class Object\n");
#endif
}

void
cmlogUptimeData::update (void)
{
#ifdef CMLOG_USE_THREAD
  cpMutexGuard guard (lock_);
#endif
  struct timeval tv;
  gettimeofday (&tv, 0);
  double ftime = tv.tv_sec + (tv.tv_usec)/1000000.0;
  
  data_.remove ();
  data_.insert (cmlogUtil::CMLOG_VALUE_TAG, (ftime - itime_));
}

